/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.sheet.properties.StringProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignScriptlet;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ScriptletNode
extends IRAbstractNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    private JRDesignScriptlet scriptlet = null;

    public ScriptletNode(JasperDesign jd, JRDesignScriptlet scriptlet, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, scriptlet})}));
        this.jd = jd;
        this.scriptlet = scriptlet;
        this.setDisplayName(scriptlet.getName());
        super.setName(scriptlet.getName());
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/scriptlet-16.png");
        scriptlet.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public String getDisplayName() {
        return this.scriptlet.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        set.put((Node.Property)new NameProperty(this.getScriptlet(), dataset));
        set.put((Node.Property)new ValueClassNameProperty(this.getScriptlet(), dataset));
        set.put((Node.Property)new DescriptionProperty(this.getScriptlet()));
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return !this.scriptlet.getName().equals("REPORT");
    }

    public boolean canRename() {
        return !this.scriptlet.getName().equals("REPORT");
    }

    public boolean canDestroy() {
        return !this.scriptlet.getName().equals("REPORT");
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public void destroy() throws IOException {
        if (this.getParentNode() == null) {
            return;
        }
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        if (dataset != null) {
            dataset.removeScriptlet(this.getScriptlet().getName());
            dataset.getEventSupport().firePropertyChange("scriptlets", null, null);
        }
        super.destroy();
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        return tras;
    }

    public void setName(String s) {
        if (s.equals("") || s.equals("REPORT")) {
            throw new IllegalArgumentException("Scriptlet name not valid.");
        }
        List currentScriptlets = null;
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        currentScriptlets = dataset.getScriptletsList();
        for (JRDesignScriptlet p : currentScriptlets) {
            if (p == this.getScriptlet() || !p.getName().equals(s)) continue;
            throw new IllegalArgumentException("Scriptlet name already in use.");
        }
        String oldName = this.getScriptlet().getName();
        this.getScriptlet().setName(s);
        dataset.getScriptletsMap().remove(oldName);
        dataset.getScriptletsMap().put(s, this.getScriptlet());
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getScriptlet(), "Name", String.class, oldName, s);
        IReportManager.getInstance().addUndoableEdit(opue);
    }

    public JRDesignScriptlet getScriptlet() {
        return this.scriptlet;
    }

    public void setScriptlet(JRDesignScriptlet scriptlet) {
        this.scriptlet = scriptlet;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getScriptlet().getName());
            this.setDisplayName(this.getScriptlet().getName());
        }
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public class DescriptionProperty
    extends StringProperty {
        JRDesignScriptlet scriptlet;
        PropertyEditor editor;

        public DescriptionProperty(JRDesignScriptlet scriptlet) {
            super(scriptlet);
            this.scriptlet = null;
            this.editor = null;
            this.setName("description");
            this.setDisplayName(I18n.getString("ScriptletNode.Property.ScriptletDescription"));
            this.setShortDescription(I18n.getString("ScriptletNode.Property.ScriptletDescription"));
            this.scriptlet = scriptlet;
        }

        public boolean canWrite() {
            return !this.scriptlet.getName().equals("REPORT");
        }

        public String getString() {
            return this.scriptlet.getDescription();
        }

        public String getOwnString() {
            return this.scriptlet.getDescription();
        }

        public String getDefaultString() {
            return "";
        }

        public void setString(String value) {
            this.scriptlet.setDescription(value);
        }
    }

    public class ValueClassNameProperty
    extends StringProperty {
        JRDesignScriptlet scriptlet;
        PropertyEditor editor;
        JRDesignDataset dataset;

        public ValueClassNameProperty(JRDesignScriptlet scriptlet, JRDesignDataset dataset) {
            super(scriptlet);
            this.scriptlet = null;
            this.editor = null;
            this.dataset = null;
            this.setName("valueClassName");
            this.setDisplayName(I18n.getString("ScriptletNode.Property.ScriptletClass"));
            this.setShortDescription(I18n.getString("ScriptletNode.Property.ScriptletClass"));
            this.scriptlet = scriptlet;
            this.dataset = dataset;
        }

        public String getString() {
            if (this.scriptlet.getName().equals("REPORT")) {
                return this.dataset.getScriptletClass();
            }
            return this.scriptlet.getValueClassName();
        }

        public String getOwnString() {
            return this.getString();
        }

        public String getDefaultString() {
            return "";
        }

        public boolean supportsDefaultValue() {
            return false;
        }

        public void setString(String value) {
            if (this.scriptlet.getName().equals("REPORT")) {
                this.dataset.setScriptletClass(value);
                this.scriptlet.setValueClassName(value);
            } else {
                this.scriptlet.setValueClassName(value);
                JRDesignParameter p = (JRDesignParameter)this.dataset.getParametersMap().get(this.scriptlet.getName() + "_SCRIPTLET");
                if (p != null) {
                    p.setValueClassName(value);
                }
            }
        }
    }

    public static final class NameProperty
    extends PropertySupport.ReadWrite {
        JRDesignScriptlet scriptlet = null;
        JRDesignDataset dataset = null;

        public NameProperty(JRDesignScriptlet scriptlet, JRDesignDataset dataset) {
            super("name", String.class, I18n.getString("ScriptletNode.Property.Name"), I18n.getString("ScriptletNode.Property.Namedetail"));
            this.scriptlet = scriptlet;
            this.dataset = dataset;
            this.setValue("oneline", Boolean.TRUE);
        }

        public boolean canWrite() {
            return !this.getScriptlet().getName().equals("REPORT");
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getScriptlet().getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("ScriptletNode.Property.NameInvalid"));
                throw iae;
            }
            String s = val + "";
            List currentScriptlets = null;
            currentScriptlets = this.getDataset().getScriptletsList();
            for (JRDesignScriptlet p : currentScriptlets) {
                if (p == this.getScriptlet() || !p.getName().equals(s)) continue;
                IllegalArgumentException iae = this.annotateException(I18n.getString("ScriptletNode.Property.NameInUse"));
                throw iae;
            }
            String oldName = this.getScriptlet().getName();
            this.getScriptlet().setName(s);
            this.dataset.getScriptletsMap().remove(oldName);
            this.dataset.getScriptletsMap().put(s, this.getScriptlet());
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getScriptlet(), "Name", String.class, oldName, this.getScriptlet().getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public JRDesignDataset getDataset() {
            return this.dataset;
        }

        public void setDataset(JRDesignDataset dataset) {
            this.dataset = dataset;
        }

        public JRDesignScriptlet getScriptlet() {
            return this.scriptlet;
        }

        public void setScriptlet(JRDesignScriptlet scriptlet) {
            this.scriptlet = scriptlet;
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }
}

