/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.NewTypesUtils;
import com.jaspersoft.ireport.designer.outline.nodes.GroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.GroupsChildren;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class GroupsNode
extends IRIndexedNode
implements PropertyChangeListener {
    private JasperDesign jd = null;
    private JRDesignDataset dataset = null;

    public GroupsNode(JasperDesign jd, Lookup doLkp) {
        this(jd, (JRDesignDataset)jd.getMainDataset(), doLkp);
    }

    public GroupsNode(JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        this(new GroupsChildren(jd, dataset, doLkp), jd, dataset, doLkp);
    }

    public GroupsNode(GroupsChildren pc, JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, dataset})}));
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                List list = GroupsNode.this.getDataset().getGroupsList();
                ArrayList<JRDesignGroup> newList = new ArrayList<JRDesignGroup>();
                for (int i = 0; i < list.size(); ++i) {
                    JRDesignGroup p = (JRDesignGroup)list.get(i);
                }
                Node[] nodes = GroupsNode.this.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    JRDesignGroup p = ((GroupNode)nodes[i]).getGroup();
                    newList.add(p);
                }
                list.clear();
                list.addAll(newList);
                GroupsNode.this.getDataset().getEventSupport().firePropertyChange(new PropertyChangeEvent(GroupsNode.this.getDataset(), "groups", null, null));
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        this.jd = jd;
        if (dataset == null) {
            dataset = jd.getMainDesignDataset();
        }
        this.dataset = dataset;
        dataset.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.setDisplayName(I18n.getString("GroupNode.Property.Groups"));
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/groups-16.png");
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignGroup group;
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        final int dropAction = DnDUtilities.getTransferAction(t);
        int insertAt = index;
        if (null != dropNode && null != (group = (JRDesignGroup)dropNode.getLookup().lookup(JRDesignGroup.class))) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    List list = GroupsNode.this.getDataset().getGroupsList();
                    int currentIndex = -1;
                    int lastSystemDefinedVariableIndex = -1;
                    for (int i = 0; i < list.size(); ++i) {
                        JRDesignGroup p = (JRDesignGroup)list.get(i);
                        if (p != group) continue;
                        currentIndex = i;
                    }
                    if ((dropAction & 6) != 0) {
                        int newIndex = -1;
                        if (currentIndex != -1) {
                            Node[] nodes = GroupsNode.this.getChildren().getNodes();
                            for (int i = 0; i < nodes.length; ++i) {
                                if (((GroupNode)nodes[i]).getGroup() != group) continue;
                                newIndex = i;
                                break;
                            }
                            list.remove(group);
                            if (newIndex == -1) {
                                list.add(group);
                            } else {
                                list.add(Math.max(newIndex, lastSystemDefinedVariableIndex + 1), group);
                            }
                        }
                    } else {
                        try {
                            JRDesignGroup newGroup = ModelUtils.cloneGroup(group);
                            GroupsNode.this.getDataset().addGroup(newGroup);
                        }
                        catch (JRException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(PasteAction.class), SystemAction.get(ReorderAction.class)};
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRDesignDataset dataset) {
        this.dataset = dataset;
    }

    public NewType[] getNewTypes() {
        return NewTypesUtils.getNewType((Node)this, 10);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }
}

