/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ElementGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.undo.AddElementGroupUndoableEdit;
import com.jaspersoft.ireport.designer.undo.AddElementUndoableEdit;
import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import com.jaspersoft.ireport.designer.undo.DeleteElementGroupUndoableEdit;
import com.jaspersoft.ireport.designer.undo.DeleteElementUndoableEdit;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.List;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.PasteType;

public class ElementPasteType
extends PasteType {
    JRElementGroup newContainer = null;
    JRElementGroup oldContainer = null;
    Object element = null;
    int dropAction = 0;
    Node destinatioNode = null;
    AggregatedUndoableEdit unduableEdit = new AggregatedUndoableEdit("paste");

    public ElementPasteType(JRElementGroup oldContainer, JRElementGroup newContainer, Object element, int dropAction, Node destinatioNode) {
        this.oldContainer = oldContainer;
        this.newContainer = newContainer;
        this.element = element;
        this.dropAction = dropAction;
        this.destinatioNode = destinatioNode;
    }

    public Transferable paste() throws IOException {
        List list = this.newContainer.getChildren();
        int currentIndex = -1;
        for (int i = 0; i < list.size(); ++i) {
            Object ele = list.get(i);
            if (ele != this.element) continue;
            currentIndex = i;
        }
        if ((this.dropAction & 6) != 0) {
            int newIndex = -1;
            if (currentIndex == -1) {
                Node[] nodes = this.destinatioNode.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    if (nodes[i] instanceof ElementNode && ((ElementNode)nodes[i]).getElement() == this.element) {
                        newIndex = i;
                        break;
                    }
                    if (!(nodes[i] instanceof ElementGroupNode) || ((ElementGroupNode)nodes[i]).getElementGroup() != this.element) continue;
                    newIndex = i;
                    break;
                }
                if (this.element instanceof JRDesignElement) {
                    this.removeElement(this.oldContainer, (JRDesignElement)this.element);
                } else if (this.element instanceof JRDesignElementGroup) {
                    this.removeElementGroup(this.oldContainer, (JRDesignElementGroup)this.element);
                }
                if (newIndex == -1) {
                    if (this.element instanceof JRDesignElement) {
                        this.addElement(this.newContainer, (JRDesignElement)this.element);
                    } else if (this.element instanceof JRDesignElementGroup) {
                        this.addElementGroup(this.newContainer, (JRDesignElementGroup)this.element);
                    }
                } else {
                    if (this.element instanceof JRDesignElement) {
                        ((JRDesignElement)this.element).setElementGroup(this.newContainer);
                    } else if (this.element instanceof JRDesignElementGroup) {
                        ((JRDesignElementGroup)this.element).setElementGroup(this.newContainer);
                    }
                    this.newContainer.getChildren().add(newIndex, this.element);
                    this.getEventSupport(this.newContainer).fireCollectionElementAddedEvent("children", this.element, this.newContainer.getChildren().size() - 1);
                    IReportManager.getInstance().setSelectedObject(this.element);
                }
            }
        } else if (this.element instanceof JRCloneable) {
            Object newElement = ((JRCloneable)this.element).clone();
            if (newElement instanceof JRDesignElement) {
                this.addElement(this.newContainer, (JRDesignElement)newElement);
            } else if (newElement instanceof JRDesignElementGroup) {
                this.addElementGroup(this.newContainer, (JRDesignElementGroup)newElement);
            }
        }
        if (this.unduableEdit.getAggregatedEditCount() > 0) {
            IReportManager.getInstance().addUndoableEdit(this.unduableEdit, true);
        }
        return null;
    }

    private void removeElement(JRElementGroup container, JRDesignElement element) {
        int index = 0;
        if (container instanceof JRDesignElementGroup) {
            index = ((JRDesignElementGroup)container).getChildren().indexOf(element);
            ((JRDesignElementGroup)container).removeElement(element);
        } else if (container instanceof JRDesignFrame) {
            index = ((JRDesignFrame)container).getChildren().indexOf(element);
            ((JRDesignFrame)container).removeElement((JRElement)element);
        }
        DeleteElementUndoableEdit edit = new DeleteElementUndoableEdit(element, container, index);
        this.unduableEdit.concatenate(edit);
    }

    private void removeElementGroup(JRElementGroup container, JRDesignElementGroup group) {
        int index = 0;
        if (container instanceof JRDesignElementGroup) {
            index = ((JRDesignElementGroup)container).getChildren().indexOf(group);
            ((JRDesignElementGroup)container).removeElementGroup(group);
        } else if (container instanceof JRDesignFrame) {
            index = ((JRDesignFrame)container).getChildren().indexOf(group);
            ((JRDesignFrame)container).removeElementGroup((JRElementGroup)group);
        }
        DeleteElementGroupUndoableEdit edit = new DeleteElementGroupUndoableEdit(group, container, index);
        this.unduableEdit.concatenate(edit);
    }

    private void addElement(JRElementGroup container, JRDesignElement element) {
        if (container instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)container).addElement(element);
        } else if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).addElement((JRElement)element);
        }
        AddElementUndoableEdit edit = new AddElementUndoableEdit(element, container);
        this.unduableEdit.concatenate(edit);
    }

    private void addElementGroup(JRElementGroup container, JRDesignElementGroup group) {
        if (container instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)container).addElementGroup(group);
        } else if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).addElementGroup((JRElementGroup)group);
        }
        AddElementGroupUndoableEdit edit = new AddElementGroupUndoableEdit(group, container);
        this.unduableEdit.concatenate(edit);
    }

    private JRPropertyChangeSupport getEventSupport(JRElementGroup container) {
        if (container instanceof JRDesignElementGroup) {
            return ((JRDesignElementGroup)container).getEventSupport();
        }
        if (container instanceof JRDesignFrame) {
            return ((JRDesignFrame)container).getEventSupport();
        }
        return null;
    }
}

