/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.NewTypesUtils;
import com.jaspersoft.ireport.designer.outline.nodes.CrosstabParameterNode;
import com.jaspersoft.ireport.designer.outline.nodes.CrosstabParametersChildren;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.outline.nodes.ParameterNode;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class CrosstabParametersNode
extends IRIndexedNode
implements PropertyChangeListener {
    private JasperDesign jd = null;
    private JRDesignCrosstab crosstab = null;

    public CrosstabParametersNode(JasperDesign jd, JRDesignCrosstab crosstab, Lookup doLkp) {
        this(new CrosstabParametersChildren(jd, crosstab, doLkp), jd, crosstab, doLkp);
    }

    public CrosstabParametersNode(CrosstabParametersChildren pc, JasperDesign jd, JRDesignCrosstab crosstab, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, crosstab})}));
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                List list = CrosstabParametersNode.this.getCrosstab().getParametersList();
                ArrayList<JRDesignParameter> newList = new ArrayList<JRDesignParameter>();
                for (int i = 0; i < list.size(); ++i) {
                    JRDesignParameter p = (JRDesignParameter)list.get(i);
                    if (!p.isSystemDefined()) continue;
                    newList.add(p);
                }
                Node[] nodes = CrosstabParametersNode.this.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    JRDesignParameter p = ((ParameterNode)nodes[i]).getParameter();
                    if (p.isSystemDefined()) continue;
                    newList.add(p);
                }
                list.clear();
                list.addAll(newList);
                CrosstabParametersNode.this.getCrosstab().getEventSupport().firePropertyChange(new PropertyChangeEvent(CrosstabParametersNode.this.getCrosstab(), "parameters", null, null));
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        this.jd = jd;
        this.crosstab = crosstab;
        crosstab.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.setDisplayName("Parameters");
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/parameters-16.png");
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignCrosstabParameter parameter;
        final Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        final int dropAction = DnDUtilities.getTransferAction(t);
        if (null != dropNode && null != (parameter = (JRDesignCrosstabParameter)dropNode.getLookup().lookup(JRDesignCrosstabParameter.class))) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    if (parameter.isSystemDefined()) {
                        return null;
                    }
                    List list = CrosstabParametersNode.this.getCrosstab().getParametersList();
                    int currentIndex = -1;
                    int lastSystemDefinedParameterIndex = -1;
                    for (int i = 0; i < list.size(); ++i) {
                        JRDesignCrosstabParameter p = (JRDesignCrosstabParameter)list.get(i);
                        if (p == parameter) {
                            currentIndex = i;
                        }
                        if (!p.isSystemDefined()) continue;
                        lastSystemDefinedParameterIndex = i;
                    }
                    if ((dropAction & 6) != 0) {
                        int newIndex = -1;
                        if (currentIndex != -1) {
                            Node[] nodes = CrosstabParametersNode.this.getChildren().getNodes();
                            for (int i = 0; i < nodes.length; ++i) {
                                if (((CrosstabParameterNode)nodes[i]).getParameter() != parameter) continue;
                                newIndex = i;
                                break;
                            }
                            list.remove(parameter);
                            if (newIndex == -1) {
                                list.add(parameter);
                            } else {
                                list.add(Math.max(newIndex, lastSystemDefinedParameterIndex + 1), parameter);
                            }
                        } else {
                            try {
                                JRDesignCrosstabParameter newParam = ModelUtils.cloneCrosstabParameter(parameter);
                                Map map = CrosstabParametersNode.this.getCrosstab().getParametersMap();
                                int k = 1;
                                while (map.containsKey(newParam.getName())) {
                                    newParam.setName(parameter.getName() + "_" + k);
                                    ++k;
                                }
                                CrosstabParametersNode.this.getCrosstab().addParameter((JRCrosstabParameter)newParam);
                                if (dropNode.getParentNode() instanceof CrosstabParametersNode) {
                                    CrosstabParametersNode pn = (CrosstabParametersNode)dropNode.getParentNode();
                                    pn.getCrosstab().removeParameter((JRCrosstabParameter)parameter);
                                }
                            }
                            catch (JRException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    } else {
                        try {
                            JRDesignCrosstabParameter newParam = ModelUtils.cloneCrosstabParameter(parameter);
                            Map map = CrosstabParametersNode.this.getCrosstab().getParametersMap();
                            int k = 1;
                            while (map.containsKey(newParam.getName())) {
                                newParam.setName(parameter.getName() + "_" + k);
                                ++k;
                            }
                            CrosstabParametersNode.this.getCrosstab().addParameter((JRCrosstabParameter)newParam);
                        }
                        catch (JRException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(PasteAction.class), SystemAction.get(ReorderAction.class)};
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public NewType[] getNewTypes() {
        return NewTypesUtils.getNewType((Node)this, 5);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName().equals("parameters")) {
            ((CrosstabParametersChildren)this.getChildren()).recalculateKeys();
        }
    }

    public JRDesignCrosstab getCrosstab() {
        return this.crosstab;
    }
}

