/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrtx;

import com.jaspersoft.ireport.designer.jrtx.JRTXDataObject;
import com.jaspersoft.ireport.designer.jrtx.JRTXTextView;
import com.jaspersoft.ireport.designer.jrtx.JRTXVisualView;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.xml.JRXmlTemplateWriter;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JRTXEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditorCookie,
EditCookie,
SaveAsCapable {
    private static Logger LOG = Logger.getLogger(JRTXEditorSupport.class.getName());
    private InstanceContent specialNodeLookupIC = null;
    private Lookup specialNodeLookup = null;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            JRTXEditorSupport.this.saveDocument();
        }
    };
    final MultiViewDescription[] descriptions = new MultiViewDescription[]{new JRTXVisualView(this), new JRTXTextView(this)};
    private JRSimpleTemplate currentModel = null;

    protected Task reloadDocument() {
        ((JRTXVisualView)this.descriptions[0]).refreshModel();
        return super.reloadDocument();
    }

    public MultiViewDescription[] getDescriptions() {
        return this.descriptions;
    }

    private JRTXEditorSupport(JRTXDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new JRTXEnv(obj));
        this.specialNodeLookupIC = new InstanceContent();
        this.specialNodeLookupIC.add((Object)this);
        this.specialNodeLookup = new AbstractLookup((AbstractLookup.Content)this.specialNodeLookupIC);
    }

    public static JRTXEditorSupport create(JRTXDataObject obj) {
        JRTXEditorSupport ed = new JRTXEditorSupport(obj);
        ed.setMIMEType("text/xml");
        return ed;
    }

    protected CloneableEditorSupport.Pane createPane() {
        return (CloneableEditorSupport.Pane)MultiViewFactory.createCloneableMultiView((MultiViewDescription[])this.descriptions, (MultiViewDescription)this.descriptions[0]);
    }

    protected boolean notifyModified() {
        JRTXDataObject obj;
        boolean retValue = super.notifyModified();
        if (retValue && (obj = (JRTXDataObject)this.getDataObject()).getCookie(SaveCookie.class) == null) {
            obj.getIc().add((Object)this.saveCookie);
            this.specialNodeLookupIC.add((Object)this.saveCookie);
            obj.setModified(true);
        }
        return retValue;
    }

    public void notifyModelChangeToTheView() {
        if (this.getCurrentModel() != null) {
            ((JRTXVisualView)this.descriptions[0]).modelChanged();
            this.notifyModified();
        }
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        JRTXDataObject obj = (JRTXDataObject)this.getDataObject();
        SaveCookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getIc().remove((Object)this.saveCookie);
            this.specialNodeLookupIC.remove((Object)this.saveCookie);
            obj.setModified(false);
        }
    }

    public DataEditorSupport.Env getEnv() {
        return (DataEditorSupport.Env)this.env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument() throws IOException {
        if (this.getCurrentModel() != null) {
            JRSimpleTemplate jrtx = this.getCurrentModel();
            String content = null;
            try {
                content = JRXmlTemplateWriter.writeTemplate((JRTemplate)jrtx, (String)"UTF-8");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "Error saving the JRTX: " + ex.getMessage() + "\nSee the log file for more details.", "Error saving", 0);
                ex.printStackTrace();
                return;
            }
            if (content != null) {
                try {
                    this.getDocument().remove(0, this.getDocument().getLength());
                    this.getDocument().insertString(0, content, null);
                    ((JRTXVisualView)this.descriptions[0]).setNeedModelRefresh(false);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        Charset cs = FileEncodingQuery.getDefaultEncoding();
        String fileEncoding = System.getProperty("file.encoding", "UTF-8");
        try {
            FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            super.saveDocument();
        }
        finally {
            FileEncodingQuery.setDefaultEncoding((Charset)cs);
            System.setProperty("file.encoding", fileEncoding);
        }
    }

    public Lookup getSpecialNodeLookup() {
        return this.specialNodeLookup;
    }

    public void setSpecialNodeLookup(Lookup specialNodeLookup) {
        this.specialNodeLookup = specialNodeLookup;
    }

    public JRSimpleTemplate getCurrentModel() {
        return this.currentModel;
    }

    public void setCurrentModel(JRSimpleTemplate currentModel) {
        if (this.currentModel != null) {
            ((JRTXDataObject)this.getDataObject()).getIc().remove((Object)this.currentModel);
        }
        this.currentModel = currentModel;
        if (this.currentModel != null) {
            ((JRTXDataObject)this.getDataObject()).getIc().add((Object)this.currentModel);
        }
    }

    public static final class JRTXEnv
    extends DataEditorSupport.Env {
        public JRTXEnv(JRTXDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return super.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((JRTXDataObject)super.getDataObject()).getPrimaryEntry().takeLock();
        }
    }
}

