/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.GroupNode;
import com.jaspersoft.ireport.designer.undo.DeleteGroupUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class DeleteGroupAction
extends NodeAction {
    private static DeleteGroupAction instance = null;

    public static synchronized DeleteGroupAction getInstance() {
        if (instance == null) {
            instance = new DeleteGroupAction();
        }
        return instance;
    }

    private DeleteGroupAction() {
    }

    public String getName() {
        return I18n.getString("DeleteGroupAction.Name.CTL_DeleteGroupAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        GroupNode groupNode = (GroupNode)activatedNodes[0];
        JRDesignGroup grp = groupNode.getGroup();
        JRDesignDataset dataset = groupNode.getDataset();
        int index = dataset.getGroupsList().indexOf(grp);
        dataset.removeGroup((JRGroup)grp);
        IReportManager.getInstance().notifyReportChange();
        DeleteGroupUndoableEdit edit = new DeleteGroupUndoableEdit(grp, dataset, index);
        IReportManager.getInstance().addUndoableEdit(edit);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0] instanceof GroupNode && ((GroupNode)activatedNodes[0]).getGroup() != null;
    }
}

