/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ws.scheduling;

import com.jaspersoft.ireport.jasperserver.ws.scheduling.ReportScheduler;
import com.jaspersoft.ireport.jasperserver.ws.scheduling.ReportSchedulerServiceLocator;
import com.jaspersoft.ireport.jasperserver.ws.scheduling.ReportSchedulerSoapBindingStub;
import com.jaspersoft.ireport.jasperserver.ws.util.ResourceConfigurationProvider;
import com.jaspersoft.jasperserver.ws.scheduling.Job;
import com.jaspersoft.jasperserver.ws.scheduling.JobParameter;
import com.jaspersoft.jasperserver.ws.scheduling.JobSummary;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Locale;
import javax.xml.rpc.ServiceException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.message.SOAPHeaderElement;

public class ReportSchedulerFacade
implements ReportScheduler {
    private static final String NAMESPACE = "http://www.jasperforge.org/jasperserver/ws";
    private static final String HEADER_LOCALE = "locale";
    private static final String AXIS_CONFIGURATION_RESOURCE = "/com/jaspersoft/jasperserver/ws/scheduling/client-config.wsdd";
    private final ReportSchedulerSoapBindingStub service;

    public ReportSchedulerFacade(URL address, String user, String password) throws ServiceException {
        this.service = this.createServiceStub(address, user, password);
    }

    public ReportSchedulerFacade(ReportSchedulerSoapBindingStub serviceStub) {
        this.service = serviceStub;
    }

    protected ReportSchedulerSoapBindingStub createServiceStub(URL address, String user, String password) throws ServiceException {
        ReportSchedulerServiceLocator locator = new ReportSchedulerServiceLocator(this.getEngineConfiguration());
        ReportSchedulerSoapBindingStub stub = (ReportSchedulerSoapBindingStub)locator.getReportScheduler(address);
        stub.setUsername(user);
        stub.setPassword(password);
        stub.setMaintainSession(true);
        return stub;
    }

    public void setLocale(Locale locale) {
        this.setLocale(locale.toString());
    }

    protected void setLocale(String locale) {
        SOAPHeaderElement localeHeader = new SOAPHeaderElement(NAMESPACE, HEADER_LOCALE, (Object)locale);
        localeHeader.setActor(null);
        this.service.setHeader(localeHeader);
    }

    protected EngineConfiguration getEngineConfiguration() {
        return new ResourceConfigurationProvider(AXIS_CONFIGURATION_RESOURCE);
    }

    public void deleteJob(long id) throws RemoteException {
        this.service.deleteJob(id);
    }

    public void deleteJobs(long[] ids) throws RemoteException {
        this.service.deleteJobs(ids);
    }

    public JobSummary[] getAllJobs() throws RemoteException {
        return this.service.getAllJobs();
    }

    public Job getJob(long id) throws RemoteException {
        return this.processJob(this.service.getJob(id));
    }

    public JobSummary[] getReportJobs(String reportURI) throws RemoteException {
        return this.service.getReportJobs(reportURI);
    }

    public Job scheduleJob(Job job) throws RemoteException {
        return this.processJob(this.service.scheduleJob(job));
    }

    public Job updateJob(Job job) throws RemoteException {
        return this.processJob(this.service.updateJob(job));
    }

    protected Job processJob(Job job) {
        if (job != null) {
            this.processJobParameters(job);
        }
        return job;
    }

    protected void processJobParameters(Job job) {
        JobParameter[] parameters = job.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                JobParameter parameter = parameters[i];
                this.processJobParameter(parameter);
            }
        }
    }

    protected void processJobParameter(JobParameter parameter) {
        Object value = parameter.getValue();
        if (value instanceof Calendar) {
            parameter.setValue((Object)((Calendar)value).getTime());
        }
    }
}

