/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.nodes;

import com.jaspersoft.ireport.designer.dnd.ReportObjectPaletteTransferable;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.jasperserver.RepositoryFile;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.ui.actions.DeleteAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.ImportDatasourceAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.OpenFileAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.PropertiesAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.RefreshAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.ReplaceFileAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.RunReportUnitAction;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ReportUnitNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class FileNode
extends IRAbstractNode
implements ResourceNode {
    static ImageIcon datasourceJndiIcon;
    static ImageIcon datasourceJdbcIcon;
    static ImageIcon datasourceBeanIcon;
    static ImageIcon datasourceIcon;
    static ImageIcon imageIcon;
    static ImageIcon jrxmlIcon;
    static ImageIcon fontIcon;
    static ImageIcon jarIcon;
    static ImageIcon refIcon;
    static ImageIcon bundleIcon;
    static ImageIcon inputcontrolIcon;
    static ImageIcon datatypeIcon;
    static ImageIcon lovIcon;
    static ImageIcon unknowIcon;
    static ImageIcon queryIcon;
    static ImageIcon waitingIcon;
    static ImageIcon reportOptionsResourceIcon;
    private RepositoryFile file = null;

    public FileNode(RepositoryFile file, Lookup doLkp) {
        super(Children.LEAF, doLkp);
        this.file = file;
    }

    public String getDisplayName() {
        return this.getFile().getDescriptor().getLabel();
    }

    public Image getIcon(int arg0) {
        return FileNode.getResourceIcon(this.getFile().getDescriptor()).getImage();
    }

    public boolean hasCustomizer() {
        return false;
    }

    public static ImageIcon getResourceIcon(ResourceDescriptor resource) {
        if (resource == null) {
            return unknowIcon;
        }
        if (resource.getWsType() == null) {
            return unknowIcon;
        }
        if (resource.getIsReference()) {
            return refIcon;
        }
        if (resource.getWsType().equals("jndi")) {
            return datasourceJndiIcon;
        }
        if (resource.getWsType().equals("jdbc")) {
            return datasourceJdbcIcon;
        }
        if (resource.getWsType().equals("bean")) {
            return datasourceBeanIcon;
        }
        if (resource.getWsType().equals("olapXmlaCon")) {
            return datasourceIcon;
        }
        if (resource.getWsType().equals("img")) {
            return imageIcon;
        }
        if (resource.getWsType().equals("jrxml")) {
            return jrxmlIcon;
        }
        if (resource.getWsType().equals("font")) {
            return fontIcon;
        }
        if (resource.getWsType().equals("jar")) {
            return jarIcon;
        }
        if (resource.getWsType().equals("prop")) {
            return bundleIcon;
        }
        if (resource.getWsType().equals("inputControl")) {
            return inputcontrolIcon;
        }
        if (resource.getWsType().equals("dataType")) {
            return datatypeIcon;
        }
        if (resource.getWsType().equals("lov")) {
            return lovIcon;
        }
        if (resource.getWsType().equals("query")) {
            return queryIcon;
        }
        if (resource.getWsType().equals("ReportOptionsResource")) {
            return reportOptionsResourceIcon;
        }
        return unknowIcon;
    }

    public RepositoryFile getFile() {
        return this.file;
    }

    public void setFile(RepositoryFile file) {
        this.file = file;
    }

    public Action[] getActions(boolean arg0) {
        ArrayList<SystemAction> actions = new ArrayList<SystemAction>();
        actions.add(SystemAction.get(OpenFileAction.class));
        if (this.getFile().getDescriptor().getWsType().equals("jrxml")) {
            actions.add(SystemAction.get(ReplaceFileAction.class));
        }
        actions.add(SystemAction.get(DeleteAction.class));
        if (ReportUnitNode.getParentReportUnit((Node)this) != null) {
            actions.add(null);
            actions.add(SystemAction.get(RunReportUnitAction.class));
        }
        if (this.getFile().getDescriptor().getWsType().equals("jdbc")) {
            actions.add(SystemAction.get(ImportDatasourceAction.class));
        }
        actions.add(null);
        actions.add(SystemAction.get(RefreshAction.class));
        actions.add(SystemAction.get(PropertiesAction.class));
        return actions.toArray(new Action[actions.size()]);
    }

    public Action getPreferredAction() {
        return SystemAction.get(PropertiesAction.class);
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.getFile().getDescriptor();
    }

    public RepositoryFolder getRepositoryObject() {
        return this.getFile();
    }

    public void refreshChildrens(boolean b) {
    }

    public void updateDisplayName() {
        this.fireDisplayNameChange(null, null);
    }

    public void removeChildren(Node[] nodes) {
        this.getChildren().remove(nodes);
        this.fireNodeDestroyed();
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        if (this.getFile().getDescriptor().getWsType().equals("img")) {
            tras.put((ExTransferable.Single)new ReportObjectPaletteTransferable("com.jaspersoft.ireport.jasperserver.ui.actions.CreateImageAction", (Object)this.getFile()));
        }
        return tras;
    }

    static {
        if (datasourceJndiIcon == null) {
            datasourceJndiIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datasource_jndi.png"));
        }
        if (datasourceIcon == null) {
            datasourceIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datasource.png"));
        }
        if (datasourceJdbcIcon == null) {
            datasourceJdbcIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datasource_jdbc.png"));
        }
        if (imageIcon == null) {
            imageIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/picture.png"));
        }
        if (jrxmlIcon == null) {
            jrxmlIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/jrxml_file.png"));
        }
        if (refIcon == null) {
            refIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/link.png"));
        }
        if (bundleIcon == null) {
            bundleIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/bundle.png"));
        }
        if (fontIcon == null) {
            fontIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/font.png"));
        }
        if (jarIcon == null) {
            jarIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/jar.png"));
        }
        if (inputcontrolIcon == null) {
            inputcontrolIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/inputcontrol.png"));
        }
        if (datatypeIcon == null) {
            datatypeIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datatype.png"));
        }
        if (lovIcon == null) {
            lovIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/lov.png"));
        }
        if (datasourceBeanIcon == null) {
            datasourceBeanIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datasource_bean.png"));
        }
        if (unknowIcon == null) {
            unknowIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/unknow.png"));
        }
        if (queryIcon == null) {
            queryIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/query.png"));
        }
        if (waitingIcon == null) {
            waitingIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/waiting.png"));
        }
        if (reportOptionsResourceIcon == null) {
            reportOptionsResourceIcon = new ImageIcon(FileNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/reportunit_options.png"));
        }
    }
}

