/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.actions;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JDBCConnection;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class ImportDatasourceAction
extends NodeAction {
    private static List jrxmlListeners = new ArrayList();

    public String getName() {
        return NbBundle.getMessage(ImportDatasourceAction.class, (String)"CTL_ImportDatasourceAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node node = activatedNodes[i];
            ResourceDescriptor rd = ((ResourceNode)node).getResourceDescriptor();
            int ds_count = 0;
            if (rd.getWsType().equals("jdbc")) {
                boolean skipDs = false;
                List conns = IReportManager.getInstance().getConnections();
                int index = -1;
                for (IReportConnection con : conns) {
                    if (!con.getName().equals(rd.getLabel())) continue;
                    if (JOptionPane.showConfirmDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("repositoryExplorer.message.duplicatedConnectionName", "A connection named {0} is already present.\nWould you like to replace the existing connection?", new Object[]{rd.getLabel()})) != 0) {
                        skipDs = true;
                        break;
                    }
                    IReportManager.getInstance().removeConnection(con);
                    break;
                }
                if (skipDs) continue;
                JDBCConnection jdbcConnection = new JDBCConnection();
                jdbcConnection.setName(rd.getLabel());
                jdbcConnection.setUrl(rd.getConnectionUrl());
                jdbcConnection.setJDBCDriver(rd.getDriverClass());
                jdbcConnection.setUsername(rd.getUsername());
                jdbcConnection.setPassword(rd.getPassword());
                IReportManager.getInstance().addConnection((IReportConnection)jdbcConnection);
                IReportManager.getInstance().setDefaultConnection((IReportConnection)jdbcConnection);
                ++ds_count;
            }
            if (ds_count <= 0) continue;
            JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("repositoryExplorer.message.connectionImported", "{0} connection(s) succefully imported in iReport.", new Object[]{ds_count}), "", 1);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length < 1) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (!(activatedNodes[i] instanceof ResourceNode)) {
                return false;
            }
            ResourceNode node = (ResourceNode)activatedNodes[i];
            if (node.getResourceDescriptor() != null && node.getResourceDescriptor().getWsType().equals("jdbc")) continue;
            return false;
        }
        return true;
    }
}

