/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.spring;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import net.sf.jasperreports.charts.ChartContext;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.chartthemes.spring.ChartThemesConstants;
import net.sf.jasperreports.chartthemes.spring.ChartThemesUtilities;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.VerticalAlignment;
import org.jfree.util.UnitType;

public class GenericChartTheme
implements net.sf.jasperreports.charts.ChartTheme {
    protected Map defaultChartPropertiesMap;
    protected Map defaultPlotPropertiesMap;
    protected Map defaultAxisPropertiesMap;
    protected Map defaultChartTypePropertiesMap;
    protected ChartContext chartContext = null;

    protected GenericChartTheme() {
    }

    protected JRChart getChart() {
        return this.chartContext.getChart();
    }

    protected JRChartPlot getPlot() {
        return this.getChart().getPlot();
    }

    protected Dataset getDataset() {
        return this.chartContext.getDataset();
    }

    protected Object getLabelGenerator() {
        return this.chartContext.getLabelGenerator();
    }

    protected Locale getLocale() {
        return this.chartContext.getLocale();
    }

    protected final Object evaluateExpression(JRExpression expression) throws JRException {
        return this.chartContext.evaluateExpression(expression);
    }

    public JFreeChart createChart(ChartContext chartContext) throws JRException {
        this.chartContext = chartContext;
        JFreeChart jfreeChart = null;
        switch (this.getChart().getChartType()) {
            case 1: {
                jfreeChart = this.createAreaChart();
                break;
            }
            case 3: {
                jfreeChart = this.createBarChart();
                break;
            }
            case 2: {
                jfreeChart = this.createBar3DChart();
                break;
            }
            case 4: {
                jfreeChart = this.createBubbleChart();
                break;
            }
            case 5: {
                jfreeChart = this.createCandlestickChart();
                break;
            }
            case 6: {
                jfreeChart = this.createHighLowChart();
                break;
            }
            case 7: {
                jfreeChart = this.createLineChart();
                break;
            }
            case 17: {
                jfreeChart = this.createMeterChart();
                break;
            }
            case 19: {
                break;
            }
            case 9: {
                jfreeChart = this.createPieChart();
                break;
            }
            case 8: {
                jfreeChart = this.createPie3DChart();
                break;
            }
            case 10: {
                jfreeChart = this.createScatterChart();
                break;
            }
            case 12: {
                jfreeChart = this.createStackedBarChart();
                break;
            }
            case 11: {
                jfreeChart = this.createStackedBar3DChart();
                break;
            }
            case 18: {
                jfreeChart = this.createThermometerChart();
                break;
            }
            case 16: {
                jfreeChart = this.createTimeSeriesChart();
                break;
            }
            case 13: {
                jfreeChart = this.createXyAreaChart();
                break;
            }
            case 14: {
                jfreeChart = this.createXYBarChart();
                break;
            }
            case 15: {
                jfreeChart = this.createXyLineChart();
                break;
            }
            case 20: {
                jfreeChart = this.createStackedAreaChart();
                break;
            }
            case 21: {
                jfreeChart = this.createGanttChart();
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + this.getChart().getChartType() + " not supported.");
            }
        }
        return jfreeChart;
    }

    protected void configureChart(JFreeChart jfreeChart, JRChartPlot jrPlot) throws JRException {
        Float defaultBaseFontSize = (Float)this.getDefaultValue(this.defaultChartPropertiesMap, "baseFontSize");
        this.setChartBackground(jfreeChart);
        this.setChartTitle(jfreeChart, defaultBaseFontSize);
        this.setChartSubtitles(jfreeChart, defaultBaseFontSize);
        this.setChartLegend(jfreeChart, defaultBaseFontSize);
        this.setChartBorder(jfreeChart);
        Boolean isAntiAlias = (Boolean)this.getDefaultValue(this.defaultChartPropertiesMap, "chartAntiAlias");
        if (isAntiAlias != null) {
            jfreeChart.setAntiAlias(isAntiAlias.booleanValue());
        }
        Double padding = (Double)this.getDefaultValue(this.defaultChartPropertiesMap, "chartPadding");
        UnitType unitType = (UnitType)this.getDefaultValue(this.defaultChartPropertiesMap, "unitType");
        if (padding != null && unitType != null) {
            double chartPadding = padding;
            jfreeChart.setPadding(new RectangleInsets(unitType, chartPadding, chartPadding, chartPadding, chartPadding));
        }
        this.configurePlot(jfreeChart.getPlot(), jrPlot);
    }

    protected void configurePlot(Plot p, JRChartPlot jrPlot) {
        RectangleInsets defaultPlotInsets = (RectangleInsets)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotInsets");
        Paint defaultPlotOutlinePaint = (Paint)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlinePaint");
        Stroke defaultPlotOutlineStroke = (Stroke)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlineStroke");
        Boolean defaultPlotOutlineVisible = (Boolean)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlineVisible");
        if (defaultPlotInsets != null) {
            p.setInsets(defaultPlotInsets);
        }
        if (defaultPlotOutlineVisible != null) {
            if (defaultPlotOutlineVisible.booleanValue()) {
                if (defaultPlotOutlinePaint != null) {
                    p.setOutlinePaint(defaultPlotOutlinePaint);
                }
                if (defaultPlotOutlineStroke != null) {
                    p.setOutlineStroke(defaultPlotOutlineStroke);
                }
                p.setOutlineVisible(true);
            } else {
                p.setOutlineVisible(false);
            }
        }
        this.setPlotBackground(p, jrPlot);
        if (p instanceof CategoryPlot) {
            this.handleCategoryPlotSettings((CategoryPlot)p, jrPlot);
        }
        this.setPlotDrawingDefaults(p, jrPlot);
    }

    protected void configureAxis(Axis axis, JRFont labelFont, Color labelColor, JRFont tickLabelFont, Color tickLabelColor, String tickLabelMask, Paint lineColor, boolean isRangeAxis) throws JRException {
        Boolean axisVisible = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisVisible");
        if (axisVisible != null && axisVisible.booleanValue()) {
            this.setAxisLine(axis, lineColor);
            Double defaultFixedDimension = (Double)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisFixedDimension");
            if (defaultFixedDimension != null) {
                axis.setFixedDimension(defaultFixedDimension.doubleValue());
            }
            this.setAxisLabel(axis, labelFont, labelColor);
            this.setAxisTickLabels(axis, tickLabelFont, tickLabelColor, tickLabelMask);
            this.setAxisTickMarks(axis, lineColor);
            String timePeriodUnit = isRangeAxis ? (String)this.getDefaultValue(this.defaultAxisPropertiesMap, "rangeAxisTimePeriodUnit") : (String)this.getDefaultValue(this.defaultAxisPropertiesMap, "domainAxisTimePeriodUnit");
            this.setAxisBounds(axis, isRangeAxis, timePeriodUnit);
        } else {
            axis.setVisible(false);
        }
    }

    protected JFreeChart createAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getOwnCategoryAxisLineColor(), false);
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getOwnValueAxisLineColor(), true);
        return jfreeChart;
    }

    protected JFreeChart createBar3DChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBarChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBar3DPlot bar3DPlot = (JRBar3DPlot)this.getPlot();
        BarRenderer3D barRenderer3D = new BarRenderer3D(bar3DPlot.getXOffsetDouble() == null ? 12.0 : bar3DPlot.getXOffsetDouble(), bar3DPlot.getYOffsetDouble() == null ? 8.0 : bar3DPlot.getYOffsetDouble());
        barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        barRenderer3D.setBaseItemLabelsVisible(bar3DPlot.getShowLabels());
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer3D);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getOwnCategoryAxisLineColor(), false);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getOwnValueAxisLineColor(), true);
        return jfreeChart;
    }

    protected JFreeChart createBarChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getOwnCategoryAxisLineColor(), false);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getOwnValueAxisLineColor(), true);
        BarRenderer categoryRenderer = (BarRenderer)categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(barPlot.getShowLabels() == null ? false : barPlot.getShowLabels());
        categoryRenderer.setShadowVisible(false);
        return jfreeChart;
    }

    protected JFreeChart createBubbleChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBubbleChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression())), (XYZDataset)((XYZDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRBubblePlot bubblePlot = (JRBubblePlot)this.getPlot();
        int scaleType = bubblePlot.getScaleTypeInteger() == null ? 2 : bubblePlot.getScaleTypeInteger();
        XYBubbleRenderer bubbleRenderer = new XYBubbleRenderer(scaleType);
        xyPlot.setRenderer((XYItemRenderer)bubbleRenderer);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), bubblePlot.getXAxisLabelFont(), bubblePlot.getXAxisLabelColor(), bubblePlot.getXAxisTickLabelFont(), bubblePlot.getXAxisTickLabelColor(), bubblePlot.getXAxisTickLabelMask(), bubblePlot.getOwnXAxisLineColor(), false);
        this.configureAxis((Axis)xyPlot.getRangeAxis(), bubblePlot.getYAxisLabelFont(), bubblePlot.getYAxisLabelColor(), bubblePlot.getYAxisTickLabelFont(), bubblePlot.getYAxisTickLabelColor(), bubblePlot.getYAxisTickLabelMask(), bubblePlot.getOwnYAxisLineColor(), true);
        return jfreeChart;
    }

    protected JFreeChart createCandlestickChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createCandlestickChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression())), (OHLCDataset)((DefaultHighLowDataset)this.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRCandlestickPlot candlestickPlot = (JRCandlestickPlot)this.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xyPlot.getRenderer();
        boolean isShowVolume = candlestickPlot.getShowVolume() == null ? true : candlestickPlot.getShowVolume();
        candlestickRenderer.setDrawVolume(isShowVolume);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), candlestickPlot.getTimeAxisLabelFont(), candlestickPlot.getTimeAxisLabelColor(), candlestickPlot.getTimeAxisTickLabelFont(), candlestickPlot.getTimeAxisTickLabelColor(), candlestickPlot.getTimeAxisTickLabelMask(), candlestickPlot.getOwnTimeAxisLineColor(), false);
        this.configureAxis((Axis)xyPlot.getRangeAxis(), candlestickPlot.getValueAxisLabelFont(), candlestickPlot.getValueAxisLabelColor(), candlestickPlot.getValueAxisTickLabelFont(), candlestickPlot.getValueAxisTickLabelColor(), candlestickPlot.getValueAxisTickLabelMask(), candlestickPlot.getOwnValueAxisLineColor(), true);
        return jfreeChart;
    }

    protected JFreeChart createHighLowChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createHighLowChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression())), (OHLCDataset)((DefaultHighLowDataset)this.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRHighLowPlot highLowPlot = (JRHighLowPlot)this.getPlot();
        HighLowRenderer hlRenderer = (HighLowRenderer)xyPlot.getRenderer();
        boolean isShowOpenTicks = highLowPlot.getShowOpenTicks() == null ? false : highLowPlot.getShowOpenTicks();
        boolean isShowCloseTicks = highLowPlot.getShowCloseTicks() == null ? false : highLowPlot.getShowCloseTicks();
        hlRenderer.setDrawOpenTicks(isShowOpenTicks);
        hlRenderer.setDrawCloseTicks(isShowCloseTicks);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), highLowPlot.getTimeAxisLabelFont(), highLowPlot.getTimeAxisLabelColor(), highLowPlot.getTimeAxisTickLabelFont(), highLowPlot.getTimeAxisTickLabelColor(), highLowPlot.getTimeAxisTickLabelMask(), highLowPlot.getOwnTimeAxisLineColor(), false);
        this.configureAxis((Axis)xyPlot.getRangeAxis(), highLowPlot.getValueAxisLabelFont(), highLowPlot.getValueAxisLabelColor(), highLowPlot.getValueAxisTickLabelFont(), highLowPlot.getValueAxisTickLabelColor(), highLowPlot.getValueAxisTickLabelMask(), highLowPlot.getOwnValueAxisLineColor(), true);
        return jfreeChart;
    }

    protected JFreeChart createLineChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart freeChart = ChartFactory.createLineChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(freeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)freeChart.getPlot();
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setBaseShapesVisible(isShowShapes);
        lineRenderer.setBaseLinesVisible(isShowLines);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getOwnCategoryAxisLineColor(), false);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getOwnValueAxisLineColor(), true);
        return freeChart;
    }

    protected JFreeChart createPie3DChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createPieChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (PieDataset)((PieDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        PiePlot3D piePlot3D = (PiePlot3D)jfreeChart.getPlot();
        JRPie3DPlot jrPlot = (JRPie3DPlot)this.getPlot();
        double depthFactor = jrPlot.getDepthFactorDouble() == null ? 0.2 : jrPlot.getDepthFactorDouble();
        boolean isCircular = jrPlot.getCircular() == null ? false : jrPlot.getCircular();
        piePlot3D.setDepthFactor(depthFactor);
        piePlot3D.setCircular(isCircular);
        PieSectionLabelGenerator labelGenerator = (PieSectionLabelGenerator)this.getLabelGenerator();
        if (labelGenerator != null) {
            piePlot3D.setLabelGenerator(labelGenerator);
        } else if (((JRPie3DPlot)this.getPlot()).getLabelFormat() != null) {
            piePlot3D.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRPie3DPlot)this.getPlot()).getLabelFormat()));
        }
        if (((JRPie3DPlot)this.getPlot()).getLegendLabelFormat() != null) {
            piePlot3D.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRPie3DPlot)this.getPlot()).getLegendLabelFormat()));
        }
        piePlot3D.setLabelPaint((Paint)this.getChart().getForecolor());
        return jfreeChart;
    }

    protected JFreeChart createPieChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createPieChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (PieDataset)((PieDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        PiePlot piePlot = (PiePlot)jfreeChart.getPlot();
        JRPiePlot jrPlot = (JRPiePlot)this.getPlot();
        boolean isCircular = jrPlot.getCircular() == null ? true : jrPlot.getCircular();
        piePlot.setCircular(isCircular);
        PieSectionLabelGenerator labelGenerator = (PieSectionLabelGenerator)this.getLabelGenerator();
        if (labelGenerator != null) {
            piePlot.setLabelGenerator(labelGenerator);
        } else if (((JRPiePlot)this.getPlot()).getLabelFormat() != null) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRPiePlot)this.getPlot()).getLabelFormat()));
        }
        if (((JRPiePlot)this.getPlot()).getLegendLabelFormat() != null) {
            piePlot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRPiePlot)this.getPlot()).getLegendLabelFormat()));
        }
        piePlot.setLabelPaint((Paint)this.getChart().getForecolor());
        return jfreeChart;
    }

    protected JFreeChart createScatterChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createScatterPlot((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression())), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)((XYPlot)jfreeChart.getPlot()).getRenderer();
        JRScatterPlot scatterPlot = (JRScatterPlot)this.getPlot();
        boolean isShowLines = scatterPlot.getShowLines() == null ? true : scatterPlot.getShowLines();
        boolean isShowShapes = scatterPlot.getShowShapes() == null ? true : scatterPlot.getShowShapes();
        plotRenderer.setBaseLinesVisible(isShowLines);
        plotRenderer.setBaseShapesVisible(isShowShapes);
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), scatterPlot.getXAxisLabelFont(), scatterPlot.getXAxisLabelColor(), scatterPlot.getXAxisTickLabelFont(), scatterPlot.getXAxisTickLabelColor(), scatterPlot.getXAxisTickLabelMask(), scatterPlot.getOwnXAxisLineColor(), false);
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), scatterPlot.getYAxisLabelFont(), scatterPlot.getYAxisLabelColor(), scatterPlot.getYAxisTickLabelFont(), scatterPlot.getYAxisTickLabelColor(), scatterPlot.getYAxisTickLabelMask(), scatterPlot.getOwnYAxisLineColor(), true);
        return jfreeChart;
    }

    protected JFreeChart createStackedBar3DChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBar3DPlot bar3DPlot = (JRBar3DPlot)this.getPlot();
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(bar3DPlot.getXOffsetDouble() == null ? 12.0 : bar3DPlot.getXOffsetDouble(), bar3DPlot.getYOffsetDouble() == null ? 8.0 : bar3DPlot.getYOffsetDouble());
        stackedBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        stackedBarRenderer3D.setBaseItemLabelsVisible(bar3DPlot.getShowLabels());
        categoryPlot.setRenderer((CategoryItemRenderer)stackedBarRenderer3D);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getOwnCategoryAxisLineColor(), false);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getOwnValueAxisLineColor(), true);
        return jfreeChart;
    }

    protected JFreeChart createStackedBarChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        BarRenderer categoryRenderer = (BarRenderer)categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        categoryRenderer.setShadowVisible(false);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getOwnCategoryAxisLineColor(), false);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getOwnValueAxisLineColor(), true);
        return jfreeChart;
    }

    protected JFreeChart createStackedAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getOwnCategoryAxisLineColor(), false);
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getOwnValueAxisLineColor(), true);
        ((CategoryPlot)jfreeChart.getPlot()).getDomainAxis().setCategoryMargin(0.0);
        return jfreeChart;
    }

    protected JFreeChart createXyAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression())), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getOwnCategoryAxisLineColor(), false);
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getOwnValueAxisLineColor(), true);
        return jfreeChart;
    }

    protected JFreeChart createXYBarChart() throws JRException {
        IntervalXYDataset tmpDataset = (IntervalXYDataset)this.getDataset();
        boolean isDate = true;
        if (this.getChart().getDataset().getDatasetType() == 3) {
            isDate = false;
        }
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (boolean)isDate, (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (IntervalXYDataset)tmpDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYBarRenderer itemRenderer = (XYBarRenderer)xyPlot.getRenderer();
        itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)this.getLabelGenerator());
        itemRenderer.setShadowVisible(false);
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        itemRenderer.setBaseItemLabelsVisible(isShowLabels);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getOwnCategoryAxisLineColor(), false);
        this.configureAxis((Axis)xyPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getOwnValueAxisLineColor(), true);
        return jfreeChart;
    }

    protected JFreeChart createXyLineChart() throws JRException {
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYLineChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(linePlot.getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(linePlot.getValueAxisLabelExpression())), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)linePlot.getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getOwnCategoryAxisLineColor(), false);
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getOwnValueAxisLineColor(), true);
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)jfreeChart.getXYPlot().getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setBaseShapesVisible(isShowShapes);
        lineRenderer.setBaseLinesVisible(isShowLines);
        return jfreeChart;
    }

    protected JFreeChart createTimeSeriesChart() throws JRException {
        String timeAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression());
        String valueAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression());
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createTimeSeriesChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)timeAxisLabel, (String)valueAxisLabel, (XYDataset)((TimeSeriesCollection)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRTimeSeriesPlot timeSeriesPlot = (JRTimeSeriesPlot)this.getPlot();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        boolean isShowShapes = timeSeriesPlot.getShowShapes() == null ? true : timeSeriesPlot.getShowShapes();
        boolean isShowLines = timeSeriesPlot.getShowLines() == null ? true : timeSeriesPlot.getShowLines();
        lineRenderer.setBaseLinesVisible(isShowLines);
        lineRenderer.setBaseShapesVisible(isShowShapes);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), timeSeriesPlot.getTimeAxisLabelFont(), timeSeriesPlot.getTimeAxisLabelColor(), timeSeriesPlot.getTimeAxisTickLabelFont(), timeSeriesPlot.getTimeAxisTickLabelColor(), timeSeriesPlot.getTimeAxisTickLabelMask(), timeSeriesPlot.getOwnTimeAxisLineColor(), false);
        this.configureAxis((Axis)xyPlot.getRangeAxis(), timeSeriesPlot.getValueAxisLabelFont(), timeSeriesPlot.getValueAxisLabelColor(), timeSeriesPlot.getValueAxisTickLabelFont(), timeSeriesPlot.getValueAxisTickLabelColor(), timeSeriesPlot.getValueAxisTickLabelMask(), timeSeriesPlot.getOwnValueAxisLineColor(), true);
        return jfreeChart;
    }

    protected JFreeChart createGanttChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createGanttChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (IntervalCategoryDataset)((GanttCategoryDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getOwnCategoryAxisLineColor(), false);
        ((DateAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((DateAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getOwnValueAxisLineColor(), true);
        BarRenderer categoryRenderer = (BarRenderer)categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        categoryRenderer.setShadowVisible(false);
        return jfreeChart;
    }

    protected Range convertRange(JRDataRange dataRange) throws JRException {
        if (dataRange == null) {
            return null;
        }
        Number low = (Number)this.evaluateExpression(dataRange.getLowExpression());
        Number high = (Number)this.evaluateExpression(dataRange.getHighExpression());
        return new Range(low != null ? low.doubleValue() : 0.0, high != null ? high.doubleValue() : 100.0);
    }

    protected MeterInterval convertInterval(JRMeterInterval interval) throws JRException {
        String label = interval.getLabel();
        if (label == null) {
            label = "";
        }
        Range range = this.convertRange(interval.getDataRange());
        Color color = interval.getBackgroundColor() != null ? interval.getBackgroundColor() : (Color)ChartThemesConstants.TRANSPARENT_PAINT;
        float[] components = color.getRGBColorComponents(null);
        float alpha = interval.getAlphaDouble() == null ? 1.0f : interval.getAlphaDouble().floatValue();
        Color alphaColor = new Color(components[0], components[1], components[2], alpha);
        return new MeterInterval(label, range, (Paint)alphaColor, null, (Paint)alphaColor);
    }

    protected JFreeChart createMeterChart() throws JRException {
        List intervals;
        JRValueDisplay display;
        int shape;
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        MeterPlot chartPlot = new MeterPlot((ValueDataset)this.getDataset());
        int n = shape = jrPlot.getShapeByte() == null ? 2 : jrPlot.getShapeByte().intValue();
        if (shape == 0) {
            chartPlot.setDialShape(DialShape.CHORD);
        } else if (shape == 1) {
            chartPlot.setDialShape(DialShape.CIRCLE);
        } else {
            chartPlot.setDialShape(DialShape.PIE);
        }
        chartPlot.setRange(this.convertRange(jrPlot.getDataRange()));
        int meterAngle = jrPlot.getMeterAngleInteger() == null ? 180 : jrPlot.getMeterAngleInteger();
        chartPlot.setMeterAngle(meterAngle);
        String units = jrPlot.getUnits();
        if (units != null && units.length() > 0) {
            chartPlot.setUnits(units);
        }
        double tickInterval = jrPlot.getTickIntervalDouble() == null ? 10.0 : jrPlot.getTickIntervalDouble();
        chartPlot.setTickSize(tickInterval);
        Color color = jrPlot.getMeterBackgroundColor();
        if (color != null) {
            chartPlot.setDialBackgroundPaint((Paint)color);
        }
        if ((color = jrPlot.getNeedleColor()) != null) {
            chartPlot.setNeedlePaint((Paint)color);
        }
        if ((display = jrPlot.getValueDisplay()) != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setTickLabelFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                // empty if block
            }
        }
        if ((color = jrPlot.getTickColor()) != null) {
            chartPlot.setTickPaint((Paint)color);
        }
        if ((intervals = jrPlot.getIntervals()) != null) {
            Iterator iter = intervals.iterator();
            while (iter.hasNext()) {
                JRMeterInterval interval = (JRMeterInterval)iter.next();
                if (interval == null) continue;
                chartPlot.addInterval(this.convertInterval(interval));
            }
        }
        JFreeChart jfreeChart = new JFreeChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), null, (Plot)chartPlot, this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        return jfreeChart;
    }

    protected JFreeChart createThermometerChart() throws JRException {
        JRValueDisplay display;
        JRThermometerPlot jrPlot = (JRThermometerPlot)this.getPlot();
        ThermometerPlot chartPlot = new ThermometerPlot((ValueDataset)this.getDataset());
        Range range = this.convertRange(jrPlot.getDataRange());
        chartPlot.setLowerBound(range.getLowerBound());
        chartPlot.setUpperBound(range.getUpperBound());
        chartPlot.setUnits(0);
        Color color = jrPlot.getMercuryColor();
        if (color != null) {
            chartPlot.setMercuryPaint((Paint)color);
        }
        if ((display = jrPlot.getValueDisplay()) != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setValueFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                // empty if block
            }
        }
        int valueLocation = jrPlot.getValueLocationByte() == null ? 3 : (int)jrPlot.getValueLocationByte().byteValue();
        switch (valueLocation) {
            case 0: {
                chartPlot.setValueLocation(0);
                break;
            }
            case 1: {
                chartPlot.setValueLocation(2);
                break;
            }
            case 2: {
                chartPlot.setValueLocation(1);
                break;
            }
            default: {
                chartPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jrPlot.getLowRange());
        if (range != null) {
            chartPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getMediumRange())) != null) {
            chartPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getHighRange())) != null) {
            chartPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        JFreeChart jfreeChart = new JFreeChart((Plot)chartPlot);
        this.configureChart(jfreeChart, this.getPlot());
        return jfreeChart;
    }

    protected AxisLocation getChartAxisLocation(JRChartAxis chartAxis) {
        if (chartAxis.getPositionByte() != null) {
            switch (chartAxis.getPositionByte()) {
                case 2: {
                    return AxisLocation.BOTTOM_OR_RIGHT;
                }
            }
            return AxisLocation.TOP_OR_LEFT;
        }
        return (AxisLocation)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLocation");
    }

    private static RectangleEdge getEdge(Byte position, RectangleEdge defaultPosition) {
        RectangleEdge edge = defaultPosition;
        if (position != null) {
            switch (position) {
                case 1: {
                    edge = RectangleEdge.TOP;
                    break;
                }
                case 2: {
                    edge = RectangleEdge.BOTTOM;
                    break;
                }
                case 3: {
                    edge = RectangleEdge.LEFT;
                    break;
                }
                case 4: {
                    edge = RectangleEdge.RIGHT;
                }
            }
        }
        return edge;
    }

    protected void populateSeriesColors(Paint[] colors, Paint[] colorSequence) {
        if (colors != null) {
            int i;
            int size = colorSequence != null ? colorSequence.length : 0;
            for (i = 0; i < size; ++i) {
                colors[i] = colorSequence[i];
            }
            for (i = size; i < colors.length; ++i) {
                colors[i] = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE[i - size];
            }
        }
    }

    protected void setChartBackground(JFreeChart jfreeChart) {
        Paint defaultBackgroundPaint = (Paint)this.getDefaultValue(this.defaultChartPropertiesMap, "backgroundPaint");
        Image defaultBackgroundImage = (Image)this.getDefaultValue(this.defaultChartPropertiesMap, "backgroundImage");
        Integer defaultBackgroundImageAlignment = (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "backgroundImageAlignment");
        Float defaultBackgroundImageAlpha = (Float)this.getDefaultValue(this.defaultChartPropertiesMap, "backgroundImageAlpha");
        if (this.getChart().getOwnMode() != null) {
            if (this.getChart().getOwnMode() == 1) {
                if (this.getChart().getOwnBackcolor() == null && defaultBackgroundPaint != null) {
                    jfreeChart.setBackgroundPaint(defaultBackgroundPaint);
                } else {
                    jfreeChart.setBackgroundPaint((Paint)this.getChart().getBackcolor());
                }
                this.setChartBackgroundImage(jfreeChart, defaultBackgroundImage, defaultBackgroundImageAlignment, defaultBackgroundImageAlpha);
            } else {
                jfreeChart.setBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
                this.setChartBackgroundImage(jfreeChart, defaultBackgroundImage, defaultBackgroundImageAlignment, new Float(0.0f));
            }
        } else if (defaultBackgroundPaint != null) {
            jfreeChart.setBackgroundPaint(defaultBackgroundPaint);
        }
    }

    protected void setChartBackgroundImage(JFreeChart jfreeChart, Image defaultBackgroundImage, Integer defaultBackgroundImageAlignment, Float defaultBackgroundImageAlpha) {
        if (defaultBackgroundImage != null) {
            jfreeChart.setBackgroundImage(defaultBackgroundImage);
            if (defaultBackgroundImageAlignment != null) {
                jfreeChart.setBackgroundImageAlignment(defaultBackgroundImageAlignment.intValue());
            }
            if (defaultBackgroundImageAlpha != null) {
                jfreeChart.setBackgroundImageAlpha(defaultBackgroundImageAlpha.floatValue());
            }
        }
    }

    protected void setChartTitle(JFreeChart jfreeChart, Float baseFontSize) {
        Boolean titleVisibility = (Boolean)this.getDefaultValue(this.defaultChartPropertiesMap, "titleVisible");
        if (titleVisibility != null && titleVisibility.booleanValue()) {
            TextTitle title = jfreeChart.getTitle();
            RectangleEdge titleEdge = null;
            if (title != null) {
                Color titleBackcolor;
                Color titleForecolor;
                RectangleInsets titlePadding;
                VerticalAlignment defaultTitleVAlignment;
                Float defaultTitleBaseFontSize;
                Font titleFont = title.getFont();
                int defaultTitleBaseFontBoldStyle = this.getDefaultValue(this.defaultChartPropertiesMap, "titleBaseFontBoldStyle") != null ? (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "titleBaseFontBoldStyle") : 0;
                int defaultTitleBaseFontItalicStyle = this.getDefaultValue(this.defaultChartPropertiesMap, "titleBaseFontBoldStyle") != null ? (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "titleBaseFontBoldStyle") : 0;
                titleFont = titleFont.deriveFont(ChartThemesUtilities.getAwtFontStyle(this.getChart().getTitleFont(), defaultTitleBaseFontBoldStyle, defaultTitleBaseFontItalicStyle));
                Float f = defaultTitleBaseFontSize = this.getDefaultValue(this.defaultChartPropertiesMap, "titleBaseFontSize") != null ? (Float)this.getDefaultValue(this.defaultChartPropertiesMap, "titleBaseFontSize") : baseFontSize;
                if (this.getChart().getTitleFont().getOwnFontSize() == null && defaultTitleBaseFontSize != null) {
                    titleFont = titleFont.deriveFont(defaultTitleBaseFontSize.floatValue());
                }
                title.setFont(titleFont);
                HorizontalAlignment defaultTitleHAlignment = (HorizontalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "titleHorizontalAlignment");
                if (defaultTitleHAlignment != null) {
                    title.setHorizontalAlignment(defaultTitleHAlignment);
                }
                if ((defaultTitleVAlignment = (VerticalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "titleVerticalAlignment")) != null) {
                    title.setVerticalAlignment(defaultTitleVAlignment);
                }
                RectangleInsets defaultTitlePadding = (RectangleInsets)this.getDefaultValue(this.defaultChartPropertiesMap, "titlePadding");
                RectangleInsets rectangleInsets = titlePadding = title.getPadding() != null ? title.getPadding() : defaultTitlePadding;
                if (titlePadding != null) {
                    title.setPadding(titlePadding);
                }
                Color color = this.getChart().getOwnTitleColor() != null ? this.getChart().getOwnTitleColor() : (titleForecolor = this.getDefaultValue(this.defaultChartPropertiesMap, "titleForecolor") != null ? (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "titleForecolor") : this.getChart().getTitleColor());
                if (titleForecolor != null) {
                    title.setPaint((Paint)titleForecolor);
                }
                if ((titleBackcolor = (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "titleBackcolor")) != null) {
                    title.setBackgroundPaint((Paint)titleBackcolor);
                }
                RectangleEdge defaultTitlePosition = (RectangleEdge)this.getDefaultValue(this.defaultChartPropertiesMap, "titlePosition");
                titleEdge = GenericChartTheme.getEdge(this.getChart().getTitlePositionByte(), defaultTitlePosition);
                if (titleEdge != null) {
                    title.setPosition(titleEdge);
                }
            }
        } else {
            TextTitle title = null;
            jfreeChart.setTitle(title);
        }
    }

    protected void setChartSubtitles(JFreeChart jfreeChart, Float baseFontSize) throws JRException {
        String subtitleText;
        Boolean subtitleVisibility = (Boolean)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleVisible");
        if (subtitleVisibility != null && subtitleVisibility.booleanValue() && (subtitleText = (String)this.evaluateExpression(this.getChart().getSubtitleExpression())) != null) {
            Color subtitleBackcolor;
            Color subtitleForecolor;
            RectangleInsets subtitlePadding;
            VerticalAlignment defaultSubtitleVAlignment;
            Float defaultSubtitleBaseFontSize;
            TextTitle subtitle = new TextTitle(subtitleText);
            Font subtitleFont = subtitle.getFont();
            int defaultSubtitleBaseFontBoldStyle = this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleBaseFontBoldStyle") != null ? (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleBaseFontBoldStyle") : 0;
            int defaultSubtitleBaseFontItalicStyle = this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleBaseFontBoldStyle") != null ? (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleBaseFontBoldStyle") : 0;
            subtitleFont = subtitleFont.deriveFont(ChartThemesUtilities.getAwtFontStyle(this.getChart().getSubtitleFont(), defaultSubtitleBaseFontBoldStyle, defaultSubtitleBaseFontItalicStyle));
            Float f = defaultSubtitleBaseFontSize = this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleBaseFontSize") != null ? (Float)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleBaseFontSize") : baseFontSize;
            if (this.getChart().getSubtitleFont().getOwnFontSize() == null && defaultSubtitleBaseFontSize != null) {
                subtitleFont = subtitleFont.deriveFont(defaultSubtitleBaseFontSize.floatValue());
            }
            subtitle.setFont(subtitleFont);
            HorizontalAlignment defaultSubtitleHAlignment = (HorizontalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleHorizontalAlignment");
            if (defaultSubtitleHAlignment != null) {
                subtitle.setHorizontalAlignment(defaultSubtitleHAlignment);
            }
            if ((defaultSubtitleVAlignment = (VerticalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleVerticalAlignment")) != null) {
                subtitle.setVerticalAlignment(defaultSubtitleVAlignment);
            }
            RectangleInsets defaultSubtitlePadding = (RectangleInsets)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitlePadding");
            RectangleInsets rectangleInsets = subtitlePadding = subtitle.getPadding() != null ? subtitle.getPadding() : defaultSubtitlePadding;
            if (subtitlePadding != null) {
                subtitle.setPadding(subtitlePadding);
            }
            Color color = this.getChart().getOwnSubtitleColor() != null ? this.getChart().getOwnSubtitleColor() : (subtitleForecolor = this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleForecolor") != null ? (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleForecolor") : this.getChart().getSubtitleColor());
            if (subtitleForecolor != null) {
                subtitle.setPaint((Paint)subtitleForecolor);
            }
            Color color2 = subtitleBackcolor = this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleBackcolor") != null ? (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleBackcolor") : null;
            if (subtitleBackcolor != null) {
                subtitle.setBackgroundPaint((Paint)subtitleBackcolor);
            }
            RectangleEdge defaultSubtitlePosition = (RectangleEdge)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitlePosition");
            RectangleEdge subtitleEdge = null;
            subtitleEdge = defaultSubtitlePosition == null ? jfreeChart.getTitle().getPosition() : GenericChartTheme.getEdge(null, defaultSubtitlePosition);
            if (subtitleEdge != null) {
                subtitle.setPosition(subtitleEdge);
            }
            jfreeChart.addSubtitle((Title)subtitle);
        }
    }

    protected void setChartLegend(JFreeChart jfreeChart, Float baseFontSize) {
        LegendTitle legend = jfreeChart.getLegend();
        if (legend != null) {
            RectangleInsets legendPadding;
            VerticalAlignment defaultLegendVAlignment;
            HorizontalAlignment defaultLegendHAlignment;
            BlockFrame frame;
            Color legendBackcolor;
            Color legendForecolor;
            Float defaultLegendBaseFontSize;
            Font legendFont = legend.getItemFont();
            int defaultLegendBaseFontBoldStyle = this.getDefaultValue(this.defaultChartPropertiesMap, "legendBaseFontBoldStyle") != null ? (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "legendBaseFontBoldStyle") : 0;
            int defaultLegendBaseFontItalicStyle = this.getDefaultValue(this.defaultChartPropertiesMap, "legendBaseFontItalicStyle") != null ? (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "legendBaseFontItalicStyle") : 0;
            legendFont = legendFont.deriveFont(ChartThemesUtilities.getAwtFontStyle(this.getChart().getLegendFont(), defaultLegendBaseFontBoldStyle, defaultLegendBaseFontItalicStyle));
            Float f = defaultLegendBaseFontSize = this.getDefaultValue(this.defaultChartPropertiesMap, "legendBaseFontSize") != null ? (Float)this.getDefaultValue(this.defaultChartPropertiesMap, "legendBaseFontSize") : baseFontSize;
            if (this.getChart().getLegendFont().getOwnFontSize() == null && defaultLegendBaseFontSize != null) {
                legendFont = legendFont.deriveFont(defaultLegendBaseFontSize.floatValue());
            }
            legend.setItemFont(legendFont);
            Color color = this.getChart().getOwnLegendColor() != null ? this.getChart().getOwnLegendColor() : (legendForecolor = this.getDefaultValue(this.defaultChartPropertiesMap, "legendForecolor") != null ? (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "legendForecolor") : this.getChart().getLegendColor());
            if (legendForecolor != null) {
                legend.setItemPaint((Paint)legendForecolor);
            }
            Color color2 = this.getChart().getOwnLegendBackgroundColor() != null ? this.getChart().getOwnLegendBackgroundColor() : (legendBackcolor = this.getDefaultValue(this.defaultChartPropertiesMap, "legendBackcolor") != null ? (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "legendBackcolor") : this.getChart().getLegendBackgroundColor());
            if (legendBackcolor != null) {
                legend.setBackgroundPaint((Paint)legendBackcolor);
            }
            if ((frame = (BlockFrame)this.getDefaultValue(this.defaultChartPropertiesMap, "legendFrame")) != null) {
                legend.setFrame(frame);
            }
            if ((defaultLegendHAlignment = (HorizontalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "legendHorizontalAlignment")) != null) {
                legend.setHorizontalAlignment(defaultLegendHAlignment);
            }
            if ((defaultLegendVAlignment = (VerticalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "legendVerticalAlignment")) != null) {
                legend.setVerticalAlignment(defaultLegendVAlignment);
            }
            RectangleInsets defaultLegendPadding = (RectangleInsets)this.getDefaultValue(this.defaultChartPropertiesMap, "legendPadding");
            RectangleInsets rectangleInsets = legendPadding = legend.getPadding() != null ? legend.getPadding() : defaultLegendPadding;
            if (legendPadding != null) {
                legend.setPadding(legendPadding);
            }
            RectangleEdge defaultLegendPosition = (RectangleEdge)this.getDefaultValue(this.defaultChartPropertiesMap, "legendPosition");
            if (GenericChartTheme.getEdge(this.getChart().getLegendPositionByte(), defaultLegendPosition) != null) {
                legend.setPosition(GenericChartTheme.getEdge(this.getChart().getLegendPositionByte(), defaultLegendPosition));
            }
        }
    }

    protected void setChartBorder(JFreeChart jfreeChart) {
        JRLineBox lineBox = this.getChart().getLineBox();
        if (lineBox.getLeftPen().getLineWidth().floatValue() == 0.0f && lineBox.getBottomPen().getLineWidth().floatValue() == 0.0f && lineBox.getRightPen().getLineWidth().floatValue() == 0.0f && lineBox.getTopPen().getLineWidth().floatValue() == 0.0f) {
            boolean isVisible;
            boolean bl = isVisible = this.getDefaultValue(this.defaultChartPropertiesMap, "chartBorderVisible") == null ? false : (Boolean)this.getDefaultValue(this.defaultChartPropertiesMap, "chartBorderVisible");
            if (isVisible) {
                Paint paint;
                BasicStroke stroke = (BasicStroke)this.getDefaultValue(this.defaultChartPropertiesMap, "chartBorderStroke");
                if (stroke != null) {
                    jfreeChart.setBorderStroke((Stroke)stroke);
                }
                if ((paint = (Paint)this.getDefaultValue(this.defaultChartPropertiesMap, "chartBorderPaint")) != null) {
                    jfreeChart.setBorderPaint(paint);
                }
            }
            jfreeChart.setBorderVisible(isVisible);
        }
    }

    protected void setPlotBackground(Plot p, JRChartPlot jrPlot) {
        Float foregroundAlpha;
        Float backgroundAlpha;
        Paint backgroundPaint;
        Paint defaultBackgroundPaint = (Paint)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotBackgroundPaint");
        Float defaultBackgroundAlpha = (Float)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotBackgroundAlpha");
        Float defaultForegroundAlpha = (Float)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotForegroundAlpha");
        Image defaultBackgroundImage = (Image)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotBackgroundImage");
        Integer defaultBackgroundImageAlignment = (Integer)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotBackgroundImageAlignment");
        Float defaultBackgroundImageAlpha = (Float)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotBackgroundImageAlpha");
        Paint paint = backgroundPaint = jrPlot.getOwnBackcolor() != null ? jrPlot.getOwnBackcolor() : defaultBackgroundPaint;
        if (backgroundPaint != null) {
            p.setBackgroundPaint(backgroundPaint);
        }
        Float f = backgroundAlpha = jrPlot.getBackgroundAlphaFloat() != null ? jrPlot.getBackgroundAlphaFloat() : defaultBackgroundAlpha;
        if (backgroundAlpha != null) {
            p.setBackgroundAlpha(backgroundAlpha.floatValue());
        }
        Float f2 = foregroundAlpha = jrPlot.getForegroundAlphaFloat() != null ? jrPlot.getForegroundAlphaFloat() : defaultForegroundAlpha;
        if (foregroundAlpha != null) {
            p.setForegroundAlpha(foregroundAlpha.floatValue());
        }
        if (defaultBackgroundImage != null) {
            p.setBackgroundImage(defaultBackgroundImage);
            if (defaultBackgroundImageAlignment != null) {
                p.setBackgroundImageAlignment(defaultBackgroundImageAlignment.intValue());
            }
            if (defaultBackgroundImageAlpha != null) {
                p.setBackgroundImageAlpha(defaultBackgroundImageAlpha.floatValue());
            }
        }
    }

    protected void handleCategoryPlotSettings(CategoryPlot p, JRChartPlot jrPlot) {
        boolean hasRotation;
        Double defaultPlotLabelRotation = (Double)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotLabelRotation");
        PlotOrientation defaultPlotOrientation = (PlotOrientation)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOrientation");
        CategoryAxis axis = p.getDomainAxis();
        boolean bl = hasRotation = jrPlot.getLabelRotationDouble() != null || defaultPlotLabelRotation != null;
        if (hasRotation) {
            double labelRotation;
            double d = labelRotation = jrPlot.getLabelRotationDouble() != null ? jrPlot.getLabelRotationDouble().doubleValue() : defaultPlotLabelRotation.doubleValue();
            if (labelRotation == 90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (labelRotation == -90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else if (labelRotation < 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)(-labelRotation / 180.0 * Math.PI)));
            } else if (labelRotation > 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions((double)(labelRotation / 180.0 * Math.PI)));
            }
        }
        if (defaultPlotOrientation != null) {
            p.setOrientation(defaultPlotOrientation);
        }
    }

    protected void setPlotDrawingDefaults(Plot p, JRChartPlot jrPlot) {
        List defaultSeriesColors = (List)this.getDefaultValue(this.defaultChartPropertiesMap, "seriesColors");
        Paint[] defaultPlotOutlinePaintSequence = this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlinePaintSequence") != null ? (Paint[])this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlinePaintSequence") : DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE;
        Stroke[] defaultPlotStrokeSequence = this.getDefaultValue(this.defaultPlotPropertiesMap, "plotStrokeSequence") != null ? (Stroke[])this.getDefaultValue(this.defaultPlotPropertiesMap, "plotStrokeSequence") : DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE;
        Stroke[] defaultPlotOutlineStrokeSequence = this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlineStrokeSequence") != null ? (Stroke[])this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlineStrokeSequence") : DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE;
        Shape[] defaultPlotShapeSequence = this.getDefaultValue(this.defaultPlotPropertiesMap, "plotShapeSequence") != null ? (Shape[])this.getDefaultValue(this.defaultPlotPropertiesMap, "plotShapeSequence") : DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE;
        Paint[] colors = null;
        SortedSet seriesColors = jrPlot.getSeriesColors();
        Paint[] colorSequence = null;
        if (seriesColors != null && seriesColors.size() > 0) {
            int seriesColorsSize = seriesColors.size();
            colors = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + seriesColorsSize];
            JRChartPlot.JRSeriesColor[] jrColorSequence = new JRChartPlot.JRSeriesColor[seriesColorsSize];
            seriesColors.toArray(jrColorSequence);
            colorSequence = new Paint[seriesColorsSize];
            for (int i = 0; i < seriesColorsSize; ++i) {
                colorSequence[i] = jrColorSequence[i].getColor();
            }
            this.populateSeriesColors(colors, colorSequence);
        } else if (defaultSeriesColors != null && defaultSeriesColors.size() > 0) {
            colors = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + defaultSeriesColors.size()];
            colorSequence = new Paint[defaultSeriesColors.size()];
            defaultSeriesColors.toArray(colorSequence);
            this.populateSeriesColors(colors, colorSequence);
        } else {
            colors = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE;
        }
        p.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(colors, defaultPlotOutlinePaintSequence, defaultPlotStrokeSequence, defaultPlotOutlineStrokeSequence, defaultPlotShapeSequence));
    }

    protected void setAxisLine(Axis axis, Paint lineColor) {
        Boolean defaultAxisLineVisible = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLineVisible");
        if (defaultAxisLineVisible != null && defaultAxisLineVisible.booleanValue()) {
            Stroke defaultAxisLineStroke;
            Paint linePaint;
            Paint paint = linePaint = lineColor != null ? lineColor : (Paint)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLinePaint");
            if (linePaint != null) {
                axis.setAxisLinePaint(linePaint);
            }
            if ((defaultAxisLineStroke = (Stroke)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLineStroke")) != null) {
                axis.setAxisLineStroke(defaultAxisLineStroke);
            }
        }
    }

    protected void setAxisLabel(Axis axis, JRFont labelFont, Paint labelColor) {
        Boolean defaultAxisLabelVisible = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelVisible");
        if (defaultAxisLabelVisible != null && defaultAxisLabelVisible.booleanValue()) {
            Paint labelPaint;
            RectangleInsets defaultLabelInsets;
            Font themeLabelFont;
            Double defaultLabelAngle;
            if (axis.getLabel() == null) {
                axis.setLabel((String)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabel"));
            }
            if ((defaultLabelAngle = (Double)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelAngle")) != null) {
                axis.setLabelAngle(defaultLabelAngle.doubleValue());
            }
            Font font = themeLabelFont = labelFont != null ? JRFontUtil.getAwtFont((JRFont)labelFont, (Locale)this.getLocale()) : (Font)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelFont");
            if (themeLabelFont != null) {
                int defaultAxisLabelFontBoldStyle = this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelFontBoldStyle") != null ? (Integer)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelFontBoldStyle") : 0;
                int defaultAxisLabelFontItalicStyle = this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelFontItalicStyle") != null ? (Integer)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelFontItalicStyle") : 0;
                themeLabelFont = themeLabelFont.deriveFont(ChartThemesUtilities.getAwtFontStyle(labelFont, defaultAxisLabelFontBoldStyle, defaultAxisLabelFontItalicStyle));
                if (labelFont.getOwnFontSize() == null) {
                    Float defaultLabelBaseFontSize;
                    Float f = defaultLabelBaseFontSize = this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelFontSize") != null ? (Float)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelFontSize") : (Float)this.getDefaultValue(this.defaultChartPropertiesMap, "baseFontSize");
                    if (defaultLabelBaseFontSize != null) {
                        themeLabelFont = themeLabelFont.deriveFont(defaultLabelBaseFontSize.floatValue());
                    }
                }
                axis.setLabelFont(themeLabelFont);
            }
            if ((defaultLabelInsets = (RectangleInsets)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelInsets")) != null) {
                axis.setLabelInsets(defaultLabelInsets);
            }
            Paint paint = labelPaint = labelColor != null ? labelColor : (Paint)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelPaint");
            if (labelPaint != null) {
                axis.setLabelPaint(labelPaint);
            }
        }
    }

    protected void setAxisTickLabels(Axis axis, JRFont tickLabelFont, Paint tickLabelColor, String tickLabelMask) {
        Boolean defaultAxisTickLabelsVisible = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelsVisible");
        if (defaultAxisTickLabelsVisible != null && defaultAxisTickLabelsVisible.booleanValue()) {
            Paint tickLabelPaint;
            RectangleInsets defaultTickLabelInsets;
            Font themeTickLabelFont;
            Font font = themeTickLabelFont = tickLabelFont != null ? JRFontUtil.getAwtFont((JRFont)tickLabelFont, (Locale)this.getLocale()) : (Font)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelFont");
            if (themeTickLabelFont != null) {
                Float defaultTickLabelBaseFontSize;
                int defaultAxisTickLabelFontBoldStyle = this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelFontBoldStyle") != null ? (Integer)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelFontBoldStyle") : 0;
                int defaultAxisTickLabelFontItalicStyle = this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelFontItalicStyle") != null ? (Integer)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelFontItalicStyle") : 0;
                themeTickLabelFont = themeTickLabelFont.deriveFont(ChartThemesUtilities.getAwtFontStyle(tickLabelFont, defaultAxisTickLabelFontBoldStyle, defaultAxisTickLabelFontItalicStyle));
                if (tickLabelFont.getOwnFontSize() == null && (defaultTickLabelBaseFontSize = (Float)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelFontSize")) != null) {
                    themeTickLabelFont = themeTickLabelFont.deriveFont(defaultTickLabelBaseFontSize.floatValue());
                }
                axis.setTickLabelFont(themeTickLabelFont);
            }
            if ((defaultTickLabelInsets = (RectangleInsets)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelInsets")) != null) {
                axis.setTickLabelInsets(defaultTickLabelInsets);
            }
            Paint paint = tickLabelPaint = tickLabelColor != null ? tickLabelColor : (Paint)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelPaint");
            if (tickLabelPaint != null) {
                axis.setTickLabelPaint(tickLabelPaint);
            }
            if (tickLabelMask != null) {
                Format fmt;
                if (axis instanceof NumberAxis) {
                    fmt = NumberFormat.getInstance();
                    if (fmt instanceof DecimalFormat) {
                        ((DecimalFormat)fmt).applyPattern(tickLabelMask);
                    }
                    ((NumberAxis)axis).setNumberFormatOverride(fmt);
                } else if (axis instanceof DateAxis) {
                    fmt = null;
                    fmt = tickLabelMask.equals("SHORT") || tickLabelMask.equals("DateFormat.SHORT") ? DateFormat.getDateInstance(3) : (tickLabelMask.equals("MEDIUM") || tickLabelMask.equals("DateFormat.MEDIUM") ? DateFormat.getDateInstance(2) : (tickLabelMask.equals("LONG") || tickLabelMask.equals("DateFormat.LONG") ? DateFormat.getDateInstance(1) : (tickLabelMask.equals("FULL") || tickLabelMask.equals("DateFormat.FULL") ? DateFormat.getDateInstance(0) : new SimpleDateFormat(tickLabelMask))));
                    if (fmt != null) {
                        ((DateAxis)axis).setDateFormatOverride((DateFormat)fmt);
                    } else {
                        ((DateAxis)axis).setDateFormatOverride(DateFormat.getDateTimeInstance(3, 3));
                    }
                }
            }
        }
    }

    protected void setAxisTickMarks(Axis axis, Paint lineColor) {
        Boolean defaultAxisTickMarksVisible = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksVisible");
        if (defaultAxisTickMarksVisible != null && defaultAxisTickMarksVisible.booleanValue()) {
            Stroke defaultTickMarkStroke;
            Paint tickMarkPaint;
            Float defaultAxisTickMarksOutsideLength;
            Float defaultAxisTickMarksInsideLength = (Float)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksInsideLength");
            if (defaultAxisTickMarksInsideLength != null) {
                axis.setTickMarkInsideLength(defaultAxisTickMarksInsideLength.floatValue());
            }
            if ((defaultAxisTickMarksOutsideLength = (Float)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksOutsideLength")) != null) {
                axis.setTickMarkInsideLength(defaultAxisTickMarksOutsideLength.floatValue());
            }
            Paint paint = tickMarkPaint = this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksPaint") != null ? (Paint)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksPaint") : lineColor;
            if (tickMarkPaint != null) {
                axis.setTickMarkPaint(tickMarkPaint);
            }
            if ((defaultTickMarkStroke = (Stroke)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksStroke")) != null) {
                axis.setTickMarkStroke(defaultTickMarkStroke);
            }
        }
    }

    protected void setAxisBounds(Axis axis, boolean isRangeAxis, String timeUnit) throws JRException {
        if (axis instanceof ValueAxis) {
            String axisMinValue = null;
            String axisMaxValue = null;
            int tickCount = -1;
            String tickInterval = null;
            if (this.getChart().hasProperties()) {
                String tickCountProperty = null;
                if (isRangeAxis) {
                    axisMinValue = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.range.axis.minvalue");
                    axisMaxValue = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.range.axis.maxvalue");
                    tickCountProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.range.axis.tickcount");
                    tickInterval = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.range.axis.tick.interval");
                } else {
                    axisMinValue = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.domain.axis.minvalue");
                    axisMaxValue = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.domain.axis.maxvalue");
                    tickCountProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.domain.axis.tickcount");
                    tickInterval = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.domain.axis.tick.interval");
                }
                if (tickCountProperty != null) {
                    tickCount = Integer.valueOf(tickCountProperty);
                }
            } else {
                Integer tickCountInteger = null;
                if (isRangeAxis) {
                    axisMinValue = (String)this.getDefaultValue(this.defaultAxisPropertiesMap, "rangeAxisMinValue");
                    axisMaxValue = (String)this.getDefaultValue(this.defaultAxisPropertiesMap, "rangeAxisMaxValue");
                    tickCountInteger = (Integer)this.getDefaultValue(this.defaultAxisPropertiesMap, "rangeAxisTickCount");
                    tickInterval = (String)this.getDefaultValue(this.defaultAxisPropertiesMap, "rangeAxisTickInterval");
                } else {
                    axisMinValue = (String)this.getDefaultValue(this.defaultAxisPropertiesMap, "domainAxisMinValue");
                    axisMaxValue = (String)this.getDefaultValue(this.defaultAxisPropertiesMap, "domainAxisMaxValue");
                    tickCountInteger = (Integer)this.getDefaultValue(this.defaultAxisPropertiesMap, "domainAxisTickCount");
                    tickInterval = (String)this.getDefaultValue(this.defaultAxisPropertiesMap, "domainAxisTickInterval");
                }
                if (tickCountInteger != null) {
                    tickCount = tickCountInteger;
                }
            }
            if (axis instanceof DateAxis) {
                DateAxis dateAxis = (DateAxis)axis;
                DateFormat df = dateAxis.getDateFormatOverride();
                if (df != null) {
                    if (axisMinValue != null) {
                        try {
                            dateAxis.setMinimumDate(df.parse(axisMinValue));
                        }
                        catch (ParseException e) {
                            throw new JRException((Throwable)e);
                        }
                    }
                    if (axisMaxValue != null) {
                        try {
                            dateAxis.setMaximumDate(df.parse(axisMaxValue));
                        }
                        catch (ParseException e) {
                            throw new JRException((Throwable)e);
                        }
                    }
                }
            } else {
                if (axisMinValue != null) {
                    ((ValueAxis)axis).setLowerBound(Double.valueOf(axisMinValue).doubleValue());
                }
                if (axisMaxValue != null) {
                    ((ValueAxis)axis).setUpperBound(Double.valueOf(axisMaxValue).doubleValue());
                }
            }
            this.calculateTickUnits(axis, tickCount, tickInterval, timeUnit);
        }
    }

    protected void calculateTickUnits(Axis axis, int tickCount, String tickInterval, String timePeriodUnit) {
        if ((tickInterval == null || tickInterval.length() == 0) && tickCount < 0) {
            return;
        }
        if (axis instanceof NumberAxis) {
            NumberAxis numberAxis = (NumberAxis)axis;
            int axisRange = (int)numberAxis.getRange().getLength();
            if (numberAxis.getNumberFormatOverride() != null) {
                if (tickInterval != null && tickInterval.length() > 0) {
                    numberAxis.setTickUnit(new NumberTickUnit(Double.valueOf(tickInterval).doubleValue(), numberAxis.getNumberFormatOverride()));
                } else {
                    numberAxis.setTickUnit(new NumberTickUnit((double)(axisRange / tickCount), numberAxis.getNumberFormatOverride()));
                }
            } else if (tickInterval != null && tickInterval.length() > 0) {
                numberAxis.setTickUnit(new NumberTickUnit(Double.valueOf(tickInterval).doubleValue()));
            } else {
                numberAxis.setTickUnit(new NumberTickUnit((double)(axisRange / tickCount)));
            }
        } else if (axis instanceof DateAxis) {
            DateAxis dateAxis = (DateAxis)axis;
            int axisRange = (int)dateAxis.getRange().getLength();
            int timeUnit = this.getTimePeriodUnit(timePeriodUnit);
            if (dateAxis.getDateFormatOverride() != null) {
                if (tickInterval != null && tickInterval.length() > 0) {
                    dateAxis.setTickUnit(new DateTickUnit(timeUnit, Integer.valueOf(tickInterval).intValue(), dateAxis.getDateFormatOverride()));
                } else {
                    dateAxis.setTickUnit(new DateTickUnit(timeUnit, axisRange / tickCount, dateAxis.getDateFormatOverride()));
                }
            } else if (tickInterval != null && tickInterval.length() > 0) {
                dateAxis.setTickUnit(new DateTickUnit(timeUnit, Integer.valueOf(tickInterval).intValue()));
            } else {
                dateAxis.setTickUnit(new DateTickUnit(timeUnit, axisRange / tickCount));
            }
        }
    }

    protected boolean isShowLegend() {
        Boolean legendVisibility = this.getChart().getShowLegend() != null ? this.getChart().getShowLegend() : (Boolean)this.getDefaultValue(this.defaultChartPropertiesMap, "legendVisible");
        return legendVisibility != null ? legendVisibility : false;
    }

    protected int getTimePeriodUnit(String timePeriodUnit) {
        if (timePeriodUnit == null) {
            return 2;
        }
        return timePeriodUnit.equals("Year") ? 0 : (timePeriodUnit.equals("Month") ? 1 : (timePeriodUnit.equals("Hour") ? 3 : (timePeriodUnit.equals("Minute") ? 4 : (timePeriodUnit.equals("Second") ? 5 : (timePeriodUnit.equals("Millisecond") ? 6 : 2)))));
    }

    public Object getDefaultValue(Map map, Object key) {
        return map == null ? null : map.get(key);
    }

    public Map getDefaultChartPropertiesMap() {
        return this.defaultChartPropertiesMap;
    }

    public void setDefaultChartPropertiesMap(Map defaultChartPropertiesMap) {
        this.defaultChartPropertiesMap = defaultChartPropertiesMap;
    }

    public Map getDefaultPlotPropertiesMap() {
        return this.defaultPlotPropertiesMap;
    }

    public void setDefaultPlotPropertiesMap(Map defaultPlotPropertiesMap) {
        this.defaultPlotPropertiesMap = defaultPlotPropertiesMap;
    }

    public Map getDefaultAxisPropertiesMap() {
        return this.defaultAxisPropertiesMap;
    }

    public void setDefaultAxisPropertiesMap(Map defaultAxisPropertiesMap) {
        this.defaultAxisPropertiesMap = defaultAxisPropertiesMap;
    }

    public Map getDefaultChartTypePropertiesMap() {
        return this.defaultChartTypePropertiesMap;
    }

    public void setDefaultChartTypePropertiesMap(Map defaultChartTypePropertiesMap) {
        this.defaultChartTypePropertiesMap = defaultChartTypePropertiesMap;
    }
}

