/*
 * Decompiled with CFR 0.152.
 */
package rex.metadata;

import rex.metadata.resultelements.Tuple;
import rex.utils.S;

public class CubeSlicer {
    private short[] axisOrd;
    private Tuple[] slicerTuple;
    short rowAxisOrd;
    short colAxisOrd;

    public CubeSlicer(short _rowAxisOrd, short _colAxisOrd) {
        this(_rowAxisOrd, _colAxisOrd, null, null);
    }

    public CubeSlicer(short _rowAxisOrd, short _colAxisOrd, short[] _axisOrd, Tuple[] _slicerTuple) {
        this.rowAxisOrd = _rowAxisOrd;
        this.colAxisOrd = _colAxisOrd;
        this.axisOrd = _axisOrd;
        this.slicerTuple = _slicerTuple;
    }

    public short getSlicerCount() {
        return (short)this.axisOrd.length;
    }

    public short getAxisSlicer(int i) {
        if (i >= this.axisOrd.length || this.axisOrd.length == 0) {
            S.out("assert: getSlicerAxis(" + i + ") while axisOrd.length = " + this.axisOrd.length);
        }
        return this.axisOrd[i];
    }

    public short getRowAxisOrdinal() {
        return this.rowAxisOrd;
    }

    public String getRowAxisName() {
        return "Axis" + this.rowAxisOrd;
    }

    public short getColAxisOrdinal() {
        return this.colAxisOrd;
    }

    public String getColAxisName() {
        return "Axis" + this.colAxisOrd;
    }

    public Tuple getTupleForAxisNo(int axisNo) {
        for (int i = 0; i < this.axisOrd.length; ++i) {
            if (this.axisOrd[i] != axisNo) continue;
            return this.slicerTuple[i];
        }
        S.out("assert: getTupleForAxisNo(" + axisNo + ") returned null !!");
        return null;
    }
}

