/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import javax.swing.UIManager;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.UIDependent;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIColorHighlighterAddon;

public final class HighlighterFactory {
    public static final Color BEIGE = new Color(245, 245, 220);
    public static final Color LINE_PRINTER = new Color(204, 204, 255);
    public static final Color CLASSIC_LINE_PRINTER = new Color(204, 255, 204);
    public static final Color FLORAL_WHITE = new Color(255, 250, 240);
    public static final Color QUICKSILVER = new Color(240, 240, 224);
    public static final Color GENERIC_GRAY = new Color(229, 229, 229);
    public static final Color LEDGER = new Color(245, 255, 245);
    public static final Color NOTEPAD = new Color(255, 255, 204);

    public static Highlighter createSimpleStriping() {
        UIColorHighlighter hl = new UIColorHighlighter(HighlightPredicate.ODD);
        return hl;
    }

    public static Highlighter createSimpleStriping(int rowsPerGroup) {
        return new UIColorHighlighter(new HighlightPredicate.RowGroupHighlightPredicate(rowsPerGroup));
    }

    public static Highlighter createSimpleStriping(Color stripeBackground) {
        ColorHighlighter hl = new ColorHighlighter(stripeBackground, null, HighlightPredicate.ODD);
        return hl;
    }

    public static Highlighter createSimpleStriping(Color stripeBackground, int rowsPerGroup) {
        HighlightPredicate.RowGroupHighlightPredicate predicate = new HighlightPredicate.RowGroupHighlightPredicate(rowsPerGroup);
        ColorHighlighter hl = new ColorHighlighter(stripeBackground, null, predicate);
        return hl;
    }

    public static Highlighter createAlternateStriping() {
        ColorHighlighter first = new ColorHighlighter(Color.WHITE, null, HighlightPredicate.EVEN);
        UIColorHighlighter hl = new UIColorHighlighter(HighlightPredicate.ODD);
        return new CompoundHighlighter(first, hl);
    }

    public static Highlighter createAlternateStriping(int rowsPerGroup) {
        HighlightPredicate.RowGroupHighlightPredicate predicate = new HighlightPredicate.RowGroupHighlightPredicate(rowsPerGroup);
        ColorHighlighter first = new ColorHighlighter(Color.WHITE, null, new HighlightPredicate.NotHighlightPredicate(predicate));
        UIColorHighlighter hl = new UIColorHighlighter(predicate);
        return new CompoundHighlighter(first, hl);
    }

    public static Highlighter createAlternateStriping(Color baseBackground, Color alternateBackground) {
        ColorHighlighter base = new ColorHighlighter(baseBackground, null, HighlightPredicate.EVEN);
        ColorHighlighter alternate = new ColorHighlighter(alternateBackground, null, HighlightPredicate.ODD);
        return new CompoundHighlighter(base, alternate);
    }

    public static Highlighter createAlternateStriping(Color baseBackground, Color alternateBackground, int linesPerStripe) {
        HighlightPredicate.RowGroupHighlightPredicate predicate = new HighlightPredicate.RowGroupHighlightPredicate(linesPerStripe);
        ColorHighlighter base = new ColorHighlighter(baseBackground, null, new HighlightPredicate.NotHighlightPredicate(predicate));
        ColorHighlighter alternate = new ColorHighlighter(alternateBackground, null, predicate);
        return new CompoundHighlighter(base, alternate);
    }

    public static class UIColorHighlighter
    extends ColorHighlighter
    implements UIDependent {
        public UIColorHighlighter() {
            this(null);
        }

        public UIColorHighlighter(HighlightPredicate odd) {
            super(null, null, odd);
            this.updateUI();
        }

        public void updateUI() {
            this.setBackground(this.getUIColor());
        }

        private Color getUIColor() {
            Color color = UIManager.getColor("UIColorHighlighter.stripingBackground");
            if (color == null) {
                color = GENERIC_GRAY;
            }
            return color;
        }

        static {
            LookAndFeelAddons.contribute(new UIColorHighlighterAddon());
        }
    }
}

