/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.export.flex.JRSwfExporter;
import net.sf.jasperreports.export.flex.JRSwfExporterParameter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRSwfSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_SWF = ".swf";

    public JRSwfSaveContributor(Locale locale, ResourceBundle resBundle) {
        super(locale, resBundle);
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName().toLowerCase();
        return name.endsWith(EXTENSION_SWF);
    }

    public String getDescription() {
        return this.getBundleString("file.desc.swf");
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().toLowerCase().endsWith(EXTENSION_SWF)) {
            file = new File(file.getAbsolutePath() + EXTENSION_SWF);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(this.getBundleString("file.exists"), file.getName()), this.getBundleString("save"), 2)) {
            JRSwfExporter exporter = new JRSwfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
            exporter.setParameter((JRExporterParameter)JRSwfExporterParameter.IS_EMBEDDING_IMAGES, Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRSwfExporterParameter.IS_EMBEDDING_FONTS, Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRSwfExporterParameter.USE_NETWORK, Boolean.TRUE);
            exporter.exportReport();
        }
    }
}

