/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar.util;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class TextIcon
implements Icon,
PropertyChangeListener {
    public static final int ROTATE_NONE = 1;
    public static final int ROTATE_LEFT = 2;
    public static final int ROTATE_RIGHT = 4;
    private static final double NINETY_DEGREES = Math.toRadians(90.0);
    private Component mComponent;
    private String mText;
    private Icon mIcon;
    private int mIconSpace;
    private int mInset;
    private int mWidth;
    private int mHeight;
    private int mCharHeight;
    private int mDescent;
    private int mRotation;

    public TextIcon(Component cmp, int space, int inset) {
        this.mComponent = cmp;
        this.mText = "";
        this.mIcon = null;
        this.mRotation = 1;
        this.mIconSpace = space;
        this.mInset = inset;
        this.calcDimensions();
        this.mComponent.addPropertyChangeListener(this);
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        boolean changed = this.isChanged(this.mText, text);
        this.mText = text;
        if (changed) {
            this.recalcDimensions();
        }
    }

    public void setIcon(Icon icon) {
        boolean changed = this.isChanged(this.mIcon, icon);
        this.mIcon = icon;
        if (changed) {
            this.recalcDimensions();
        }
    }

    public void setRotation(int rotation) {
        boolean changed = (rotation = TextIcon.getValidRotation(rotation)) == this.mRotation;
        this.mRotation = rotation;
        if (changed) {
            this.recalcDimensions();
        }
    }

    public static int getValidRotation(int rotation) {
        switch (rotation) {
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        return 1;
    }

    private boolean isChanged(Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return false;
        }
        if (oldValue == null || newValue == null) {
            return true;
        }
        return !oldValue.equals(newValue);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("font")) {
            this.recalcDimensions();
        }
    }

    private void recalcDimensions() {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        this.calcDimensions();
        if (w != this.getIconWidth() || h != this.getIconHeight()) {
            this.mComponent.invalidate();
        }
    }

    private void calcDimensions() {
        FontMetrics fm = this.mComponent.getFontMetrics(this.mComponent.getFont());
        this.mCharHeight = fm.getAscent() + fm.getDescent();
        this.mDescent = fm.getDescent();
        if (this.mRotation == 1) {
            this.mHeight = Math.max(this.mCharHeight, this.mIcon != null ? this.mIcon.getIconHeight() : 0);
            this.mWidth = fm.stringWidth(this.mText) + (this.mIcon != null ? this.mIcon.getIconWidth() + this.mIconSpace : 0);
        } else {
            this.mWidth = Math.max(this.mCharHeight, this.mIcon != null ? this.mIcon.getIconHeight() : 0);
            this.mHeight = fm.stringWidth(this.mText) + (this.mIcon != null ? this.mIcon.getIconWidth() + this.mIconSpace : 0);
        }
        this.mWidth += 2 * this.mInset;
        this.mHeight += 2 * this.mInset;
    }

    public int getIconWidth() {
        return this.mWidth;
    }

    public int getIconHeight() {
        return this.mHeight;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(c.getForeground());
        g2d.setFont(c.getFont());
        if (this.mRotation == 1) {
            if (this.mIcon != null) {
                int iconHeight = this.mIcon.getIconHeight();
                this.mIcon.paintIcon(this.mComponent, g, x += this.mInset, (y += this.mInset) + (this.mHeight - 2 * this.mInset - iconHeight) / 2);
                x += this.mIconSpace + this.mIcon.getIconWidth();
            }
            Object renderingHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawString(this.mText, x, this.mHeight - this.mDescent - this.mInset);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        } else if (this.mRotation == 2) {
            int translateX = x + this.mWidth - this.mInset;
            int translateY = y + this.mHeight - this.mInset;
            g2d.translate(translateX, translateY);
            g2d.rotate(-NINETY_DEGREES);
            if (this.mIcon != null) {
                int iconHeight = this.mIcon.getIconHeight();
                int iconOffset = (this.mWidth - 2 * this.mInset - iconHeight) / 2;
                this.mIcon.paintIcon(this.mComponent, g2d, 0, -this.mIcon.getIconWidth() - iconOffset);
            }
            Object renderingHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.drawString(this.mText, this.mIcon != null ? this.mIcon.getIconHeight() + this.mIconSpace : 0, -this.mDescent);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
            g2d.rotate(NINETY_DEGREES);
            g2d.translate(-translateX, -translateY);
        } else if (this.mRotation == 4) {
            int translateX = x + this.mInset;
            int translateY = y + this.mInset;
            g2d.translate(translateX, translateY);
            g2d.rotate(NINETY_DEGREES);
            if (this.mIcon != null) {
                int iconHeight = this.mIcon.getIconHeight();
                int iconOffset = (this.mWidth - 2 * this.mInset - iconHeight) / 2;
                this.mIcon.paintIcon(this.mComponent, g2d, 0, -this.mIcon.getIconWidth() - iconOffset);
            }
            Object renderingHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.drawString(this.mText, this.mIcon != null ? this.mIcon.getIconHeight() + this.mIconSpace : 0, -this.mDescent);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
            g2d.rotate(-NINETY_DEGREES);
            g2d.translate(-translateX, -translateY);
        }
    }

    public void validate() {
        this.calcDimensions();
    }
}

