/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.Parser;
import bsh.TargetError;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.ExpressionContext;
import it.businesslogic.ireport.IRParsingException;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.CrosstabParameter;
import it.businesslogic.ireport.crosstab.Measure;
import it.businesslogic.ireport.gui.CrosstabReportElementWrapper;
import it.businesslogic.ireport.gui.DocumentExpressionEditorTreeCellRenderer;
import it.businesslogic.ireport.gui.IconedString;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.TextAreaCellRenderer;
import it.businesslogic.ireport.gui.expbuilder.ArithmeticOperationHelper;
import it.businesslogic.ireport.gui.expbuilder.ExpObject;
import it.businesslogic.ireport.gui.expbuilder.ExpObjectCellRenderer;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.JRFakeObject;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.codehaus.groovy.control.CompilationFailedException;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;

public class ExpressionEditor
extends JDialog
implements CaretListener {
    public static final int VARIABLE = 1;
    public static final int PARAMETER = 2;
    public static final int FIELD = 3;
    private SubDataset subDataset = null;
    private Vector crosstabElements = new Vector();
    public static Vector defaultExpressions = null;
    public boolean init = false;
    public static Vector recentExpressions = new Vector();
    Style errorStyle = null;
    Style okStyle = null;
    DefaultStyledDocument doc = null;
    static int xxx;
    private JButton jButtonApply;
    private JButton jButtonCancel;
    private JButton jButtonCheckExpression;
    private JButton jButtonLoadExpression;
    private JButton jButtonSaveExpression;
    private JEditTextArea jEditTextArea1;
    private JLabel jLabel1;
    private JLabel jLabelCaretPosition;
    private JList jList1;
    private JList jList2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane3;
    private JSplitPane jSplitPaneOAE;
    private JTabbedPane jTabbedPane1;
    private JTextPane jTextPaneErrors;
    private JTree jTree1;
    private String Expression;
    private int dialogResult;

    public ExpressionEditor() {
        super((Frame)MainFrame.getMainInstance(), true);
        this.initComponents();
        this.setSize(750, 450);
        this.setModal(true);
        SyntaxDocument sd = new SyntaxDocument();
        sd.setTokenMarker(new JavaTokenMarker());
        this.jEditTextArea1.setDocument(sd);
        this.jEditTextArea1.getPainter().setEOLMarkersPainted(false);
        this.jEditTextArea1.getPainter().setInvalidLinesPainted(false);
        this.jEditTextArea1.getPainter().setLineHighlightEnabled(false);
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode("root");
        this.jTree1.setCellRenderer(new DocumentExpressionEditorTreeCellRenderer());
        this.jTree1.setModel(new DefaultTreeModel(dmtn));
        Misc.centerFrame(this);
        this.jList1.setModel(new DefaultListModel());
        this.jList2.setModel(new DefaultListModel());
        this.jEditTextArea1.requestFocusInWindow();
        this.jEditTextArea1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                ExpressionEditor.this.jRTextExpressionAreaTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                ExpressionEditor.this.jRTextExpressionAreaTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                ExpressionEditor.this.jRTextExpressionAreaTextChanged();
            }
        });
        this.jEditTextArea1.addCaretListener(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ExpressionEditor.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        ListSelectionModel listSelectionModel = this.jList1.getSelectionModel();
        this.jList1.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        this.jList1.setCellRenderer(new ExpObjectCellRenderer(this.jList1));
        this.jList2.setCellRenderer(new TextAreaCellRenderer(this.jList2));
        this.jSplitPane3.updateUI();
        this.applyI18n();
        this.caretUpdate(null);
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ExpressionEditor.this.jTabbedPane1.getSelectedIndex() == 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                ExpressionEditor.this.validateExpression();
                            }
                            catch (Exception ex) {
                                ExpressionEditor.this.setErrorText("Exception occurred during the expression validation", true);
                            }
                        }
                    });
                }
            }
        });
        this.doc = new DefaultStyledDocument();
        this.jTextPaneErrors.setDocument(this.doc);
        this.errorStyle = this.doc.addStyle("errorStyle", null);
        StyleConstants.setForeground(this.errorStyle, Color.red);
        this.okStyle = this.doc.addStyle("okStyle", null);
        StyleConstants.setForeground(this.okStyle, Color.blue);
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel6 = new JPanel();
        this.jEditTextArea1 = new JEditTextArea();
        this.jLabel1 = new JLabel();
        this.jLabelCaretPosition = new JLabel();
        this.jPanel5 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jSplitPaneOAE = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.jSplitPane3 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jScrollPane3 = new JScrollPane();
        this.jList2 = new JList();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jScrollPane4 = new JScrollPane();
        this.jTextPaneErrors = new JTextPane();
        this.jPanel2 = new JPanel();
        this.jButtonLoadExpression = new JButton();
        this.jButtonSaveExpression = new JButton();
        this.jButtonCheckExpression = new JButton();
        this.jButtonApply = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("Expression editor...");
        this.setModal(true);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ExpressionEditor.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ExpressionEditor.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setPreferredSize(new Dimension(752, 416));
        this.jSplitPane1.setDividerSize(4);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jEditTextArea1.setBorder(BorderFactory.createBevelBorder(1));
        this.jEditTextArea1.setFocusCycleRoot(true);
        this.jEditTextArea1.setFont(new Font("Courier New", 0, 11));
        this.jEditTextArea1.setMinimumSize(new Dimension(20, 20));
        this.jEditTextArea1.setPreferredSize(new Dimension(750, 150));
        this.jEditTextArea1.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ExpressionEditor.this.jEditTextArea1ComponentResized(evt);
            }
        });
        this.jEditTextArea1.addInputMethodListener(new InputMethodListener(){

            public void caretPositionChanged(InputMethodEvent evt) {
            }

            public void inputMethodTextChanged(InputMethodEvent evt) {
                ExpressionEditor.this.jEditTextArea1InputMethodTextChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.jEditTextArea1, gridBagConstraints);
        this.jLabel1.setForeground(new Color(255, 0, 51));
        this.jLabel1.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel6.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabelCaretPosition.setHorizontalAlignment(4);
        this.jLabelCaretPosition.setText("Line: 1   Column: 1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel6.add((Component)this.jLabelCaretPosition, gridBagConstraints);
        this.jSplitPane1.setTopComponent(this.jPanel6);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jSplitPaneOAE.setBorder(null);
        this.jSplitPaneOAE.setDividerSize(4);
        this.jSplitPaneOAE.setResizeWeight(0.1);
        this.jSplitPaneOAE.setAutoscrolls(true);
        this.jSplitPaneOAE.setPreferredSize(new Dimension(361, 160));
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.setPreferredSize(new Dimension(100, 100));
        this.jSplitPane3.setBorder(null);
        this.jSplitPane3.setDividerSize(4);
        this.jSplitPane3.setResizeWeight(0.8);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ExpressionEditor.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ExpressionEditor.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jSplitPane3.setLeftComponent(this.jScrollPane1);
        this.jList2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ExpressionEditor.this.jList2MouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jList2);
        this.jSplitPane3.setRightComponent(this.jScrollPane3);
        this.jPanel4.add((Component)this.jSplitPane3, "Center");
        this.jSplitPaneOAE.setRightComponent(this.jPanel4);
        this.jPanel4.getAccessibleContext().setAccessibleParent(this.jPanel1);
        this.jPanel3.setLayout(new BorderLayout());
        this.jScrollPane2.setPreferredSize(new Dimension(100, 100));
        this.jTree1.setRootVisible(false);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ExpressionEditor.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTree1);
        this.jPanel3.add((Component)this.jScrollPane2, "Center");
        this.jSplitPaneOAE.setLeftComponent(this.jPanel3);
        this.jPanel3.getAccessibleContext().setAccessibleParent(this.jPanel1);
        this.jTabbedPane1.addTab("Objects and expressions", this.jSplitPaneOAE);
        this.jTextPaneErrors.setEditable(false);
        this.jScrollPane4.setViewportView(this.jTextPaneErrors);
        this.jTabbedPane1.addTab("Validation errors", this.jScrollPane4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel5);
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(10, 30));
        this.jPanel2.setPreferredSize(new Dimension(10, 30));
        this.jButtonLoadExpression.setLabel("Import...");
        this.jButtonLoadExpression.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor.this.jButtonLoadExpressionActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jButtonLoadExpression, gridBagConstraints);
        this.jButtonSaveExpression.setText("Export...");
        this.jButtonSaveExpression.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor.this.jButtonSaveExpressionActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jButtonSaveExpression, gridBagConstraints);
        this.jButtonCheckExpression.setText("Check expression");
        this.jButtonCheckExpression.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor.this.jButtonCheckExpressionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jButtonCheckExpression, gridBagConstraints);
        this.jButtonApply.setMnemonic('a');
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor.this.jButtonApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jButtonApply, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jButtonCancel, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void jButtonCheckExpressionActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ExpressionEditor.this.validateExpression();
                }
                catch (Exception ex) {
                    ExpressionEditor.this.setErrorText("Exception occurred during the expression validation", true);
                }
            }
        });
    }

    private void jButtonSaveExpressionActionPerformed1(ActionEvent evt) {
        Misc.saveExpression(this.jEditTextArea1.getText(), this);
    }

    private void jButtonLoadExpressionActionPerformed1(ActionEvent evt) {
        String expression = Misc.loadExpression(this);
        if (expression != null) {
            this.jEditTextArea1.setText(expression);
        }
    }

    public void jRTextExpressionAreaTextChanged() {
        if (this.init) {
            return;
        }
        this.jLabel1.setText(" ");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Parser parser = new Parser((Reader)new StringReader(ExpressionEditor.this.jEditTextArea1.getText() + ";"));
                    while (!parser.Line()) {
                    }
                }
                catch (Throwable ex) {
                    ExpressionEditor.this.jLabel1.setText("" + ex.getMessage());
                }
            }
        });
    }

    private void jEditTextArea1InputMethodTextChanged(InputMethodEvent evt) {
    }

    private void jList2MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && this.jList1.getSelectedValue() != null && this.jList2.getSelectedValue() != null) {
            try {
                String objName = "";
                objName = this.jList1.getSelectedValue() instanceof ExpObject ? ((ExpObject)this.jList1.getSelectedValue()).getExpression() : "" + this.jList1.getSelectedValue();
                String method = this.jList2.getSelectedValue() + "";
                method = method.substring(0, method.lastIndexOf(")") + 1);
                this.jEditTextArea1.getDocument().replace(this.jEditTextArea1.getSelectionStart(), this.jEditTextArea1.getSelectionEnd() - this.jEditTextArea1.getSelectionStart(), objName + "." + method, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.jTree1.getSelectionPath().getLastPathComponent();
            if (("" + dmtn.getUserObject()).equalsIgnoreCase(I18n.getString("Wizards", "Wizards"))) {
                ArithmeticOperationHelper aoe = new ArithmeticOperationHelper();
                aoe.setLanguage(MainFrame.getMainInstance().getActiveReportFrame().getReport().getLanguage());
                if ((this.jList1.getSelectedValue() + "").equals(I18n.getString("Addition", "Addition (+)"))) {
                    aoe.setOperation("+");
                }
                if ((this.jList1.getSelectedValue() + "").equals(I18n.getString("Subtraction", "Subtraction (-)"))) {
                    aoe.setOperation("-");
                }
                if ((this.jList1.getSelectedValue() + "").equals(I18n.getString("Division", "Division (/)"))) {
                    aoe.setOperation("/");
                }
                if ((this.jList1.getSelectedValue() + "").equals(I18n.getString("Multiplication", "Multiplication (*)"))) {
                    aoe.setOperation("*");
                }
                aoe.setValues(this.getAllObjects());
                if (aoe.showDialog(this) == 0) {
                    String exp = aoe.getExpression();
                    try {
                        this.jEditTextArea1.getDocument().replace(this.jEditTextArea1.getSelectionStart(), this.jEditTextArea1.getSelectionEnd() - this.jEditTextArea1.getSelectionStart(), exp, null);
                    }
                    catch (Exception ex) {}
                }
            } else {
                try {
                    String objName = "";
                    objName = this.jList1.getSelectedValue() instanceof ExpObject ? ((ExpObject)this.jList1.getSelectedValue()).getExpression() : "" + this.jList1.getSelectedValue();
                    this.jEditTextArea1.getDocument().replace(this.jEditTextArea1.getSelectionStart(), this.jEditTextArea1.getSelectionEnd() - this.jEditTextArea1.getSelectionStart(), objName + "", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jList2.getModel();
        dlm.removeAllElements();
        Class<?> clazz = null;
        if (this.jList1.getSelectedValue() instanceof ExpObject) {
            try {
                clazz = this.getClass().getClassLoader().loadClass(((ExpObject)this.jList1.getSelectedValue()).getClassType());
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (clazz != null) {
            Method[] methods = clazz.getMethods();
            Arrays.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method m1, Method m2) {
                    return m1.getName().compareTo(m2.getName());
                }
            });
            for (int i = 0; i < methods.length; ++i) {
                if ((methods[i].getModifiers() & 1) == 0) continue;
                String method_firm = methods[i].getName() + "(";
                Class<?>[] params = methods[i].getParameterTypes();
                int j = 0;
                for (j = 0; j < params.length; ++j) {
                    method_firm = j > 0 ? method_firm + ", " : method_firm + " ";
                    method_firm = method_firm + this.getPrintableTypeName(params[j].getName());
                }
                if (j > 0) {
                    method_firm = method_firm + " ";
                }
                method_firm = method_firm + ") ";
                String rname = methods[i].getReturnType().getName();
                if (rname.equals("void")) continue;
                method_firm = method_firm + this.getPrintableTypeName(rname);
                dlm.addElement(method_firm);
            }
        }
    }

    public String getPrintableTypeName(String type) {
        if (type == null) {
            return "void";
        }
        if (type.endsWith(";")) {
            type = type.substring(0, type.length() - 1);
        }
        while (type.startsWith("[")) {
            if ((type = type.substring(1) + "[]").startsWith("[")) continue;
            if (type.startsWith("L")) {
                type = type.substring(1);
            }
            if (type.startsWith("Z")) {
                type = "boolean" + type.substring(1);
            }
            if (type.startsWith("B")) {
                type = "byte" + type.substring(1);
            }
            if (type.startsWith("C")) {
                type = "char" + type.substring(1);
            }
            if (type.startsWith("D")) {
                type = "double" + type.substring(1);
            }
            if (type.startsWith("F")) {
                type = "float" + type.substring(1);
            }
            if (type.startsWith("I")) {
                type = "int" + type.substring(1);
            }
            if (type.startsWith("J")) {
                type = "long" + type.substring(1);
            }
            if (!type.startsWith("S")) continue;
            type = "short" + type.substring(1);
        }
        if (type.startsWith("java.lang.") && (type = type.substring("java.lang.".length())).indexOf(".") > 0) {
            type = "java.lang." + type;
        }
        return type;
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        ((DefaultListModel)this.jList1.getModel()).removeAllElements();
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.jTree1.getSelectionPath().getLastPathComponent();
        if (dmtn.getUserObject() instanceof CrosstabReportElementWrapper) {
            int i;
            CrosstabReportElement cr = ((CrosstabReportElementWrapper)dmtn.getUserObject()).getCrosstabReportElement();
            Enumeration e = cr.getMeasures().elements();
            while (e.hasMoreElements()) {
                CrosstabGroup group;
                int j;
                Measure measure = (Measure)e.nextElement();
                ((DefaultListModel)this.jList1.getModel()).addElement(new ExpObject(measure.getName(), 1, measure.getClassType()));
                for (j = 0; j < cr.getRowGroups().size(); ++j) {
                    group = (CrosstabGroup)cr.getRowGroups().elementAt(j);
                    ((DefaultListModel)this.jList1.getModel()).addElement(new ExpObject(measure.getName() + "_" + group.getName() + "_" + "ALL", 1, group.getBucketExpressionClass()));
                }
                for (j = 0; j < cr.getColumnGroups().size(); ++j) {
                    group = (CrosstabGroup)cr.getColumnGroups().elementAt(j);
                    ((DefaultListModel)this.jList1.getModel()).addElement(new ExpObject(measure.getName() + "_" + group.getName() + "_" + "ALL", 1, group.getBucketExpressionClass()));
                }
            }
            for (i = 0; i < cr.getRowGroups().size(); ++i) {
                CrosstabGroup group = (CrosstabGroup)cr.getRowGroups().elementAt(i);
                ((DefaultListModel)this.jList1.getModel()).addElement(new ExpObject(group.getName(), 1, group.getBucketExpressionClass()));
            }
            for (i = 0; i < cr.getColumnGroups().size(); ++i) {
                CrosstabGroup group = (CrosstabGroup)cr.getColumnGroups().elementAt(i);
                ((DefaultListModel)this.jList1.getModel()).addElement(new ExpObject(group.getName(), 1, group.getBucketExpressionClass()));
            }
            for (i = 0; i < cr.getCrosstabParameters().size(); ++i) {
                CrosstabParameter parameter = (CrosstabParameter)cr.getCrosstabParameters().elementAt(i);
                ((DefaultListModel)this.jList1.getModel()).addElement(new ExpObject(parameter.getName(), 2, parameter.getClassType()));
            }
        } else if (("" + dmtn.getUserObject()).equalsIgnoreCase("Fields") && this.getSubDataset() != null) {
            Enumeration e = this.getSubDataset().getFields().elements();
            while (e.hasMoreElements()) {
                JRField field = (JRField)e.nextElement();
                ((DefaultListModel)this.jList1.getModel()).addElement(new ExpObject(field.getName(), 0, field.getClassType()));
            }
        } else if (("" + dmtn.getUserObject()).equalsIgnoreCase("Parameters") && this.getSubDataset() != null) {
            Enumeration e = this.getSubDataset().getParameters().elements();
            while (e.hasMoreElements()) {
                JRParameter parameter = (JRParameter)e.nextElement();
                ((DefaultListModel)this.jList1.getModel()).addElement(new ExpObject(parameter.getName(), 2, parameter.getClassType()));
            }
        } else if (("" + dmtn.getUserObject()).equalsIgnoreCase("Variables") && this.getSubDataset() != null) {
            Enumeration e = this.getSubDataset().getVariables().elements();
            while (e.hasMoreElements()) {
                JRVariable variable = (JRVariable)e.nextElement();
                ((DefaultListModel)this.jList1.getModel()).addElement(new ExpObject(variable.getName(), 1, variable.getClassType()));
            }
        } else if (("" + dmtn.getUserObject()).equalsIgnoreCase(I18n.getString("Formulas", "Formulas"))) {
            for (int i = 0; i < defaultExpressions.size(); ++i) {
                ((DefaultListModel)this.jList1.getModel()).addElement(defaultExpressions.elementAt(i));
            }
        } else if (("" + dmtn.getUserObject()).equalsIgnoreCase(I18n.getString("RecentExpressions", "Recent expressions"))) {
            for (int i = 0; i < recentExpressions.size(); ++i) {
                ((DefaultListModel)this.jList1.getModel()).addElement(recentExpressions.elementAt(i));
            }
        } else if (("" + dmtn.getUserObject()).equalsIgnoreCase(I18n.getString("Wizards", "Wizards"))) {
            ((DefaultListModel)this.jList1.getModel()).addElement(I18n.getString("Addition", "Addition (+)"));
            ((DefaultListModel)this.jList1.getModel()).addElement(I18n.getString("Subtraction", "Subtraction (-)"));
            ((DefaultListModel)this.jList1.getModel()).addElement(I18n.getString("Division", "Division (/)"));
            ((DefaultListModel)this.jList1.getModel()).addElement(I18n.getString("Multiplication", "Multiplication (*)"));
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setDialogResult(1);
        this.dispose();
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.setExpression(this.jEditTextArea1.getText());
        recentExpressions.add(this.jEditTextArea1.getText());
        this.setDialogResult(0);
        this.dispose();
    }

    private void jEditTextArea1ComponentResized(ComponentEvent evt) {
    }

    private void formComponentResized(ComponentEvent evt) {
        this.jEditTextArea1.updateScrollBars();
    }

    private void exitForm(WindowEvent evt) {
    }

    public static void main(String[] args) {
        new ExpressionEditor().setVisible(true);
    }

    public String getExpression() {
        return this.Expression;
    }

    public void setExpression(String Expression) {
        this.init = true;
        this.jEditTextArea1.setText(Expression);
        this.Expression = Expression;
        this.init = false;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        if (subDataset != null) {
            this.jEditTextArea1.getTokenMarker().setKeywordLookup(subDataset.getKeywordLookup());
        }
        this.updateTreeEntries();
    }

    public void updateTreeEntries() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jTree1.getModel().getRoot();
        root.removeAllChildren();
        if (this.getSubDataset() != null) {
            root.add(new DefaultMutableTreeNode("Fields"));
            root.add(new DefaultMutableTreeNode("Variables"));
            root.add(new DefaultMutableTreeNode("Parameters"));
        }
        for (int i = 0; i < this.getCrosstabElements().size(); ++i) {
            root.add(new DefaultMutableTreeNode(new CrosstabReportElementWrapper((CrosstabReportElement)this.getCrosstabElements().get(i))));
        }
        root.add(new DefaultMutableTreeNode(I18n.getString("Formulas", "Formulas")));
        root.add(new DefaultMutableTreeNode(I18n.getString("RecentExpressions", "Recent expressions")));
        root.add(new DefaultMutableTreeNode(new IconedString(I18n.getString("Wizards", "Wizards"), "/it/businesslogic/ireport/icons/wand.png")));
        this.jTree1.expandPath(new TreePath(root));
        this.jTree1.updateUI();
        this.jTree1.setSelectionRow(0);
    }

    public Vector getCrosstabElements() {
        return this.crosstabElements;
    }

    public void setCrosstabElements(Vector crosstabElements) {
        this.crosstabElements = crosstabElements;
    }

    public void addCrosstabReportElement(CrosstabReportElement re) {
        if (!this.getCrosstabElements().contains(re)) {
            this.getCrosstabElements().add(re);
            this.updateTreeEntries();
        }
    }

    public void setExpressionContext(ExpressionContext ec) {
        if (ec == null) {
            return;
        }
        this.setCrosstabElements(ec.getCrosstabReportElements());
        this.setSubDataset(ec.getSubDataset());
    }

    public void caretUpdate(CaretEvent e) {
        MessageFormat formatter = new MessageFormat("");
        formatter.applyPattern(I18n.getString("LineColumn", "Line {0,number,integer}, Column {1,number,integer}"));
        if (this.jEditTextArea1.getCaretLine() < 0) {
            this.jLabelCaretPosition.setText(formatter.format(new Object[]{new Integer(0), new Integer(0)}));
        }
        String s = this.jEditTextArea1.getText();
        int pos = this.jEditTextArea1.getCaretPosition();
        int newLineStart = s.substring(0, this.jEditTextArea1.getCaretPosition()).lastIndexOf(10) + 1;
        pos -= newLineStart;
        this.jLabelCaretPosition.setText(formatter.format(new Object[]{new Integer(this.jEditTextArea1.getCaretLine() + 1), new Integer(++pos)}));
    }

    public void applyI18n() {
        this.jLabelCaretPosition.setText(I18n.getString("expressionEditor.labelCaretPosition", "Line: 1   Column: 1"));
        this.jButtonLoadExpression.setText(I18n.getString("import", "Import..."));
        this.jButtonSaveExpression.setText(I18n.getString("export", "Export..."));
        this.jButtonCheckExpression.setText(I18n.getString("checkExpression", "Check expression"));
        this.jButtonApply.setText(I18n.getString("gui.OptionsDialog.ButtonApply", "Apply"));
        this.jButtonCancel.setText(I18n.getString("gui.OptionsDialog.ButtonCancel", "Cancel"));
        this.jTabbedPane1.setTitleAt(0, I18n.getString("ObjectsAndExpressions", "Objects and expressions"));
        this.jTabbedPane1.setTitleAt(1, I18n.getString("ValidationErrors", "Validation errors"));
        this.jTabbedPane1.setTitleAt(0, I18n.getString("expressionEditor.tab.ObjectsAndExpressions", "Objects and expressions"));
        this.jTabbedPane1.setTitleAt(1, I18n.getString("expressionEditor.tab.ValidationErrors", "Validation errors"));
        this.setTitle(I18n.getString("expressionEditor.title", "Expression editor..."));
        this.jButtonCancel.setMnemonic(I18n.getString("expressionEditor.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonApply.setMnemonic(I18n.getString("expressionEditor.buttonApplyMnemonic", "a").charAt(0));
    }

    public void validateExpression() {
        String expression_to_validate = this.jEditTextArea1.getText();
        JRDesignExpression jrExpression = new JRDesignExpression();
        jrExpression.setText(expression_to_validate);
        this.jTextPaneErrors.setText("");
        try {
            ArrayList paramsObjects = new ArrayList();
            ArrayList varsObjects = new ArrayList();
            ArrayList fieldsObjects = new ArrayList();
            String final_espression = this.generateExpression((JRExpression)jrExpression, paramsObjects, fieldsObjects, varsObjects);
            if (MainFrame.getMainInstance().getActiveReportFrame().getReport().getLanguage().equals("groovy")) {
                String name;
                int i;
                Binding binding = new Binding();
                for (i = 0; i < paramsObjects.size(); ++i) {
                    name = "" + paramsObjects.get(i);
                    binding.setVariable(name, (Object)new JRFakeObject());
                }
                for (i = 0; i < varsObjects.size(); ++i) {
                    name = "" + varsObjects.get(i);
                    binding.setVariable(name, (Object)new JRFakeObject());
                }
                for (i = 0; i < fieldsObjects.size(); ++i) {
                    name = "" + fieldsObjects.get(i);
                    binding.setVariable(name, (Object)new JRFakeObject());
                }
                GroovyShell shell = new GroovyShell(binding);
                shell.parse(final_espression);
            } else if (MainFrame.getMainInstance().getActiveReportFrame().getReport().getLanguage().equals("java")) {
                String name;
                int i;
                Interpreter interpreter = new Interpreter();
                StringTokenizer st = new StringTokenizer(MainFrame.getMainInstance().getProperties().getProperty("classpath", ""), "\n");
                interpreter.eval("String tmp;");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token == null || token.trim().length() <= 0) continue;
                    interpreter.set("tmp", (Object)token.trim());
                    interpreter.eval("addClassPath(tmp);");
                }
                Enumeration imps = MainFrame.getMainInstance().getActiveReportFrame().getReport().getImports().elements();
                while (imps.hasMoreElements()) {
                    String var = (String)imps.nextElement();
                    interpreter.eval("import " + var + ";");
                }
                interpreter.eval("import java.util.*;");
                interpreter.eval("import java.math.*;");
                interpreter.eval("import java.text.*;");
                interpreter.eval("import java.io.*;");
                interpreter.eval("import java.net.*;");
                interpreter.setStrictJava(true);
                for (i = 0; i < paramsObjects.size(); ++i) {
                    name = "" + paramsObjects.get(i);
                    interpreter.set(name, (Object)new JRFakeObject());
                }
                for (i = 0; i < varsObjects.size(); ++i) {
                    name = "" + varsObjects.get(i);
                    interpreter.set(name, (Object)new JRFakeObject());
                }
                for (i = 0; i < fieldsObjects.size(); ++i) {
                    name = "" + fieldsObjects.get(i);
                    interpreter.set(name, (Object)new JRFakeObject());
                }
                interpreter.eval(final_espression);
            }
            this.setErrorText(I18n.getString("ValidationOK", "Expression successfully validated."), false);
        }
        catch (CompilationFailedException ex) {
            this.setErrorText(ex.getMessage(), true);
        }
        catch (ParseException ex) {
            this.setErrorText(ex.getMessage() + "\n" + ex.getErrorText() + "\nLine: " + ex.getErrorLineNumber(), true);
        }
        catch (TargetError ex) {
            this.setErrorText(I18n.getString("ValidationOK", "Expression successfully validated."), true);
        }
        catch (EvalError ex) {
            this.setErrorText(ex.getMessage() + "\n" + ex.getErrorText() + "\nLine: " + ex.getErrorLineNumber(), true);
        }
        catch (IRParsingException ex) {
            int pos;
            this.setErrorText(ex.getMessage(), true);
            if (ex.getChunk() != null && (pos = expression_to_validate.indexOf(ex.getChunk())) >= 0) {
                this.jEditTextArea1.setSelectionStart(pos);
                this.jEditTextArea1.setSelectionEnd(pos);
                this.jEditTextArea1.setSelectionEnd(pos + ex.getChunk().length());
            }
        }
        catch (Exception ex) {
            this.setErrorText(ex.getMessage(), true);
            ex.printStackTrace();
        }
        this.jTabbedPane1.setSelectedIndex(1);
    }

    private String generateExpression(JRExpression expression, List paramsObjects, List fieldsObjects, List varsObjects) throws IRParsingException {
        Object jrParameter = null;
        Object jrField = null;
        Object jrVariable = null;
        StringBuffer sb = new StringBuffer();
        JRExpressionChunk[] chunks = expression.getChunks();
        JRExpressionChunk chunk = null;
        String chunkText = null;
        if (chunks != null && chunks.length > 0) {
            block7: for (int i = 0; i < chunks.length; ++i) {
                chunk = chunks[i];
                chunkText = chunk.getText();
                if (chunkText == null) {
                    chunkText = "";
                }
                switch (chunk.getType()) {
                    case 1: {
                        sb.append(chunkText);
                        continue block7;
                    }
                    case 2: {
                        JRParameter param = (JRParameter)this.getExpressionObject(chunkText, 2);
                        sb.append("((");
                        sb.append(param.getClassType());
                        sb.append(")");
                        String vname = "parameter_" + JRStringUtil.getLiteral((String)chunkText);
                        sb.append(vname);
                        paramsObjects.add(vname);
                        sb.append(".getValue())");
                        continue block7;
                    }
                    case 3: {
                        JRField field = (JRField)this.getExpressionObject(chunkText, 3);
                        sb.append("((");
                        sb.append(field.getClassType());
                        sb.append(")");
                        String vname = "field_" + JRStringUtil.getLiteral((String)chunkText);
                        sb.append(vname);
                        fieldsObjects.add(vname);
                        sb.append(".get");
                        sb.append("Value())");
                        continue block7;
                    }
                    case 4: {
                        JRVariable variable = (JRVariable)this.getExpressionObject(chunkText, 1);
                        sb.append("((");
                        sb.append(variable.getClassType());
                        sb.append(")");
                        String vname = "variable_" + JRStringUtil.getLiteral((String)chunkText);
                        sb.append(vname);
                        varsObjects.add(vname);
                        sb.append(".get");
                        sb.append("Value())");
                        continue block7;
                    }
                    case 5: {
                        sb.append("str(\"");
                        sb.append(chunkText);
                        sb.append("\")");
                    }
                }
            }
        }
        if (sb.length() == 0) {
            sb.append("null");
        }
        return sb.toString();
    }

    private Object getExpressionObject(String name, int type) throws IRParsingException {
        if (name == null) {
            throw new IRParsingException("Object not found!");
        }
        SubDataset subDataset = this.getSubDataset();
        if (this.getSubDataset() == null && this.getCrosstabElements().size() == 0) {
            subDataset = MainFrame.getMainInstance().getActiveReportFrame().getReport();
        }
        if (type == 2) {
            if (subDataset != null) {
                Enumeration e = subDataset.getParameters().elements();
                while (e.hasMoreElements()) {
                    JRParameter p = (JRParameter)e.nextElement();
                    if (!p.getName().equals(name)) continue;
                    return p;
                }
            }
            for (int k = 0; k < this.crosstabElements.size(); ++k) {
                CrosstabReportElement cr = (CrosstabReportElement)this.crosstabElements.get(k);
                for (int i = 0; i < cr.getCrosstabParameters().size(); ++i) {
                    CrosstabParameter parameter = (CrosstabParameter)cr.getCrosstabParameters().elementAt(i);
                    if (!name.equals("" + parameter)) continue;
                    return new JRParameter(parameter.getName(), parameter.getClassType());
                }
            }
            throw new IRParsingException("Parameter " + name + " not found!", "$P{" + name + "}");
        }
        if (type == 3) {
            if (subDataset != null) {
                Enumeration e = subDataset.getFields().elements();
                while (e.hasMoreElements()) {
                    JRField p = (JRField)e.nextElement();
                    if (!p.getName().equals(name)) continue;
                    return p;
                }
            }
            throw new IRParsingException("Field " + name + " not found!", "$F{" + name + "}");
        }
        if (type == 1) {
            if (subDataset != null) {
                Enumeration e = subDataset.getVariables().elements();
                while (e.hasMoreElements()) {
                    JRVariable p = (JRVariable)e.nextElement();
                    if (!p.getName().equals(name)) continue;
                    return p;
                }
            }
            for (int k = 0; k < this.crosstabElements.size(); ++k) {
                int i;
                CrosstabReportElement cr = (CrosstabReportElement)this.crosstabElements.get(k);
                Enumeration e = cr.getMeasures().elements();
                while (e.hasMoreElements()) {
                    CrosstabGroup group;
                    int j;
                    Measure measure = (Measure)e.nextElement();
                    if (name.equals(measure.getName())) {
                        return new JRVariable(measure.getName(), measure.getClassType(), false);
                    }
                    for (j = 0; j < cr.getRowGroups().size(); ++j) {
                        group = (CrosstabGroup)cr.getRowGroups().elementAt(j);
                        if (!name.equals("" + measure + "_" + group.getName() + "_" + "ALL")) continue;
                        return new JRVariable(measure + "_" + group.getName(), group.getBucketExpressionClass(), false);
                    }
                    for (j = 0; j < cr.getColumnGroups().size(); ++j) {
                        group = (CrosstabGroup)cr.getColumnGroups().elementAt(j);
                        if (!name.equals("" + group + "_" + group.getName() + "_" + "ALL")) continue;
                        return new JRVariable(measure + "_" + group.getName(), group.getBucketExpressionClass(), false);
                    }
                }
                for (i = 0; i < cr.getRowGroups().size(); ++i) {
                    CrosstabGroup group = (CrosstabGroup)cr.getRowGroups().elementAt(i);
                    if (!name.equals("" + group)) continue;
                    return new JRVariable("" + group, group.getBucketExpressionClass(), false);
                }
                for (i = 0; i < cr.getColumnGroups().size(); ++i) {
                    CrosstabGroup group = (CrosstabGroup)cr.getColumnGroups().elementAt(i);
                    if (!name.equals("" + group)) continue;
                    return new JRVariable("" + group, group.getBucketExpressionClass(), false);
                }
            }
            throw new IRParsingException("Variable " + name + " not found!", "$F{" + name + "}");
        }
        throw new IRParsingException("Object " + name + " not found!", name);
    }

    public void setErrorText(String msg, boolean isError) {
        this.jTextPaneErrors.setText("");
        try {
            this.doc.insertString(this.doc.getLength(), msg, isError ? this.errorStyle : this.okStyle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List getAllObjects() {
        ArrayList<ExpObject> list = new ArrayList<ExpObject>();
        if (this.getSubDataset() != null) {
            Object f;
            Enumeration e = this.getSubDataset().getFields().elements();
            while (e.hasMoreElements()) {
                f = (JRField)e.nextElement();
                list.add(new ExpObject(((JRField)f).getName(), 0, ((JRField)f).getClassType()));
            }
            e = this.getSubDataset().getVariables().elements();
            while (e.hasMoreElements()) {
                f = (JRVariable)e.nextElement();
                list.add(new ExpObject(((JRVariable)f).getName(), 1, ((JRVariable)f).getClassType()));
            }
            e = this.getSubDataset().getParameters().elements();
            while (e.hasMoreElements()) {
                f = (JRParameter)e.nextElement();
                list.add(new ExpObject(((JRParameter)f).getName(), 2, ((JRParameter)f).getClassType()));
            }
        }
        for (int ct = 0; ct < this.getCrosstabElements().size(); ++ct) {
            int i;
            CrosstabReportElement cr = (CrosstabReportElement)this.getCrosstabElements().get(ct);
            Enumeration e = cr.getMeasures().elements();
            while (e.hasMoreElements()) {
                CrosstabGroup group;
                int j;
                Measure measure = (Measure)e.nextElement();
                list.add(new ExpObject(measure.getName(), 1, measure.getClassType()));
                for (j = 0; j < cr.getRowGroups().size(); ++j) {
                    group = (CrosstabGroup)cr.getRowGroups().elementAt(j);
                    list.add(new ExpObject(measure.getName() + "_" + group.getName() + "_" + "ALL", 1, measure.getClassType()));
                }
                for (j = 0; j < cr.getColumnGroups().size(); ++j) {
                    group = (CrosstabGroup)cr.getColumnGroups().elementAt(j);
                    list.add(new ExpObject(measure.getName() + "_" + group.getName() + "_" + "ALL", 1, measure.getClassType()));
                }
            }
            for (i = 0; i < cr.getRowGroups().size(); ++i) {
                CrosstabGroup group = (CrosstabGroup)cr.getRowGroups().elementAt(i);
                list.add(new ExpObject(group.getName(), 1, group.getBucketExpressionClass()));
            }
            for (i = 0; i < cr.getColumnGroups().size(); ++i) {
                CrosstabGroup group = (CrosstabGroup)cr.getColumnGroups().elementAt(i);
                list.add(new ExpObject(group.getName(), 1, group.getBucketExpressionClass()));
            }
            for (i = 0; i < cr.getCrosstabParameters().size(); ++i) {
                CrosstabParameter parameter = (CrosstabParameter)cr.getCrosstabParameters().elementAt(i);
                list.add(new ExpObject(parameter.getName(), 2, parameter.getClassType()));
            }
        }
        return list;
    }

    static {
        defaultExpressions = new Vector();
        defaultExpressions.add("( <condition> ? exp1 : exp2 )");
        defaultExpressions.add("msg(<pattern>, <arg0>)");
        defaultExpressions.add("msg(<pattern>, <arg0>, <arg1>)");
        defaultExpressions.add("msg(<pattern>, <arg0>, <arg1>, <arg2>)");
        defaultExpressions.add("str(<key>)");
        defaultExpressions.add("((net.sf.jasperreports.engine.data.JRXmlDataSource)$P{REPORT_DATA_SOURCE}).subDataSource(<select expression>)");
        defaultExpressions.add("((net.sf.jasperreports.engine.data.JRXmlDataSource)$P{REPORT_DATA_SOURCE}).dataSource(<select expression>)");
        xxx = 0;
    }
}

