/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.RepositoryFolder;
import com.jaspersoft.jasperserver.irplugin.gui.DataTypeDialog;
import com.jaspersoft.jasperserver.irplugin.gui.ListOfValuesDialog;
import com.jaspersoft.jasperserver.irplugin.gui.QueryDialog;
import com.jaspersoft.jasperserver.irplugin.gui.ValidationUtils;
import com.jaspersoft.jasperserver.irplugin.gui.explorer.ResourceChooser;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InputControlDialog
extends JDialog {
    private int dialogResult = 2;
    private JServer server = null;
    private String parentFolder = null;
    private RepositoryFolder resource = null;
    private String reportUnitUri = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private ResourceDescriptor lovResourceDescriptor = null;
    private ResourceDescriptor dataTypeResourceDescriptor = null;
    private ResourceDescriptor queryResourceDescriptor = null;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonAddColumn;
    private JButton jButtonClose;
    private JButton jButtonEditLocalResource;
    private JButton jButtonEditLocalResource1;
    private JButton jButtonModColumn;
    private JButton jButtonPickResource;
    private JButton jButtonPickResource1;
    private JButton jButtonRemColumn;
    private JButton jButtonSave;
    private JCheckBox jCheckBoxMandatory;
    private JCheckBox jCheckBoxReadOnly;
    private JComboBox jComboBoxType;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabel1;
    private JLabel jLabelDescription;
    private JLabel jLabelLabel;
    private JLabel jLabelLocate;
    private JLabel jLabelLocate1;
    private JLabel jLabelLocate2;
    private JLabel jLabelLocate3;
    private JLabel jLabelMandatory;
    private JLabel jLabelName;
    private JLabel jLabelReadOnly;
    private JLabel jLabelType;
    private JLabel jLabelUriString;
    private JList jListColumns;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanelFields;
    private JPanel jPanelLocate;
    private JPanel jPanelLocateQuery;
    private JPanel jPanelQuery;
    private JPanel jPanelVisibleColumns;
    private JRadioButton jRadioButtonLocal;
    private JRadioButton jRadioButtonLocal1;
    private JRadioButton jRadioButtonRepo;
    private JRadioButton jRadioButtonRepo1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPane2;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldName;
    private JTextField jTextFieldResource;
    private JTextField jTextFieldResource1;
    private JTextField jTextFieldUriString;
    private JTextField jTextFieldValueColumn;

    public InputControlDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Misc.centerFrame((Component)this);
        DocumentListener changesListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                InputControlDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                InputControlDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                InputControlDialog.this.updateSaveButton();
            }
        };
        this.jComboBoxType.addItem(new Tag((Object)"1", IRPlugin.getString("inputControlDialog.type.1", "Boolean")));
        this.jComboBoxType.addItem(new Tag((Object)"2", IRPlugin.getString("inputControlDialog.type.2", "Single Value")));
        this.jComboBoxType.addItem(new Tag((Object)"3", IRPlugin.getString("inputControlDialog.type.3", "Single Select List of Values")));
        this.jComboBoxType.addItem(new Tag((Object)"8", IRPlugin.getString("inputControlDialog.type.8", "Single Select List of Values (Radio)")));
        this.jComboBoxType.addItem(new Tag((Object)"6", IRPlugin.getString("inputControlDialog.type.6", "Multi Select List of Values")));
        this.jComboBoxType.addItem(new Tag((Object)"10", IRPlugin.getString("inputControlDialog.type.10", "Multi Select List of Values (Checkbox)")));
        this.jComboBoxType.addItem(new Tag((Object)"4", IRPlugin.getString("inputControlDialog.type.4", "Single Select Query")));
        this.jComboBoxType.addItem(new Tag((Object)"9", IRPlugin.getString("inputControlDialog.type.9", "Single Select Query (Radio)")));
        this.jComboBoxType.addItem(new Tag((Object)"7", IRPlugin.getString("inputControlDialog.type.7", "Multi Select Query")));
        this.jComboBoxType.addItem(new Tag((Object)"11", IRPlugin.getString("inputControlDialog.type.11", "Multi Select Query (Checkbox)")));
        this.jComboBoxType.setSelectedIndex(0);
        this.jTextFieldLabel.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.requestFocusInWindow();
        this.jListColumns.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                boolean b = InputControlDialog.this.jListColumns.getSelectedIndex() >= 0;
                InputControlDialog.this.jButtonModColumn.setEnabled(b);
                InputControlDialog.this.jButtonRemColumn.setEnabled(b);
            }
        });
        this.jListColumns.setModel(new DefaultListModel());
        this.applyI18n();
    }

    public void applyI18n() {
        this.jButtonClose.setText(IRPlugin.getString("inputControlDialog.buttonCancel", "Cancel"));
        this.jButtonSave.setText(IRPlugin.getString("inputControlDialog.buttonSave", "Save"));
        this.jButtonAddColumn.setText(IRPlugin.getString("inputControlDialog.buttonAddColumn", "Add"));
        this.jButtonEditLocalResource.setText(IRPlugin.getString("inputControlDialog.buttonEditLocalResource", "Edit local resource"));
        this.jButtonEditLocalResource1.setText(IRPlugin.getString("inputControlDialog.buttonEditLocalResource", "Edit local resource"));
        this.jButtonModColumn.setText(IRPlugin.getString("inputControlDialog.buttonModifyColumn", "Modify"));
        this.jButtonPickResource.setText(IRPlugin.getString("inputControlDialog.buttonPickResource", "Browse"));
        this.jButtonPickResource1.setText(IRPlugin.getString("inputControlDialog.buttonPickResource", "Browse"));
        this.jButtonRemColumn.setText(IRPlugin.getString("inputControlDialog.buttonRemColumn", "Remove"));
        this.jLabel1.setText(IRPlugin.getString("inputControlDialog.title", "Input Control"));
        this.jLabelDescription.setText(IRPlugin.getString("inputControlDialog.labelDescription", "Description"));
        this.jLabelLabel.setText(IRPlugin.getString("inputControlDialog.labelLabel", "Label"));
        this.jLabelLocate.setText(IRPlugin.getString("inputControlDialog.labelLocateLOV", "Locate List of Values"));
        this.jLabelLocate1.setText(IRPlugin.getString("inputControlDialog.labelLocateQuery", "Locate query"));
        this.jLabelLocate2.setText(IRPlugin.getString("inputControlDialog.labelValueColumn", "Value column"));
        this.jLabelLocate3.setText(IRPlugin.getString("inputControlDialog.labelVisibleColumns", "Visible query columns"));
        this.jLabelMandatory.setText(IRPlugin.getString("inputControlDialog.labelMandatory", "Mandatory"));
        this.jLabelName.setText(IRPlugin.getString("inputControlDialog.labelName", "Name"));
        this.jLabelUriString.setText(IRPlugin.getString("inputControlDialog.labelParentFolder", "Parent folder"));
        this.jLabelReadOnly.setText(IRPlugin.getString("inputControlDialog.labelReadOnly", "Read Only"));
        this.jLabelType.setText(IRPlugin.getString("inputControlDialog.labelType", "Type"));
        this.jRadioButtonLocal.setText(IRPlugin.getString("inputControlDialog.radioLocallyDefined", "Locally Defined"));
        this.jRadioButtonLocal1.setText(IRPlugin.getString("inputControlDialog.radioLocallyDefined", "Locally Defined"));
        this.jRadioButtonRepo.setText(IRPlugin.getString("inputControlDialog.radioRepo", "From the repository"));
        this.jRadioButtonRepo1.setText(IRPlugin.getString("inputControlDialog.radioRepo", "From the repository"));
        this.jTabbedPane1.setTitleAt(0, IRPlugin.getString("inputControlDialog.tabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, IRPlugin.getString("inputControlDialog.tabDetails", "Input control details"));
        this.jTabbedPane2.setTitleAt(0, IRPlugin.getString("inputControlDialog.tabQueryResource", "Query resource"));
        this.jTabbedPane2.setTitleAt(1, IRPlugin.getString("inputControlDialog.tabQueryColumns", "Value and visible columns"));
    }

    private void updateSaveButton() {
        if (this.jTextFieldLabel.getText().length() > 0 && this.jTextFieldName.getText().length() > 0) {
            this.jButtonSave.setEnabled(true);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jLabelDescription = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabelType = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jLabelMandatory = new JLabel();
        this.jCheckBoxMandatory = new JCheckBox();
        this.jLabelReadOnly = new JLabel();
        this.jCheckBoxReadOnly = new JCheckBox();
        this.jSeparator4 = new JSeparator();
        this.jPanel5 = new JPanel();
        this.jPanelLocate = new JPanel();
        this.jLabelLocate = new JLabel();
        this.jRadioButtonRepo = new JRadioButton();
        this.jTextFieldResource = new JTextField();
        this.jButtonPickResource = new JButton();
        this.jRadioButtonLocal = new JRadioButton();
        this.jButtonEditLocalResource = new JButton();
        this.jPanel6 = new JPanel();
        this.jPanelQuery = new JPanel();
        this.jTabbedPane2 = new JTabbedPane();
        this.jPanelLocateQuery = new JPanel();
        this.jLabelLocate1 = new JLabel();
        this.jRadioButtonRepo1 = new JRadioButton();
        this.jTextFieldResource1 = new JTextField();
        this.jButtonPickResource1 = new JButton();
        this.jRadioButtonLocal1 = new JRadioButton();
        this.jButtonEditLocalResource1 = new JButton();
        this.jPanel7 = new JPanel();
        this.jPanelFields = new JPanel();
        this.jLabelLocate2 = new JLabel();
        this.jTextFieldValueColumn = new JTextField();
        this.jPanelVisibleColumns = new JPanel();
        this.jLabelLocate3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jListColumns = new JList();
        this.jPanel8 = new JPanel();
        this.jButtonAddColumn = new JButton();
        this.jButtonModColumn = new JButton();
        this.jButtonRemColumn = new JButton();
        this.jPanel4 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Input Control");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/datasource_new.png")));
        this.jLabel1.setText("Input Control");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setVerticalTextPosition(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel2.setPreferredSize(new Dimension(400, 185));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabelUriString.setText("Parent folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelName.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelLabel.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jTabbedPane1.addTab("General", this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelType.setHorizontalAlignment(4);
        this.jLabelType.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 20, 4, 0);
        this.jPanel3.add((Component)this.jLabelType, gridBagConstraints);
        this.jComboBoxType.setMinimumSize(new Dimension(23, 22));
        this.jComboBoxType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jComboBoxTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 4, 20);
        this.jPanel3.add((Component)this.jComboBoxType, gridBagConstraints);
        this.jLabelMandatory.setHorizontalAlignment(4);
        this.jLabelMandatory.setText("Mandatory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanel3.add((Component)this.jLabelMandatory, gridBagConstraints);
        this.jCheckBoxMandatory.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 20);
        this.jPanel3.add((Component)this.jCheckBoxMandatory, gridBagConstraints);
        this.jLabelReadOnly.setHorizontalAlignment(4);
        this.jLabelReadOnly.setText("Read Only");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 8, 0);
        this.jPanel3.add((Component)this.jLabelReadOnly, gridBagConstraints);
        this.jCheckBoxReadOnly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 8, 20);
        this.jPanel3.add((Component)this.jCheckBoxReadOnly, gridBagConstraints);
        this.jSeparator4.setMinimumSize(new Dimension(2, 2));
        this.jSeparator4.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.jPanel3.add((Component)this.jSeparator4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanelLocate.setLayout(new GridBagLayout());
        this.jLabelLocate.setText("Locate List of Values");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 8, 8);
        this.jPanelLocate.add((Component)this.jLabelLocate, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonRepo);
        this.jRadioButtonRepo.setText("From the repository");
        this.jRadioButtonRepo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonRepo.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonRepo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jRadioButtonRepoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanelLocate.add((Component)this.jRadioButtonRepo, gridBagConstraints);
        this.jTextFieldResource.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 4, 0);
        this.jPanelLocate.add((Component)this.jTextFieldResource, gridBagConstraints);
        this.jButtonPickResource.setText("Browse");
        this.jButtonPickResource.setEnabled(false);
        this.jButtonPickResource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jButtonPickResourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 8);
        this.jPanelLocate.add((Component)this.jButtonPickResource, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonLocal);
        this.jRadioButtonLocal.setSelected(true);
        this.jRadioButtonLocal.setText("Locally Defined");
        this.jRadioButtonLocal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonLocal.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonLocal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jRadioButtonLocalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanelLocate.add((Component)this.jRadioButtonLocal, gridBagConstraints);
        this.jButtonEditLocalResource.setText("Edit local resource");
        this.jButtonEditLocalResource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jButtonEditLocalResourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanelLocate.add((Component)this.jButtonEditLocalResource, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelLocate.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel5.add((Component)this.jPanelLocate, gridBagConstraints);
        this.jPanelQuery.setLayout(new GridBagLayout());
        this.jPanelLocateQuery.setLayout(new GridBagLayout());
        this.jLabelLocate1.setText("Locate query");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 8, 8);
        this.jPanelLocateQuery.add((Component)this.jLabelLocate1, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButtonRepo1);
        this.jRadioButtonRepo1.setText("From the repository");
        this.jRadioButtonRepo1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonRepo1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonRepo1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jRadioButtonRepoActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanelLocateQuery.add((Component)this.jRadioButtonRepo1, gridBagConstraints);
        this.jTextFieldResource1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 4, 0);
        this.jPanelLocateQuery.add((Component)this.jTextFieldResource1, gridBagConstraints);
        this.jButtonPickResource1.setText("Browse");
        this.jButtonPickResource1.setEnabled(false);
        this.jButtonPickResource1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jButtonPickResourceActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 8);
        this.jPanelLocateQuery.add((Component)this.jButtonPickResource1, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButtonLocal1);
        this.jRadioButtonLocal1.setSelected(true);
        this.jRadioButtonLocal1.setText("Locally Defined");
        this.jRadioButtonLocal1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonLocal1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonLocal1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jRadioButtonLocalActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanelLocateQuery.add((Component)this.jRadioButtonLocal1, gridBagConstraints);
        this.jButtonEditLocalResource1.setText("Edit local resource");
        this.jButtonEditLocalResource1.setActionCommand("Edit local query resource");
        this.jButtonEditLocalResource1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jButtonEditLocalResourceActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanelLocateQuery.add((Component)this.jButtonEditLocalResource1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelLocateQuery.add((Component)this.jPanel7, gridBagConstraints);
        this.jTabbedPane2.addTab("Query resource", this.jPanelLocateQuery);
        this.jPanelFields.setLayout(new GridBagLayout());
        this.jLabelLocate2.setText("Value column");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 8, 8);
        this.jPanelFields.add((Component)this.jLabelLocate2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 8, 8);
        this.jPanelFields.add((Component)this.jTextFieldValueColumn, gridBagConstraints);
        this.jPanelVisibleColumns.setLayout(new GridBagLayout());
        this.jLabelLocate3.setText("Visible query columns");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelVisibleColumns.add((Component)this.jLabelLocate3, gridBagConstraints);
        this.jListColumns.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                InputControlDialog.this.jListColumnsMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jListColumns);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelVisibleColumns.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jButtonAddColumn.setText("Add");
        this.jButtonAddColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jButtonAddColumnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel8.add((Component)this.jButtonAddColumn, gridBagConstraints);
        this.jButtonModColumn.setText("Modify");
        this.jButtonModColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jButtonModColumnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel8.add((Component)this.jButtonModColumn, gridBagConstraints);
        this.jButtonRemColumn.setText("Remove");
        this.jButtonRemColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jButtonRemColumnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel8.add((Component)this.jButtonRemColumn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelVisibleColumns.add((Component)this.jPanel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelFields.add((Component)this.jPanelVisibleColumns, gridBagConstraints);
        this.jTabbedPane2.addTab("Value and visible columns", this.jPanelFields);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelQuery.add((Component)this.jTabbedPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel5.add((Component)this.jPanelQuery, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        this.jTabbedPane1.addTab("Input Control details", this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel4.setMinimumSize(new Dimension(10, 30));
        this.jPanel4.setPreferredSize(new Dimension(10, 30));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButtonSave.setText("Save");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputControlDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void jButtonRemColumnActionPerformed(ActionEvent evt) {
        int[] keys = this.jListColumns.getSelectedIndices();
        DefaultListModel dlm = (DefaultListModel)this.jListColumns.getModel();
        for (int i = keys.length - 1; i >= 0; --i) {
            dlm.remove(keys[i]);
        }
    }

    private void jButtonAddColumnActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog((Component)MainFrame.getMainInstance(), (Object)IRPlugin.getString("inputControlDialog.columnName", "Column name"));
        if (s != null && s.trim().length() > 0) {
            ((DefaultListModel)this.jListColumns.getModel()).addElement(s);
        }
    }

    private void jButtonModColumnActionPerformed(ActionEvent evt) {
        int i = this.jListColumns.getSelectedIndex();
        if (i < 0) {
            return;
        }
        String s = "" + this.jListColumns.getSelectedValue();
        s = JOptionPane.showInputDialog((Component)MainFrame.getMainInstance(), IRPlugin.getString("inputControlDialog.columnName", "Column name"), s);
        if (s != null && s.trim().length() > 0) {
            ((DefaultListModel)this.jListColumns.getModel()).setElementAt(s, i);
        }
    }

    private void jListColumnsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1 && this.jListColumns.getSelectedIndex() >= 0) {
                this.jButtonModColumnActionPerformed(null);
            }
        }
    }

    private void jButtonEditLocalResourceActionPerformed1(ActionEvent evt) {
        this.jButtonEditLocalResourceActionPerformed(evt);
    }

    private void jRadioButtonLocalActionPerformed1(ActionEvent evt) {
        this.updateQueryResourceFromType();
    }

    private void jButtonPickResourceActionPerformed1(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        rc.setServer(this.getServer());
        if (rc.showDialog(this, null) == 0) {
            ResourceDescriptor rd = rc.getSelectedDescriptor();
            if (rd == null || rd.getUriString() == null) {
                this.jTextFieldResource1.setText("");
            } else {
                this.jTextFieldResource1.setText(rd.getUriString());
            }
            this.updateSaveButton();
        }
    }

    private void jRadioButtonRepoActionPerformed1(ActionEvent evt) {
        this.updateQueryResourceFromType();
    }

    private void jButtonEditLocalResourceActionPerformed(ActionEvent evt) {
        byte b = Byte.parseByte(((Tag)this.jComboBoxType.getSelectedItem()).getValue() + "");
        if (b == 2) {
            DataTypeDialog dtd = new DataTypeDialog((Frame)MainFrame.getMainInstance(), true);
            dtd.setServer(this.getServer());
            dtd.setParentFolder(this.getParentFolder() + "/<inputControl>");
            dtd.setDoNotStore(true);
            if (this.dataTypeResourceDescriptor != null) {
                dtd.setResource(this.dataTypeResourceDescriptor);
            }
            ((Component)dtd).setVisible(true);
            if (dtd.getDialogResult() == 0) {
                this.dataTypeResourceDescriptor = dtd.getNewResourceDescriptor();
            }
        } else if (b == 3 || b == 6 || b == 8 || b == 10) {
            ListOfValuesDialog dtd = new ListOfValuesDialog((Frame)MainFrame.getMainInstance(), true);
            dtd.setServer(this.getServer());
            dtd.setParentFolder(this.getParentFolder() + "/<inputControl>");
            dtd.setDoNotStore(true);
            if (this.lovResourceDescriptor != null) {
                dtd.setResource(this.lovResourceDescriptor);
            }
            ((Component)dtd).setVisible(true);
            if (dtd.getDialogResult() == 0) {
                this.lovResourceDescriptor = dtd.getNewResourceDescriptor();
            }
        } else if (b == 4 || b == 7 || b == 9 || b == 11) {
            QueryDialog dtd = new QueryDialog((Frame)MainFrame.getMainInstance(), true);
            dtd.setServer(this.getServer());
            dtd.setParentFolder(this.getParentFolder() + "/<inputControl>");
            dtd.setDoNotStore(true);
            List datasources = null;
            if (IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
                try {
                    datasources = this.getServer().getWSClient().listDatasources();
                    dtd.setDatasources(datasources);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), IRPlugin.getFormattedString("repositoryExplorer.message.errorListingDatasources", "Error getting the list of available datasources:\n{0}", new Object[]{ex.getMessage()}));
                    ex.printStackTrace();
                }
            }
            if (this.queryResourceDescriptor != null) {
                dtd.setResource(this.queryResourceDescriptor);
            }
            ((Component)dtd).setVisible(true);
            if (dtd.getDialogResult() == 0) {
                this.queryResourceDescriptor = dtd.getNewResourceDescriptor();
            }
        }
    }

    private void jButtonPickResourceActionPerformed(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        rc.setServer(this.getServer());
        if (rc.showDialog(this, null) == 0) {
            ResourceDescriptor rd = rc.getSelectedDescriptor();
            if (rd == null || rd.getUriString() == null) {
                this.jTextFieldResource.setText("");
            } else {
                this.jTextFieldResource.setText(rd.getUriString());
            }
            this.updateSaveButton();
        }
    }

    private void jComboBoxTypeActionPerformed(ActionEvent evt) {
        String value = ((Tag)this.jComboBoxType.getSelectedItem()).getValue() + "";
        int ic_type = Integer.parseInt(value);
        if (ic_type == 1) {
            this.jPanelLocate.setVisible(false);
            this.jPanelQuery.setVisible(false);
        } else if (ic_type == 2) {
            this.jPanelLocate.setVisible(true);
            this.jLabelLocate.setText(IRPlugin.getString("inputControlDialog.labelLocateDataType", "Locate (Data Type)"));
            this.jButtonEditLocalResource.setText(IRPlugin.getString("inputControlDialog.buttonEditLocalResourceDT", "Edit local resource (Data Type)"));
            this.jPanelQuery.setVisible(false);
        } else if (ic_type == 3 || ic_type == 8 || ic_type == 6 || ic_type == 10) {
            this.jPanelLocate.setVisible(true);
            this.jLabelLocate.setText(IRPlugin.getString("inputControlDialog.labelLocateLOV", "Locate (List of Values)"));
            this.jButtonEditLocalResource.setText(IRPlugin.getString("inputControlDialog.buttonEditLocalResourceLOV", "Edit local resource (List of Values)"));
            this.jPanelQuery.setVisible(false);
        } else if (ic_type == 4 || ic_type == 9 || ic_type == 7 || ic_type == 11) {
            this.jPanelLocate.setVisible(false);
            this.jPanelQuery.setVisible(true);
        }
    }

    private void jRadioButtonLocalActionPerformed(ActionEvent evt) {
        this.updateResourceFromType();
    }

    private void jRadioButtonRepoActionPerformed(ActionEvent evt) {
        this.updateResourceFromType();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    /*
     * Unable to fully structure code
     */
    private void jButtonSaveActionPerformed(ActionEvent evt) {
        rd = new ResourceDescriptor();
        rd.setDescription(this.jEditorPaneDescription.getText().trim());
        rd.setName(this.jTextFieldName.getText());
        uri = this.getParentFolder();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + this.jTextFieldName.getText();
        rd.setUriString(uri);
        rd.setLabel(this.jTextFieldLabel.getText().trim());
        rd.setParentFolder(this.getParentFolder());
        rd.setIsNew(this.resource == null);
        rd.setWsType("inputControl");
        rd.setMandatory(this.jCheckBoxMandatory.isSelected());
        rd.setReadOnly(this.jCheckBoxReadOnly.isSelected());
        rd.setControlType(Byte.parseByte(((Tag)this.jComboBoxType.getSelectedItem()).getValue() + ""));
        if (rd.getControlType() == 3 | rd.getControlType() == 8) ** GOTO lbl-1000
        if (rd.getControlType() == 6) ** GOTO lbl-1000
        if (rd.getControlType() == 10) lbl-1000:
        // 3 sources

        {
            if (this.jRadioButtonLocal.isSelected() && (this.lovResourceDescriptor == null || !this.lovResourceDescriptor.getWsType().equals("lov"))) {
                JOptionPane.showMessageDialog(this, "The local list of values defined is not valid.\nPress the button \"Edit local resource\" to fix the problem.");
                return;
            }
            if (this.jRadioButtonRepo1.isSelected() && this.jTextFieldResource1.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Please set a valid reference to a List Of Values in the Repository.");
                this.jTextFieldResource1.requestFocusInWindow();
                return;
            }
        } else if (rd.getControlType() == 2) {
            if (this.jRadioButtonLocal.isSelected() && (this.dataTypeResourceDescriptor == null || !this.dataTypeResourceDescriptor.getWsType().equals("dataType"))) {
                JOptionPane.showMessageDialog(this, "The local data type defined is not valid.\nPress the button \"Edit local resource\" to fix the problem.");
                return;
            }
            if (this.jRadioButtonRepo.isSelected() && this.jTextFieldResource.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Please set a valid reference to a data type in the Repository.");
                this.jTextFieldResource.requestFocusInWindow();
                return;
            }
        } else if (rd.getControlType() == 4 || rd.getControlType() == 9 || rd.getControlType() == 7 || rd.getControlType() == 11) {
            if (this.jRadioButtonLocal1.isSelected() && (this.queryResourceDescriptor == null || !this.queryResourceDescriptor.getWsType().equals("query"))) {
                JOptionPane.showMessageDialog(this, "The local query defined is not valid.\nPress the button \"Edit local resource\" to fix the problem.");
                return;
            }
            if (this.jRadioButtonRepo1.isSelected() && this.jTextFieldResource1.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Please set a valid reference to a Query object in the Repository.");
                this.jTextFieldResource1.requestFocusInWindow();
                return;
            }
            if (this.jTextFieldValueColumn.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Please set the value column.");
                return;
            }
            if (this.jListColumns.getModel().getSize() == 0) {
                JOptionPane.showMessageDialog(this, "Please set at least one visible column in the visible columns list.");
                return;
            }
            rd.setQueryValueColumn(this.jTextFieldValueColumn.getText());
            count = this.jListColumns.getModel().getSize();
            visibleColumns = new String[count];
            for (i = 0; i < count; ++i) {
                visibleColumns[i] = this.jListColumns.getModel().getElementAt(i) + "";
            }
            rd.setQueryVisibleColumns(visibleColumns);
        }
        try {
            block30: {
                block33: {
                    block32: {
                        block31: {
                            this.validate(rd);
                            rdChild = null;
                            if (rd.getControlType() == 1) break block30;
                            if (rd.getControlType() != 4 && rd.getControlType() != 9 && rd.getControlType() != 7 && rd.getControlType() != 11) break block31;
                            if (this.jRadioButtonRepo1.isSelected()) {
                                rdChild = new ResourceDescriptor();
                                rdChild.setWsType("reference");
                                rdChild.setReferenceUri(this.jTextFieldResource1.getText().trim());
                            } else {
                                rdChild = this.queryResourceDescriptor;
                            }
                            break block30;
                        }
                        if (rd.getControlType() != 2) break block32;
                        if (this.jRadioButtonRepo.isSelected()) {
                            rdChild = new ResourceDescriptor();
                            rdChild.setWsType("reference");
                            rdChild.setReferenceUri(this.jTextFieldResource.getText().trim());
                        } else {
                            rdChild = this.dataTypeResourceDescriptor;
                        }
                        break block30;
                    }
                    if (rd.getControlType() == 3 | rd.getControlType() == 8) break block33;
                    if (rd.getControlType() == 6) break block33;
                    if (rd.getControlType() != 10) break block30;
                }
                if (this.jRadioButtonRepo.isSelected()) {
                    rdChild = new ResourceDescriptor();
                    rdChild.setWsType("reference");
                    rdChild.setReferenceUri(this.jTextFieldResource.getText().trim());
                } else {
                    rdChild = this.lovResourceDescriptor;
                }
            }
            if (rdChild != null) {
                if (rd.getChildren() == null) {
                    rd.setChildren(new ArrayList<E>());
                }
                rd.getChildren().add(rdChild);
            }
            this.newResourceDescriptor = this.getServer().getWSClient().modifyReportUnitResource(this.getReportUnitUri(), rd, null);
            this.setDialogResult(0);
            if (this.resource != null) {
                this.resource.setDescriptor(this.newResourceDescriptor);
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
        if (this.reportUnitUri != null && this.reportUnitUri.length() > 0) {
            this.parentFolder = this.reportUnitUri + "_files";
        }
        this.jTextFieldUriString.setText(parentFolder);
    }

    public String getReportUnitUri() {
        return this.reportUnitUri;
    }

    public void setReportUnitUri(String reportUnitUri) {
        this.reportUnitUri = reportUnitUri;
        if (reportUnitUri != null && reportUnitUri.length() > 0) {
            this.setParentFolder(reportUnitUri + "_files");
        }
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }

    public void setResource(RepositoryFolder resource) {
        this.resource = resource;
        if (resource != null) {
            this.setResource(resource.getDescriptor());
        }
        this.jTextFieldName.setEditable(false);
        this.jTextFieldName.setOpaque(false);
    }

    public void setResource(ResourceDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.jTextFieldName.setText(descriptor.getName());
        this.jTextFieldLabel.setText(descriptor.getLabel());
        this.jEditorPaneDescription.setText(descriptor.getDescription());
        System.out.println("Mandatory: " + descriptor.isMandatory());
        System.out.println("ReadOnly: " + descriptor.isReadOnly());
        this.jCheckBoxMandatory.setSelected(descriptor.isMandatory());
        this.jCheckBoxReadOnly.setSelected(descriptor.isReadOnly());
        Misc.setComboboxSelectedTagValue((JComboBox)this.jComboBoxType, (String)("" + descriptor.getControlType()));
        if (descriptor.getQueryValueColumn() != null) {
            this.jTextFieldValueColumn.setText(descriptor.getQueryValueColumn());
        }
        if (descriptor.getQueryVisibleColumns() != null) {
            String[] visibleColumns = descriptor.getQueryVisibleColumns();
            DefaultListModel dlm = (DefaultListModel)this.jListColumns.getModel();
            for (int i = 0; i < visibleColumns.length; ++i) {
                dlm.addElement(visibleColumns[i]);
            }
        }
        if (descriptor.getChildren().size() > 0) {
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(0);
            if (rd.getWsType().equals("reference")) {
                if (descriptor.getControlType() == 4 || descriptor.getControlType() == 9 || descriptor.getControlType() == 7 || descriptor.getControlType() == 11) {
                    this.jTextFieldResource1.setText(rd.getReferenceUri());
                    this.jRadioButtonRepo1.setSelected(true);
                } else {
                    this.jTextFieldResource.setText(rd.getReferenceUri());
                    this.jRadioButtonRepo.setSelected(true);
                }
            } else {
                this.jRadioButtonLocal.setSelected(true);
                if (rd.getWsType().equals("dataType")) {
                    this.dataTypeResourceDescriptor = rd;
                } else if (rd.getWsType().equals("lov")) {
                    this.lovResourceDescriptor = rd;
                } else if (rd.getWsType().equals("query")) {
                    this.queryResourceDescriptor = rd;
                }
            }
            if (descriptor.getControlType() == 4 || descriptor.getControlType() == 9 || descriptor.getControlType() == 7 || descriptor.getControlType() == 11) {
                this.updateQueryResourceFromType();
            } else {
                this.updateResourceFromType();
            }
        }
    }

    public void validate(ResourceDescriptor dataType) throws Exception {
        ValidationUtils.validateName(dataType.getName());
        ValidationUtils.validateLabel(dataType.getLabel());
        ValidationUtils.validateDesc(dataType.getDescription());
    }

    public void updateResourceFromType() {
        this.jTextFieldResource.setEnabled(this.jRadioButtonRepo.isSelected());
        this.jButtonPickResource.setEnabled(this.jRadioButtonRepo.isSelected());
        this.jButtonEditLocalResource.setEnabled(this.jRadioButtonLocal.isSelected());
    }

    public void updateQueryResourceFromType() {
        this.jTextFieldResource1.setEnabled(this.jRadioButtonRepo1.isSelected());
        this.jButtonPickResource1.setEnabled(this.jRadioButtonRepo1.isSelected());
        this.jButtonEditLocalResource1.setEnabled(this.jRadioButtonLocal1.isSelected());
    }
}

