/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NameMappings {
    private Map namespaceMap = new HashMap();
    private Set lookupOnly = new HashSet();

    public NameMappings copy() {
        NameMappings m = new NameMappings();
        Iterator i = this.namespaceMap.keySet().iterator();
        while (i.hasNext()) {
            String uri = (String)i.next();
            Map classMap = (Map)this.namespaceMap.get(uri);
            m.namespaceMap.put(uri, new HashMap(classMap));
        }
        m.lookupOnly.addAll(this.lookupOnly);
        return m;
    }

    public String lookupPackageName(String nsURI, String localPart) {
        String className = this.lookupClassName(nsURI, localPart);
        if (className == null) {
            return null;
        }
        int index = className.indexOf(":");
        return index == -1 ? "" : className.substring(0, index);
    }

    public String lookupClassName(String nsURI, String localPart) {
        Map classMap = (Map)this.namespaceMap.get(nsURI);
        return classMap == null ? null : (String)classMap.get(localPart);
    }

    public String resolveClassName(String namespaceURI, String localPart) {
        String className = this.lookupClassName(namespaceURI, localPart);
        if (className == null) {
            if ("*".equals(namespaceURI)) {
                className = localPart;
            } else if (namespaceURI.length() > 2 && namespaceURI.endsWith(".*")) {
                className = namespaceURI.substring(0, namespaceURI.length() - 2) + ':' + localPart;
                className = className.intern();
            }
        }
        return className;
    }

    public Map getNamespace(String nsURI) {
        return (Map)this.namespaceMap.get(nsURI);
    }

    public Set getNamespaces() {
        return this.namespaceMap.keySet();
    }

    public void addMappings(NameMappings other) {
        Iterator nit = other.namespaceMap.entrySet().iterator();
        while (nit.hasNext()) {
            Map.Entry e = nit.next();
            String namespaceURI = (String)e.getKey();
            Map mappings = (Map)e.getValue();
            Iterator it = mappings.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry lc = it.next();
                String local = (String)lc.getKey();
                String className = (String)lc.getValue();
                this.addClass(namespaceURI, local, className);
            }
        }
    }

    public boolean addClass(String namespaceURI, String localPart, String className) {
        Map<String, String> classMap = null;
        if (this.namespaceMap.containsKey(namespaceURI)) {
            classMap = (Map)this.namespaceMap.get(namespaceURI);
        } else {
            classMap = new HashMap();
            this.namespaceMap.put(namespaceURI.intern(), classMap);
        }
        String current = (String)classMap.get(localPart);
        if (current == null) {
            classMap.put(localPart.intern(), className.intern());
        } else if (!current.equals(className)) {
            return false;
        }
        return true;
    }

    public void addLookupOnly(String cls) {
        this.lookupOnly.add(cls);
    }

    public boolean isLookupOnly(String cls) {
        return this.lookupOnly.contains(cls);
    }
}

