/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.swf.tags.DoABC;
import flash.util.Trace;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Component;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcFile;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SwcGroup {
    private Map swcs;
    private NameMappings nameMappings = new NameMappings();
    private Map files = new HashMap();
    private Set qnames;
    private Map def2script;
    static final /* synthetic */ boolean $assertionsDisabled;

    SwcGroup(Map swcs) {
        this.swcs = swcs;
        this.updateNameMappings();
        this.updateFiles();
        this.updateMaps();
    }

    public int getNumberLoaded() {
        return this.swcs.size();
    }

    public NameMappings getNameMappings() {
        return this.nameMappings;
    }

    public Map getScriptMap() {
        return this.def2script;
    }

    public Set getQNames() {
        return this.qnames;
    }

    public Map getFiles() {
        return this.files;
    }

    public VirtualFile getFile(String name) {
        Swc swc;
        VirtualFile swcFile = null;
        String location = SwcFile.getSwcLocation(name);
        String fileName = SwcFile.getFilePath(name);
        if (location != null && fileName != null && (swc = (Swc)this.swcs.get(location)) != null) {
            swcFile = swc.getFile(fileName);
        }
        return swcFile;
    }

    public Swc getSwc(String name) {
        if (name == null) {
            throw new NullPointerException("getSwc: name may not be null");
        }
        return (Swc)this.swcs.get(name);
    }

    public Map getSwcs() {
        return this.swcs;
    }

    public List getSwcTimes() {
        ArrayList<Long> lastModified = new ArrayList<Long>();
        Iterator iterator = this.swcs.values().iterator();
        while (iterator.hasNext()) {
            Swc swc = (Swc)iterator.next();
            lastModified.add(new Long(swc.getLastModified()));
        }
        return lastModified;
    }

    public void close() {
        Iterator iterator = this.swcs.values().iterator();
        while (iterator.hasNext()) {
            Swc swc = (Swc)iterator.next();
            swc.close();
        }
    }

    private void updateNameMappings() {
        Iterator iter = this.swcs.values().iterator();
        while (iter.hasNext()) {
            Swc swc = (Swc)iter.next();
            Iterator iter2 = swc.getComponentIterator();
            while (iter2.hasNext()) {
                boolean success;
                Component component = (Component)iter2.next();
                String namespaceURI = component.getUri();
                String name = component.getName();
                if (namespaceURI == null) continue;
                if ("".equals(namespaceURI)) {
                    if (name == null) continue;
                    SwcException.EmptyNamespace e = new SwcException.EmptyNamespace(name);
                    ThreadLocalToolkit.log(e);
                    throw e;
                }
                String className = component.getClassName();
                if (name == null) {
                    name = NameFormatter.retrieveClassName(className);
                }
                if (success = this.nameMappings.addClass(namespaceURI, name, className)) continue;
                SwcException.ComponentDefinedTwice e = new SwcException.ComponentDefinedTwice(name, className, this.nameMappings.lookupClassName(namespaceURI, name));
                ThreadLocalToolkit.log(e);
                throw e;
            }
        }
    }

    private void updateFiles() {
        Iterator iterator = this.swcs.values().iterator();
        while (iterator.hasNext()) {
            Swc swc = (Swc)iterator.next();
            Iterator it = swc.getCatalogFiles().values().iterator();
            while (it.hasNext()) {
                VirtualFile curFile;
                VirtualFile file = (VirtualFile)it.next();
                String name = file.getName();
                String swcName = SwcFile.getFilePath(name);
                if (swcName != null) {
                    name = swcName;
                }
                if ((curFile = (VirtualFile)this.files.get(name)) != null && file.getLastModified() <= curFile.getLastModified()) continue;
                this.files.put(name, file);
            }
        }
    }

    private void updateMaps() {
        ArrayList<SwcScript> scriptList = new ArrayList<SwcScript>();
        Iterator swcit = this.swcs.values().iterator();
        while (swcit.hasNext()) {
            Swc swc = (Swc)swcit.next();
            Iterator libit = swc.getLibraryIterator();
            while (libit.hasNext()) {
                SwcLibrary lib = (SwcLibrary)libit.next();
                Iterator scriptit = lib.getScriptIterator();
                while (scriptit.hasNext()) {
                    SwcScript script = (SwcScript)scriptit.next();
                    scriptList.add(script);
                }
            }
        }
        Object[] scriptArray = scriptList.toArray();
        Arrays.sort(scriptArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                long o2mod;
                long o1mod = ((SwcScript)o1).getLastModified();
                if (o1mod == (o2mod = ((SwcScript)o2).getLastModified())) {
                    return 0;
                }
                if (o1mod < o2mod) {
                    return 1;
                }
                return -1;
            }
        });
        this.def2script = new HashMap();
        this.qnames = new HashSet();
        for (int i = 0; i < scriptArray.length; ++i) {
            SwcScript s = (SwcScript)scriptArray[i];
            String name = s.getName();
            DoABC doABC = null;
            try {
                doABC = s.getDoABC();
            }
            catch (Exception e) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                SwcException.SwcNotLoaded ex = new SwcException.SwcNotLoaded(s.getSwcLocation(), e);
                ThreadLocalToolkit.log(ex);
                throw ex;
            }
            if (!$assertionsDisabled && !name.equals(doABC.name)) {
                throw new AssertionError();
            }
            HashMap<String, SwcScript> staging = new HashMap<String, SwcScript>();
            Iterator defit = s.getDefinitionIterator();
            while (defit.hasNext()) {
                String def = (String)defit.next();
                staging.put(def, s);
                if (!this.def2script.containsKey(def)) continue;
                staging = null;
                break;
            }
            if (staging == null) continue;
            Iterator iterator = staging.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String def = (String)entry.getKey();
                this.qnames.add(new QName(def));
                this.def2script.put(def, entry.getValue());
                if (!Trace.swc) continue;
                Trace.trace((String)("Using " + def + " from " + s.getLibrary().getSwcLocation() + "(" + s.getName() + ")"));
            }
        }
    }

    static {
        $assertionsDisabled = !SwcGroup.class.desiredAssertionStatus();
    }
}

