/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.analyzer.HTTPServiceAnalyzer;
import flex2.compiler.mxml.builder.ComponentBuilder;
import flex2.compiler.mxml.builder.ServiceRequestBuilder;
import flex2.compiler.mxml.dom.HTTPServiceNode;
import flex2.compiler.mxml.dom.RequestNode;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.AnonymousObjectGraph;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.ThreadLocalToolkit;

class HTTPServiceBuilder
extends ComponentBuilder {
    private static final String REQUEST = "request";
    private Type type;

    HTTPServiceBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document) {
        super(unit, typeTable, configuration, document, null, true, null);
        this.childNodeHandler = new HTTPServiceChildNodeHandler(typeTable);
    }

    public void analyze(HTTPServiceNode node) {
        new HTTPServiceAnalyzer(this.unit, this.configuration).analyze(node);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        this.type = this.typeTable.getType(node.getNamespace(), node.getLocalPart());
        this.component = new Model(this.document, this.type, node.beginLine);
        this.registerModel(node, this.component, true);
        this.processAttributes(node, this.type);
        this.processChildren(node, this.type);
    }

    private void addRequest(RequestNode child) {
        ServiceRequestBuilder builder = new ServiceRequestBuilder(this.unit, this.typeTable, this.configuration, this.document, REQUEST);
        child.analyze(builder);
        AnonymousObjectGraph request = builder.graph;
        this.component.setProperty(REQUEST, request);
        request.setParentIndex(REQUEST);
        request.setParent(this.component);
    }

    protected class HTTPServiceChildNodeHandler
    extends ComponentBuilder.ComponentChildNodeHandler {
        int requestCount;

        public HTTPServiceChildNodeHandler(TypeTable typeTable) {
            super(typeTable);
            this.requestCount = 0;
        }

        protected void languageNode() {
            if (this.child instanceof RequestNode && this.requestCount == 0) {
                this.requestCount = 1;
                HTTPServiceBuilder.this.addRequest((RequestNode)this.child);
            } else {
                super.languageNode();
            }
        }
    }
}

