/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flex2.compiler.common.ConfigurationException;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.common.PathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NamespacesConfiguration {
    private ConfigurationPathResolver configResolver;
    private Map manifestMappings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
    }

    public Map getManifestMappings() {
        return this.manifestMappings;
    }

    public void setManifestMappings(Map manifestMappings) {
        this.manifestMappings = manifestMappings;
    }

    public VirtualFile[] getNamespace() {
        if (this.manifestMappings != null) {
            VirtualFile[] a = new VirtualFile[this.manifestMappings.size()];
            int j = 0;
            Iterator i = this.manifestMappings.values().iterator();
            while (i.hasNext()) {
                a[j++] = (VirtualFile)i.next();
            }
            return a;
        }
        return null;
    }

    public void cfgNamespace(ConfigurationValue cfgval, String uri, String manifest) throws ConfigurationException {
        if (manifest == null) {
            throw new ConfigurationException.CannotOpen(manifest, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        PathResolver resolver = ThreadLocalToolkit.getPathResolver();
        if (!($assertionsDisabled || resolver != null && this.configResolver != null)) {
            throw new AssertionError((Object)"Path resolvers must be set before calling this method.");
        }
        if (resolver == null || this.configResolver == null) {
            throw new ConfigurationException.CannotOpen(manifest, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        VirtualFile file = ConfigurationPathResolver.getVirtualFile(manifest, this.configResolver, cfgval);
        if (this.manifestMappings == null) {
            this.manifestMappings = new HashMap();
        }
        this.manifestMappings.put(uri, file);
    }

    public static ConfigurationInfo getNamespaceInfo() {
        return new ConfigurationInfo(new String[]{"uri", "manifest"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    static {
        $assertionsDisabled = !NamespacesConfiguration.class.desiredAssertionStatus();
    }
}

