/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flash.util.Trace;
import flex2.compiler.asdoc.DocComment;
import flex2.compiler.asdoc.DocCommentTable;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

public class ClassTable
implements DocCommentTable {
    private LinkedHashMap classTable = new LinkedHashMap();
    private LinkedHashMap packageTable = new LinkedHashMap();
    private HashSet tagNames = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassTable() {
        this.tagNames.add("author");
        this.tagNames.add("category");
        this.tagNames.add("copy");
        this.tagNames.add("default");
        this.tagNames.add("deprecated");
        this.tagNames.add("event");
        this.tagNames.add("eventType");
        this.tagNames.add("example");
        this.tagNames.add("exampleText");
        this.tagNames.add("excludeInherited");
        this.tagNames.add("helpid");
        this.tagNames.add("import");
        this.tagNames.add("includeExample");
        this.tagNames.add("inheritDoc");
        this.tagNames.add("internal");
        this.tagNames.add("keyword");
        this.tagNames.add("langversion");
        this.tagNames.add("migration");
        this.tagNames.add("param");
        this.tagNames.add("playerversion");
        this.tagNames.add("private");
        this.tagNames.add("productversion");
        this.tagNames.add("return");
        this.tagNames.add("review");
        this.tagNames.add("see");
        this.tagNames.add("throws");
        this.tagNames.add("tiptext");
        this.tagNames.add("toolversion");
        this.tagNames.add("description");
    }

    public void addComments(QName name, List comments, HashSet inheritance, boolean exclude, Context cx) {
        String packageName = name.getNamespace().intern();
        String className = name.getLocalPart().intern();
        ArrayList<DocCommentNode> mainClass = new ArrayList<DocCommentNode>();
        LinkedHashMap<String, ArrayList<DocCommentNode>> otherClasses = new LinkedHashMap<String, ArrayList<DocCommentNode>>();
        LinkedHashMap otherInheritance = new LinkedHashMap();
        boolean mainDef = false;
        String otherPackage = null;
        for (int i = 0; i < comments.size(); ++i) {
            int colon;
            String debug;
            DocCommentNode current = (DocCommentNode)comments.get(i);
            String pkg = "";
            String cls = "";
            if (current.def instanceof PackageDefinitionNode) {
                mainClass.add(current);
                continue;
            }
            if (current.def instanceof ClassDefinitionNode) {
                ClassDefinitionNode cd = (ClassDefinitionNode)current.def;
                if (cd.metaData.items.at(0) != current) continue;
                debug = cd.debug_name;
                colon = debug.indexOf(58);
                if (colon < 0) {
                    pkg = "";
                    cls = debug.intern();
                } else {
                    pkg = debug.substring(0, colon).intern();
                    cls = debug.substring(colon + 1).intern();
                }
                if (cls.equals(className) && pkg.equals(packageName)) {
                    mainDef = true;
                } else {
                    if (otherPackage == null) {
                        otherPackage = pkg;
                    }
                    HashSet<QName> inherit = new HashSet<QName>();
                    otherInheritance.put(cls, inherit);
                    Namespaces inherited = cd.used_def_namespaces;
                    for (int j = 0; j < inherited.size(); ++j) {
                        QName q;
                        String s = inherited.get(j).toString().intern();
                        if (s.equals(debug) || s.equals(otherPackage) || (q = new QName(s)).getLocalPart().equals("")) continue;
                        if (!$assertionsDisabled && q.getLocalPart().equals(cls) && q.getNamespace().equals(pkg)) {
                            throw new AssertionError((Object)"same class");
                        }
                        inherit.add(q);
                    }
                }
            } else if (current.def instanceof FunctionDefinitionNode) {
                FunctionDefinitionNode fd = (FunctionDefinitionNode)current.def;
                debug = fd.fexpr.debug_name;
                colon = debug.indexOf(58);
                int slash = debug.indexOf(47);
                if (colon < 0) {
                    pkg = "";
                    cls = slash < 0 ? "" : debug.substring(0, slash).intern();
                } else {
                    pkg = debug.substring(0, colon).intern();
                    if (slash < 0) {
                        cls = "";
                    } else if (slash < colon) {
                        pkg = "";
                        cls = debug.substring(0, slash).intern();
                    } else {
                        cls = debug.substring(colon + 1, slash).intern();
                    }
                }
            } else if (current.def instanceof VariableDefinitionNode) {
                VariableBindingNode vb = (VariableBindingNode)((VariableDefinitionNode)current.def).list.items.get(0);
                debug = vb.debug_name;
                colon = debug.indexOf(58);
                int slash = debug.indexOf(47);
                if (colon < 0) {
                    pkg = "";
                    cls = slash < 0 ? "" : debug.substring(0, slash).intern();
                } else {
                    pkg = debug.substring(0, colon).intern();
                    if (slash < 0) {
                        cls = "";
                    } else if (slash < colon) {
                        pkg = "";
                        cls = debug.substring(0, slash).intern();
                    } else {
                        cls = debug.substring(colon + 1, slash).intern();
                    }
                }
            }
            if (!pkg.equals(packageName)) {
                ArrayList<DocCommentNode> l;
                if (cls.equals("")) {
                    cls = "null";
                }
                if ((l = (ArrayList<DocCommentNode>)otherClasses.get(cls)) == null) {
                    l = new ArrayList<DocCommentNode>();
                }
                l.add(current);
                otherClasses.put(cls, l);
                continue;
            }
            mainClass.add(current);
        }
        if (mainDef) {
            this.put(name, mainClass, inheritance, exclude, cx);
        } else {
            this.put(new QName(packageName, "null"), mainClass, inheritance, exclude, cx);
        }
        if (otherPackage != null) {
            Iterator iter = otherClasses.keySet().iterator();
            while (iter.hasNext()) {
                String cls = ((String)iter.next()).intern();
                this.put(new QName(otherPackage, cls), (List)otherClasses.get(cls), (HashSet)otherInheritance.get(cls), true, cx);
            }
        }
        if (!this.packageTable.containsKey(packageName)) {
            this.packageTable.put(packageName, null);
        }
        if (otherPackage != null && !this.packageTable.containsKey(otherPackage)) {
            this.packageTable.put(otherPackage, null);
        }
    }

    private void put(QName name, List comments, HashSet inheritance, boolean exclude, Context cx) {
        CommentsTable table = new CommentsTable(name.getNamespace(), name.getLocalPart(), inheritance, exclude, cx);
        int temp = comments.size();
        for (int i = 0; i < temp; ++i) {
            DocCommentNode tempNode = (DocCommentNode)comments.get(i);
            DocComment tempComment = table.addComment(tempNode);
            if (this.packageTable.get(name.getNamespace()) != null || tempComment == null || tempComment.getType() != 0) continue;
            this.packageTable.put(name.getNamespace(), tempComment);
        }
        this.classTable.put(NameFormatter.toDot(name), table);
    }

    public List getAllClassComments(String className, String packageName) {
        try {
            if (packageName == null) {
                packageName = "";
            }
            if (className == null || className.equals("")) {
                className = "null";
            }
            String name = NameFormatter.toDot(new QName(packageName, className));
            CommentsTable temp = (CommentsTable)this.classTable.get(name);
            return new ArrayList(temp.values());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public List getAllComments() {
        ArrayList comments = new ArrayList();
        Iterator iter = this.classTable.keySet().iterator();
        while (iter.hasNext()) {
            CommentsTable temp1 = (CommentsTable)this.classTable.get(iter.next());
            comments.addAll(temp1.values());
        }
        return comments;
    }

    public Map getClasses(String packageName) {
        return this.getCsOrIs(packageName, true, false);
    }

    public Map getClassesAndInterfaces(String packageName) {
        return this.getCsOrIs(packageName, true, true);
    }

    private Map getCsOrIs(String packageName, boolean c, boolean i) {
        if (packageName == null) {
            packageName = "";
        }
        LinkedHashMap comments = new LinkedHashMap();
        Iterator iter = this.classTable.keySet().iterator();
        while (iter.hasNext()) {
            CommentsTable temp1;
            String key = (String)iter.next();
            int dot = key.lastIndexOf(".");
            if (dot < 0 && packageName.equals("") && !key.equals("null")) {
                temp1 = (CommentsTable)this.classTable.get(key);
                if (!temp1.isInterface() && c) {
                    comments.put(key, temp1.get(new KeyPair(key, 1)));
                    continue;
                }
                if (!i) continue;
                comments.put(key, temp1.get(new KeyPair(key, 2)));
                continue;
            }
            if (dot < 0 || !key.substring(0, dot).equals(packageName)) continue;
            temp1 = (CommentsTable)this.classTable.get(key);
            String key2 = key.substring(dot + 1);
            if (!temp1.isInterface() && c) {
                comments.put(key2, temp1.get(new KeyPair(key, 1)));
                continue;
            }
            if (!i) continue;
            comments.put(key2, temp1.get(new KeyPair(key, 2)));
        }
        return comments;
    }

    public Map getFields(String className, String packageName) {
        return this.getMany(className, packageName, 6);
    }

    public DocComment getComment(String name, String className, String packageName, int type) {
        try {
            if (packageName == null) {
                packageName = "";
            }
            if (className == null || className.equals("")) {
                className = "null";
            }
            if (type == 0) {
                return (DocComment)this.packageTable.get(packageName);
            }
            CommentsTable temp = (CommentsTable)this.classTable.get(NameFormatter.toDot(new QName(packageName, className)));
            if (type == 1 || type == 2) {
                return (DocComment)temp.get(new KeyPair(className, type));
            }
            if (type <= 6 && type >= 3) {
                return (DocComment)temp.get(new KeyPair(name, type));
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public Map getFunctions(String className, String packageName) {
        return this.getMany(className, packageName, 3);
    }

    public Map getGetMethods(String className, String packageName) {
        return this.getMany(className, packageName, 4);
    }

    public Map getSetMethods(String className, String packageName) {
        return this.getMany(className, packageName, 4);
    }

    private Map getMany(String className, String packageName, int type) {
        if (packageName == null) {
            packageName = "";
        }
        if (className == null || className.equals("")) {
            className = "null";
        }
        LinkedHashMap comments = new LinkedHashMap();
        CommentsTable temp = (CommentsTable)this.classTable.get(NameFormatter.toDot(new QName(packageName, className)));
        if (temp == null) {
            return null;
        }
        Iterator iter = temp.keySet().iterator();
        while (iter.hasNext()) {
            KeyPair key = (KeyPair)iter.next();
            if (key.type != type) continue;
            comments.put(key.name, temp.get(key));
        }
        return comments;
    }

    public Map getInterfaces(String packageName) {
        return this.getCsOrIs(packageName, false, true);
    }

    public Map getPackages() {
        return new LinkedHashMap(this.packageTable);
    }

    static {
        $assertionsDisabled = !ClassTable.class.desiredAssertionStatus();
    }

    private class KeyPair
    implements Comparable {
        public String name;
        public int type;

        public KeyPair(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public int compareTo(Object key) {
            return (new Integer(this.type).toString() + this.name).compareTo(new Integer(((KeyPair)key).type).toString() + ((KeyPair)key).name);
        }
    }

    private class CommentsTable
    extends TreeMap {
        private boolean exclude;
        private HashSet inheritance;
        private Context cx;
        private String ownerClass;
        private String ownerPackage;
        private boolean isInterface;

        public CommentsTable(String packageName, String className, HashSet inheritance, boolean exclude, Context cx) {
            this.ownerPackage = packageName;
            this.ownerClass = className;
            this.exclude = exclude;
            this.inheritance = inheritance;
            this.cx = cx;
        }

        public DocComment addComment(DocCommentNode comment) {
            CommentEntry entry = new CommentEntry(comment, this.exclude);
            if (entry.key.type == 2) {
                this.isInterface = true;
            }
            if (!this.containsKey(entry.key)) {
                this.put(entry.key, entry);
                return entry;
            }
            return null;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        private Object[] findInheritDoc(KeyPair key) {
            Object[] inheritDoc = null;
            Iterator iter = this.inheritance.iterator();
            while (iter.hasNext()) {
                QName nextClass = (QName)iter.next();
                CommentsTable t = (CommentsTable)ClassTable.this.classTable.get(NameFormatter.toDot(nextClass));
                if (t != null) {
                    inheritDoc = key.type == 1 ? t.getCommentForInherit(new KeyPair(nextClass.getLocalPart(), 1)) : t.getCommentForInherit(key);
                }
                if (inheritDoc == null) continue;
                break;
            }
            return inheritDoc;
        }

        public Object[] getCommentForInherit(KeyPair key) {
            CommentEntry temp = (CommentEntry)this.get(key);
            if (temp != null) {
                return temp.getInheritedDoc();
            }
            return this.findInheritDoc(key);
        }

        private class CommentEntry
        implements DocComment {
            private boolean exclude;
            public KeyPair key;
            private String fullname;
            private String description;
            private boolean isFinal;
            private boolean isStatic;
            private boolean isOverride;
            private String sourcefile;
            private String namespace;
            private String access;
            private boolean isDynamic;
            private String baseClass;
            private String[] interfaces;
            private String[] baseClasses;
            private String[] paramNames;
            private String[] paramTypes;
            private String[] paramDefaults;
            private String resultType;
            private String vartype;
            private boolean isConst;
            private String defaultValue;
            private List metadata;
            private String metadataType;
            private String owner;
            private String type_meta;
            private String event_meta;
            private String kind_meta;
            private String arrayType_meta;
            private String format_meta;
            private String inherit_meta;
            private String enumeration_meta;
            private List authorTags;
            private String categoryTag;
            private String copyTag;
            private String defaultTag;
            private boolean hasDeprecatedTag;
            private String eventTag;
            private String eventTypeTag;
            private List exampleTags;
            private List exampleTextTags;
            private String excludeInheritedTag;
            private String helpidTag;
            private List importTags;
            private List includeExampleTags;
            private boolean hasInheritTag;
            private String internalTag;
            private String keywordTag;
            private String langversionTag;
            private String migrationTag;
            private List paramTags;
            private String playerversionTag;
            private boolean hasPrivateTag;
            private String productversionTag;
            private String returnTag;
            private boolean hasReviewTag;
            private List seeTags;
            private List throwsTags;
            private String tiptextTag;
            private String toolversionTag;
            private Map customTags;

            public CommentEntry(DocCommentNode comment, boolean exclude) {
                this.exclude = exclude;
                this.processComment(comment);
            }

            public CommentEntry(String debugName, MetaDataNode meta, boolean isAttributeOfDefinition, MetaDataNode current) {
                this.createMetadataEntry(debugName, meta, isAttributeOfDefinition, current);
            }

            private void createMetadataEntry(String debugName, MetaDataNode meta, boolean isAttributeOfDefinition, MetaDataNode current) {
                this.key = new KeyPair("IGNORE", 7);
                this.metadataType = meta.id;
                this.owner = debugName;
                boolean has_name = false;
                if (meta.values != null) {
                    int l = meta.values.length;
                    for (int i = 0; i < l; ++i) {
                        Value v = meta.values[i];
                        if (v == null) continue;
                        if (v instanceof MetaDataEvaluator.KeylessValue && !has_name) {
                            MetaDataEvaluator.KeylessValue ov = (MetaDataEvaluator.KeylessValue)v;
                            this.key.name = ov.obj;
                            has_name = true;
                            continue;
                        }
                        if (!(v instanceof MetaDataEvaluator.KeyValuePair)) continue;
                        MetaDataEvaluator.KeyValuePair kv = (MetaDataEvaluator.KeyValuePair)v;
                        String s = kv.key.intern();
                        if (s.equals("name")) {
                            this.key.name = kv.obj;
                            continue;
                        }
                        if (s.equals("type")) {
                            this.type_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("event")) {
                            this.event_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("kind")) {
                            this.kind_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("arrayType")) {
                            this.arrayType_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("format")) {
                            this.format_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("inherit")) {
                            this.inherit_meta = kv.obj;
                            continue;
                        }
                        if (!s.equals("enumeration")) continue;
                        this.enumeration_meta = kv.obj;
                    }
                } else if (meta.id != null) {
                    this.key.name = meta.id;
                }
                if (!isAttributeOfDefinition && current.id != null) {
                    this.processTags(current.id);
                }
            }

            private String getAccessKindFromNS(ObjectValue ns) {
                String access_specifier;
                switch (ns.getNamespaceKind()) {
                    case 0: {
                        access_specifier = "public";
                        break;
                    }
                    case 1: {
                        access_specifier = "internal";
                        break;
                    }
                    case 3: {
                        access_specifier = "protected";
                        break;
                    }
                    case 2: {
                        access_specifier = "private";
                        break;
                    }
                    default: {
                        access_specifier = "public";
                    }
                }
                return access_specifier;
            }

            private void processPackage(PackageDefinitionNode pd) {
                this.key.type = 0;
                this.key.name = pd.name.id != null ? pd.name.id.pkg_part : "";
                this.fullname = pd.name.id != null ? pd.name.id.pkg_part + "." + pd.name.id.def_part : "";
            }

            private void processClassAndInterface(ClassDefinitionNode cd) {
                ObjectList values;
                this.key.name = cd.name.name;
                this.fullname = cd.debug_name;
                InterfaceDefinitionNode idn = null;
                if (cd instanceof InterfaceDefinitionNode) {
                    this.key.type = 2;
                    idn = (InterfaceDefinitionNode)cd;
                } else {
                    this.key.type = 1;
                }
                if (cd.cx.input != null && cd.cx.input.origin.length() != 0) {
                    this.sourcefile = cd.cx.input.origin;
                }
                this.namespace = cd.cframe.builder.classname.ns.name;
                this.access = this.getAccessKindFromNS(cd.cframe.builder.classname.ns);
                if (idn != null) {
                    if (idn.interfaces != null) {
                        values = idn.interfaces.values;
                        this.baseClasses = new String[values.size()];
                        for (int i = 0; i < values.size(); ++i) {
                            ReferenceValue rv = (ReferenceValue)values.get(i);
                            Slot s = rv.getSlot(CommentsTable.this.cx, -78);
                            this.baseClasses[i] = s == null || s.getDebugName().length() == 0 ? rv.name : s.getDebugName();
                        }
                    } else {
                        this.baseClasses = new String[]{"Object"};
                    }
                } else {
                    Slot s;
                    this.baseClass = cd.baseref != null ? ((s = cd.baseref.getSlot(CommentsTable.this.cx, -78)) == null || s.getDebugName().length() == 0 ? "Object" : s.getDebugName()) : "Object";
                    if (cd.interfaces != null) {
                        values = cd.interfaces.values;
                        this.interfaces = new String[values.size()];
                        for (int i = 0; i < values.size(); ++i) {
                            ReferenceValue rv = (ReferenceValue)values.get(i);
                            Slot s2 = rv.getSlot(CommentsTable.this.cx, -78);
                            this.interfaces[i] = s2 == null || s2.getDebugName().length() == 0 ? rv.name : s2.getDebugName();
                        }
                    }
                }
                AttributeListNode attrs = cd.attrs;
                if (attrs != null) {
                    this.isFinal = attrs.hasFinal;
                    this.isDynamic = attrs.hasDynamic;
                }
            }

            private void processFunction(FunctionDefinitionNode fd) {
                ParameterListNode pln;
                this.key.type = 3;
                int check1 = fd.fexpr.debug_name.indexOf("/get");
                int check2 = fd.fexpr.debug_name.indexOf("/set");
                if (check1 == fd.fexpr.debug_name.length() - 4) {
                    this.key.type = 4;
                } else if (check2 == fd.fexpr.debug_name.length() - 4) {
                    this.key.type = 5;
                }
                this.key.name = fd.name.identifier.name;
                this.fullname = fd.fexpr.debug_name;
                AttributeListNode attrs = fd.attrs;
                if (attrs != null) {
                    this.isStatic = attrs.hasStatic;
                    this.isFinal = attrs.hasFinal;
                    this.isOverride = attrs.hasOverride;
                }
                if ((pln = fd.fexpr.signature.parameter) != null) {
                    int size = pln.items.size();
                    this.paramNames = new String[size];
                    this.paramTypes = new String[size];
                    this.paramDefaults = new String[size];
                    for (int i = 0; i < size; ++i) {
                        ParameterNode pn = (ParameterNode)pln.items.get(i);
                        String string = this.paramNames[i] = pn.ref != null ? pn.ref.name : "";
                        if (pn instanceof RestParameterNode) {
                            this.paramTypes[i] = "restParam";
                        } else if (pn.typeref != null) {
                            Slot s = pn.typeref.getSlot(CommentsTable.this.cx, -78);
                            String string2 = this.paramTypes[i] = s == null || s.getDebugName().length() == 0 ? pn.typeref.name : s.getDebugName();
                        }
                        this.paramDefaults[i] = pn.init == null ? "undefined" : (pn.init instanceof LiteralNumberNode ? ((LiteralNumberNode)pn.init).value : (pn.init instanceof LiteralStringNode ? DocCommentNode.escapeXml((String)((LiteralStringNode)pn.init).value) : (pn.init instanceof LiteralNullNode ? "null" : (pn.init instanceof LiteralBooleanNode ? (((LiteralBooleanNode)pn.init).value ? "true" : "false") : "unknown"))));
                    }
                }
                if (fd.fexpr.signature.result != null) {
                    TypeExpressionNode result = (TypeExpressionNode)fd.fexpr.signature.result;
                    if (result.expr != null) {
                        MemberExpressionNode expr = (MemberExpressionNode)result.expr;
                        Slot s = expr.ref.getSlot(CommentsTable.this.cx, -78);
                        this.resultType = s == null || s.getDebugName().length() == 0 ? expr.ref.name : s.getDebugName();
                    }
                } else {
                    this.resultType = fd.fexpr.signature.void_anno ? "void" : ((CommentsTable)CommentsTable.this).cx.noType().name.toString();
                }
            }

            private void processField(VariableDefinitionNode vd) {
                Slot s;
                AttributeListNode attrs;
                VariableBindingNode vb = (VariableBindingNode)vd.list.items.get(0);
                this.key.type = 6;
                this.key.name = vb.variable.identifier.name;
                this.fullname = vb.debug_name;
                if (vb.typeref != null) {
                    Slot s2 = vb.typeref.getSlot(CommentsTable.this.cx, -78);
                    String string = this.vartype = s2 == null || s2.getDebugName().length() == 0 ? vb.typeref.name : s2.getDebugName();
                }
                if ((attrs = vd.attrs) != null) {
                    this.isStatic = attrs.hasStatic;
                }
                if ((s = vb.ref.getSlot(CommentsTable.this.cx)) != null) {
                    this.isConst = s.isConst();
                }
                if (vb.initializer != null) {
                    if (vb.initializer instanceof LiteralNumberNode) {
                        this.defaultValue = ((LiteralNumberNode)vb.initializer).value;
                    } else if (vb.initializer instanceof LiteralStringNode) {
                        this.defaultValue = DocCommentNode.escapeXml((String)((LiteralStringNode)vb.initializer).value);
                    } else if (vb.initializer instanceof LiteralNullNode) {
                        this.defaultValue = "null";
                    } else if (vb.initializer instanceof LiteralBooleanNode) {
                        this.defaultValue = ((LiteralBooleanNode)vb.initializer).value ? "true" : "false";
                    } else if (vb.initializer instanceof MemberExpressionNode) {
                        MemberExpressionNode mb = (MemberExpressionNode)vb.initializer;
                        Slot vs = mb.ref != null ? mb.ref.getSlot(CommentsTable.this.cx, -78) : null;
                        Value v = vs != null ? vs.getValue() : null;
                        ObjectValue ov = v instanceof ObjectValue ? (ObjectValue)v : null;
                        this.defaultValue = ov != null ? ov.getValue() : "unknown";
                    } else {
                        Slot vs = vb.ref.getSlot(CommentsTable.this.cx, -78);
                        Value v = vs != null ? vs.getValue() : null;
                        ObjectValue ov = v instanceof ObjectValue ? (ObjectValue)v : null;
                        this.defaultValue = ov != null ? ov.getValue() : "unknown";
                    }
                }
            }

            private void createMetaDataComment(String debugName, MetaDataNode meta, boolean isAttributeOfDefinition, MetaDataNode current) {
                if (this.metadata == null) {
                    this.metadata = new ArrayList();
                }
                CommentEntry newMetadata = new CommentEntry(debugName, meta, isAttributeOfDefinition, current);
                this.metadata.add(newMetadata);
            }

            private void processMetadata(DocCommentNode comment) {
                if (comment.def != null && comment.def.metaData != null) {
                    int numItems = comment.def.metaData.items.size();
                    for (int x = 0; x < numItems; ++x) {
                        MetaDataNode mdi;
                        Node md = (Node)comment.def.metaData.items.at(x);
                        MetaDataNode metaDataNode = mdi = md instanceof MetaDataNode ? (MetaDataNode)md : null;
                        if (mdi == null || mdi.id == null) continue;
                        if (mdi.id.equals("Style") || mdi.id.equals("Event") || mdi.id.equals("Effect")) {
                            if (x + 1 < numItems) {
                                DocCommentNode metaDataComment;
                                Node next = (Node)comment.def.metaData.items.at(x + 1);
                                DocCommentNode docCommentNode = metaDataComment = next instanceof DocCommentNode ? (DocCommentNode)next : null;
                                if (metaDataComment != null) {
                                    this.createMetaDataComment(this.fullname, mdi, false, (MetaDataNode)metaDataComment);
                                    ++x;
                                    continue;
                                }
                                this.createMetaDataComment(this.fullname, mdi, true, null);
                                continue;
                            }
                            this.createMetaDataComment(this.fullname, mdi, true, null);
                            continue;
                        }
                        if (!mdi.id.equals("Bindable") && !mdi.id.equals("Deprecated") && !mdi.id.equals("Exclude") && !mdi.id.equals("DefaultProperty")) continue;
                        this.createMetaDataComment(this.fullname, mdi, true, null);
                    }
                }
            }

            private boolean matchesAnyTag(String tagName) {
                return ClassTable.this.tagNames.contains(tagName);
            }

            private void processTags(String id) {
                int begin;
                int endCDATABefore;
                int is = id.indexOf("<description><![CDATA[");
                int ie = id.indexOf("]]></description>");
                this.description = id.substring(is + "<description><![CDATA[".length(), ie);
                int index = id.indexOf("]]></return>");
                if (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<return><![CDATA[", endCDATABefore) + "<return><![CDATA[".length();
                    this.returnTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></return>", index + 12)) > 0) {
                    ThreadLocalToolkit.getLogger().logError("More than one @return found in " + this.fullname + ".");
                }
                if ((index = id.indexOf("]]></param>")) >= 0) {
                    this.paramTags = new ArrayList();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<param><![CDATA[", endCDATABefore);
                    this.paramTags.add(id.substring(begin + "<param><![CDATA[".length(), index));
                    index = id.indexOf("]]></param>", index + "]]></param>".length());
                }
                index = id.indexOf("]]></inheritDoc>");
                this.hasInheritTag = index > 0;
                if ((index = id.indexOf("]]></inheritDoc>", index + 16)) > 0) {
                    ThreadLocalToolkit.getLogger().logError("More than one @inheritDoc found in " + this.fullname + ".");
                }
                if ((index = id.indexOf("]]></author>")) >= 0) {
                    this.authorTags = new ArrayList();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<author><![CDATA[", endCDATABefore);
                    this.authorTags.add(id.substring(begin + "<author><![CDATA[".length(), index));
                    index = id.indexOf("]]></author>", index + "]]></author>".length());
                }
                index = id.indexOf("]]></category>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<category><![CDATA[", endCDATABefore) + "<category><![CDATA[".length();
                    this.categoryTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></copy>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<copy><![CDATA[", endCDATABefore) + "<copy><![CDATA[".length();
                    this.copyTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></default>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<default><![CDATA[", endCDATABefore) + "<default><![CDATA[".length();
                    this.defaultTag = id.substring(begin, index);
                }
                this.hasDeprecatedTag = id.indexOf("]]></deprecated>") > 0;
                index = id.indexOf("]]></event>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<event><![CDATA[", endCDATABefore) + "<event><![CDATA[".length();
                    this.eventTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></eventType>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<eventType><![CDATA[", endCDATABefore) + "<eventType><![CDATA[".length();
                    this.eventTypeTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></example>")) >= 0) {
                    this.exampleTags = new ArrayList();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<example><![CDATA[", endCDATABefore);
                    this.exampleTags.add(id.substring(begin + "<example><![CDATA[".length(), index));
                    index = id.indexOf("]]></example>", index + "]]></example>".length());
                }
                index = id.indexOf("]]></exampleText>");
                if (index >= 0) {
                    this.exampleTextTags = new ArrayList();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<exampleText><![CDATA[", endCDATABefore);
                    this.exampleTextTags.add(id.substring(begin + "<exampleText><![CDATA[".length(), index));
                    index = id.indexOf("]]></exampleText>", index + "]]></exampleText>".length());
                }
                index = id.indexOf("]]></excludeInherited>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<excludeInherited><![CDATA[", endCDATABefore) + "<excludeInherited><![CDATA[".length();
                    this.excludeInheritedTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></helpid>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<helpid><![CDATA[", endCDATABefore) + "<helpid><![CDATA[".length();
                    this.helpidTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></import>")) >= 0) {
                    this.importTags = new ArrayList();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<import><![CDATA[", endCDATABefore);
                    this.importTags.add(id.substring(begin + "<import><![CDATA[".length(), index));
                    index = id.indexOf("]]></import>", index + "]]></import>".length());
                }
                index = id.indexOf("]]></includeExample>");
                if (index >= 0) {
                    this.includeExampleTags = new ArrayList();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<includeExample><![CDATA[", endCDATABefore);
                    this.includeExampleTags.add(id.substring(begin + "<includeExample><![CDATA[".length(), index));
                    index = id.indexOf("]]></includeExample>", index + "]]></includeExample>".length());
                }
                index = id.indexOf("]]></internal>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<internal><![CDATA[", endCDATABefore) + "<internal><![CDATA[".length();
                    this.internalTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></keyword>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<keyword><![CDATA[", endCDATABefore) + "<keyword><![CDATA[".length();
                    this.keywordTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></langversion>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<langversion><![CDATA[", endCDATABefore) + "<langversion><![CDATA[".length();
                    this.langversionTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></migration>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<migration><![CDATA[", endCDATABefore) + "<migration><![CDATA[".length();
                    this.migrationTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></playerversion>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<playerversion><![CDATA[", endCDATABefore) + "<playerversion><![CDATA[".length();
                    this.playerversionTag = id.substring(begin, index);
                }
                this.hasPrivateTag = id.indexOf("]]></private>") > 0;
                index = id.indexOf("]]></productversion>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<productversion><![CDATA[", endCDATABefore) + "<productversion><![CDATA[".length();
                    this.productversionTag = id.substring(begin, index);
                }
                this.hasReviewTag = id.indexOf("]]></review>") > 0;
                index = id.indexOf("]]></see>");
                if (index >= 0) {
                    this.seeTags = new ArrayList();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<see><![CDATA[", endCDATABefore);
                    String see = id.substring(begin + "<see><![CDATA[".length(), index);
                    if (see.indexOf(60) >= 0) {
                        ThreadLocalToolkit.getLogger().logError("Do not use html in @see. Offending text: " + see + " Located at " + this.fullname + ".");
                    }
                    this.seeTags.add(see);
                    index = id.indexOf("]]></see>", index + "]]></see>".length());
                }
                index = id.indexOf("]]></throws>");
                if (index >= 0) {
                    this.throwsTags = new ArrayList();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<throws><![CDATA[", endCDATABefore);
                    this.throwsTags.add(id.substring(begin + "<throws><![CDATA[".length(), index));
                    index = id.indexOf("]]></throws>", index + "]]></throws>".length());
                }
                index = id.indexOf("]]></tiptext>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<tiptext><![CDATA[", endCDATABefore) + "<tiptext><![CDATA[".length();
                    this.tiptextTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></toolversion>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<toolversion><![CDATA[", endCDATABefore) + "<toolversion><![CDATA[".length();
                    this.toolversionTag = id.substring(begin, index);
                }
                index = id.indexOf("]]></");
                while (index >= 0) {
                    int endTag;
                    int beginTag = index + "]]></".length();
                    String tagName = id.substring(beginTag, endTag = id.indexOf(">", beginTag)).intern();
                    if (!this.matchesAnyTag(tagName)) {
                        if (this.customTags == null) {
                            this.customTags = new LinkedHashMap();
                        }
                        endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                        String tag = "<" + tagName + "><![CDATA[";
                        begin = id.indexOf(tag, endCDATABefore) + tag.length();
                        this.customTags.put(tagName, id.substring(begin, index));
                    }
                    index = id.indexOf("]]></", endTag + 1);
                }
            }

            private void processComment(DocCommentNode comment) {
                this.key = new KeyPair("IGNORE", -1);
                if (comment.def instanceof PackageDefinitionNode) {
                    this.processPackage((PackageDefinitionNode)comment.def);
                } else if (comment.def instanceof ClassDefinitionNode) {
                    ClassDefinitionNode cd = (ClassDefinitionNode)comment.def;
                    if (cd.metaData.items.at(0) == comment) {
                        this.processClassAndInterface(cd);
                    }
                } else if (comment.def instanceof FunctionDefinitionNode) {
                    this.processFunction((FunctionDefinitionNode)comment.def);
                } else if (comment.def instanceof VariableDefinitionNode) {
                    this.processField((VariableDefinitionNode)comment.def);
                } else {
                    this.key.name = "Unsupported";
                }
                if (this.key.type == -1) {
                    return;
                }
                if (comment.id != null) {
                    this.processTags(comment.id);
                }
                if (!this.exclude && this.hasInheritTag) {
                    this.processInheritDoc();
                }
                this.processMetadata(comment);
            }

            private void addToComment(Object[] inheritDoc) {
                String desc = (String)inheritDoc[0];
                List para = (List)inheritDoc[1];
                String retu = (String)inheritDoc[2];
                if (desc != null) {
                    this.description = this.description + desc;
                }
                if (para != null) {
                    if (this.paramTags != null) {
                        int diff = para.size() - this.paramTags.size();
                        if (diff > 0) {
                            int size;
                            for (int i = size = this.paramTags.size(); i < size + diff; ++i) {
                                this.paramTags.add(para.get(i));
                            }
                        }
                    } else {
                        this.paramTags = para;
                    }
                }
                if (this.returnTag == null && retu != null) {
                    this.returnTag = retu;
                }
            }

            public Object[] getInheritedDoc() {
                Object[] inheritDoc;
                if (this.hasInheritTag && this.exclude && (inheritDoc = CommentsTable.this.findInheritDoc(this.key)) != null) {
                    this.addToComment(inheritDoc);
                }
                inheritDoc = new Object[]{this.getDescription(), this.getParamTags(), this.getReturnTag()};
                return inheritDoc;
            }

            private void processInheritDoc() {
                Object[] inheritDoc = CommentsTable.this.findInheritDoc(this.key);
                if (inheritDoc != null) {
                    this.addToComment(inheritDoc);
                } else if (Trace.asdoc) {
                    System.out.println("Cannot find inherited documentation for: " + this.key.name);
                }
            }

            public Map getAllTags() {
                LinkedHashMap<String, Object> tags = new LinkedHashMap<String, Object>();
                tags.put("author", this.getAuthorTags());
                tags.put("category", this.getCategoryTag());
                tags.put("copy", this.getCopyTag());
                tags.put("default", this.getDefaultTag());
                tags.put("event", this.getEventTag());
                tags.put("eventType", this.getEventTypeTag());
                tags.put("example", this.getExampleTags());
                tags.put("exampleText", this.getExampleTextTags());
                tags.put("excludeInherited", this.getExcludeInheritedTag());
                tags.put("helpid", this.getHelpidTag());
                tags.put("import", this.getImportTags());
                tags.put("includeExample", this.getIncludeExampleTags());
                tags.put("internal", this.getInternalTag());
                tags.put("keyword", this.getKeywordTag());
                tags.put("langversion", this.getLangversionTag());
                tags.put("migration", this.getMigrationTag());
                tags.put("param", this.getParamTags());
                tags.put("playerversion", this.getPlayerversionTag());
                tags.put("productversion", this.getProductversionTag());
                tags.put("return", this.getReturnTag());
                tags.put("see", this.getSeeTags());
                tags.put("throws", this.getThrowsTags());
                tags.put("tiptext", this.getTiptextTag());
                tags.put("toolversion", this.getToolversionTag());
                tags.put("deprecated", this.hasDeprecatedTag());
                tags.put("inheritDoc", this.hasInheritTag());
                tags.put("private", this.hasPrivateTag());
                tags.put("review", this.hasReviewTag());
                tags.put("custom", this.getCustomTags());
                return tags;
            }

            public int getType() {
                return this.key.type;
            }

            public String getDescription() {
                return this.description;
            }

            public List getParamTags() {
                return this.paramTags;
            }

            public String getReturnTag() {
                return this.returnTag;
            }

            public String getAccess() {
                return this.access;
            }

            public String getArrayType_meta() {
                return this.arrayType_meta;
            }

            public List getAuthorTags() {
                return this.authorTags;
            }

            public String getBaseClass() {
                return this.baseClass;
            }

            public String[] getBaseclasses() {
                return this.baseClasses;
            }

            public String getCategoryTag() {
                return this.categoryTag;
            }

            public String getCopyTag() {
                return this.copyTag;
            }

            public Map getCustomTags() {
                return this.customTags;
            }

            public String getDefaultTag() {
                return this.defaultTag;
            }

            public String getDefaultValue() {
                return this.defaultValue;
            }

            public String getEnumeration_meta() {
                return this.enumeration_meta;
            }

            public String getEvent_meta() {
                return this.event_meta;
            }

            public String getEventTag() {
                return this.eventTag;
            }

            public String getEventTypeTag() {
                return this.eventTypeTag;
            }

            public List getExampleTags() {
                return this.exampleTags;
            }

            public List getExampleTextTags() {
                return this.exampleTextTags;
            }

            public String getExcludeInheritedTag() {
                return this.excludeInheritedTag;
            }

            public String getFormat_meta() {
                return this.format_meta;
            }

            public String getInherit_meta() {
                return this.inherit_meta;
            }

            public String getHelpidTag() {
                return this.helpidTag;
            }

            public List getImportTags() {
                return this.importTags;
            }

            public List getIncludeExampleTags() {
                return this.includeExampleTags;
            }

            public String[] getInterfaces() {
                return this.interfaces;
            }

            public String getInternalTag() {
                return this.internalTag;
            }

            public String getKeywordTag() {
                return this.keywordTag;
            }

            public String getKind_meta() {
                return this.kind_meta;
            }

            public String getLangversionTag() {
                return this.langversionTag;
            }

            public List getMetadata() {
                return this.metadata;
            }

            public String getMetadataType() {
                return this.metadataType;
            }

            public String getMigrationTag() {
                return this.migrationTag;
            }

            public String getName() {
                return this.key.name;
            }

            public String getFullname() {
                return this.fullname;
            }

            public String getNamespace() {
                return this.namespace;
            }

            public String getOwner() {
                return this.owner;
            }

            public String getOwnerClass() {
                return CommentsTable.this.ownerClass;
            }

            public String getOwnerPackage() {
                return CommentsTable.this.ownerPackage;
            }

            public String[] getParamDefaults() {
                return this.paramDefaults;
            }

            public String[] getParamNames() {
                return this.paramNames;
            }

            public String[] getParamTypes() {
                return this.paramTypes;
            }

            public String getPlayerversionTag() {
                return this.playerversionTag;
            }

            public String getProductversionTag() {
                return this.productversionTag;
            }

            public String getResultType() {
                return this.resultType;
            }

            public List getSeeTags() {
                return this.seeTags;
            }

            public String getSourceFile() {
                return this.sourcefile;
            }

            public List getThrowsTags() {
                return this.throwsTags;
            }

            public String getTiptextTag() {
                return this.tiptextTag;
            }

            public String getToolversionTag() {
                return this.toolversionTag;
            }

            public String getType_meta() {
                return this.type_meta;
            }

            public String getVartype() {
                return this.vartype;
            }

            public boolean hasDeprecatedTag() {
                return this.hasDeprecatedTag;
            }

            public boolean hasInheritTag() {
                return this.hasInheritTag;
            }

            public boolean hasPrivateTag() {
                return this.hasPrivateTag;
            }

            public boolean hasReviewTag() {
                return this.hasReviewTag;
            }

            public boolean isConst() {
                return this.isConst;
            }

            public boolean isDynamic() {
                return this.isDynamic;
            }

            public boolean isExcluded() {
                return this.exclude;
            }

            public boolean isFinal() {
                return this.isFinal;
            }

            public boolean isOverride() {
                return this.isOverride;
            }

            public boolean isStatic() {
                return this.isStatic;
            }
        }
    }
}

