/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class Microba {
    private static UIChangeListener changeListener = new UIChangeListener();

    public static synchronized void init() {
        Microba.setLookAndFeelProperties(UIManager.getLookAndFeel());
        UIManager.removePropertyChangeListener(changeListener);
        UIManager.addPropertyChangeListener(changeListener);
    }

    private static synchronized void setLookAndFeelProperties(LookAndFeel lookAndFeel) {
        if (lookAndFeel == null) {
            return;
        }
        String packagePrefix = "com.michaelbaranov.microba.";
        UIManager.put("microba.CalendarPaneUI", packagePrefix + "calendar.ui.basic.BasicCalendarPaneUI");
        UIManager.put("microba.DatePickerUI", packagePrefix + "calendar.ui.basic.BasicDatePickerUI");
        UIManager.put("microba.GradientUI", packagePrefix + "gradient.ui.basic.BasicGradientUI");
        UIManager.put("microba.GradientEditorUI", packagePrefix + "gradienteditor.ui.basic.BasicGradientEditorUI");
        UIManager.put("microba.MarkerBarUI", packagePrefix + "marker.ui.basic.BasicMarkerBarUI");
        if (lookAndFeel.getID().equals("Windows")) {
            UIManager.put("microba.MarkerBarUI", packagePrefix + "marker.ui.windows.WindowsMarkerBarUI");
        } else if (lookAndFeel.getID().equals("Metal")) {
            UIManager.put("microba.MarkerBarUI", packagePrefix + "marker.ui.metal.MetalMarkerBarUI");
        } else if (lookAndFeel.getID().equals("Motif")) {
            UIManager.put("microba.MarkerBarUI", packagePrefix + "marker.ui.motif.MotifMarkerBarUI");
        }
    }

    private static final class UIChangeListener
    implements PropertyChangeListener {
        private UIChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("lookAndFeel".equals(event.getPropertyName())) {
                Microba.setLookAndFeelProperties((LookAndFeel)event.getNewValue());
            }
        }
    }
}

