/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.ResourceURL;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.BarcodeFactory;
import net.sourceforge.barbecue.BarcodeImageHandler;
import net.sourceforge.barbecue.output.OutputException;

public class BarcodePortlet
extends GenericPortlet
implements ResourceServingPortlet {
    private static final String PARAM_BARCODE_DATA = "barcode_data";
    private static final String SESSION_KEY = "barcode_data";

    protected String getTitle(RenderRequest renderRequest) {
        return "Barcode portlet";
    }

    protected void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        renderResponse.setContentType("text/html");
        PrintWriter printWriter = renderResponse.getWriter();
        PortletURL portletURL = renderResponse.createActionURL();
        printWriter.println("<form method=\"POST\" action=\"" + portletURL + "\">");
        printWriter.println("Enter string: <input name=\"barcode_data\" type=text size=30></input>");
        printWriter.println("<input type=submit value=\"Submit\"></input>");
        printWriter.println("</form>");
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        renderResponse.setContentType("text/html");
        PrintWriter printWriter = renderResponse.getWriter();
        ResourceURL resourceURL = renderResponse.createResourceURL();
        printWriter.println("<img src=\"" + resourceURL + "\" />");
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        renderResponse.setContentType("text/html");
        PrintWriter printWriter = renderResponse.getWriter();
        printWriter.println("<a target=\"_blank\" href=\"http://en.wikipedia.org/wiki/Barcode\">What is a barcode?</a>");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        BarcodePortlet.storeDataInSession((PortletRequest)actionRequest);
    }

    private static void storeDataInSession(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession(true);
        portletSession.setAttribute("barcode_data", (Object)portletRequest.getParameter("barcode_data"));
    }

    private static Barcode createBarcode(String string) {
        if (string == null) {
            string = "Barcode";
        }
        try {
            Barcode barcode = BarcodeFactory.createCode128(string);
            return barcode;
        }
        catch (BarcodeException barcodeException) {
            throw new RuntimeException(barcodeException);
        }
    }

    private static Barcode createBarcode(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession(true);
        return BarcodePortlet.createBarcode((String)portletSession.getAttribute("barcode_data"));
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        Barcode barcode = BarcodePortlet.createBarcode((PortletRequest)resourceRequest);
        if (barcode == null) {
            barcode = BarcodePortlet.createBarcode("Barcode");
        }
        resourceResponse.setContentType("image/png");
        OutputStream outputStream = resourceResponse.getPortletOutputStream();
        try {
            BarcodeImageHandler.writePNG(barcode, outputStream);
            outputStream.flush();
        }
        catch (OutputException outputException) {
            throw new PortletException((Throwable)outputException);
        }
    }
}

