/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.util.StringHelper;

public class DatabaseMetadata {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$tool$hbm2ddl$DatabaseMetadata == null ? (class$org$hibernate$tool$hbm2ddl$DatabaseMetadata = DatabaseMetadata.class$("org.hibernate.tool.hbm2ddl.DatabaseMetadata")) : class$org$hibernate$tool$hbm2ddl$DatabaseMetadata));
    private final Map tables = new HashMap();
    private final Set sequences = new HashSet();
    private DatabaseMetaData meta;
    private SQLExceptionConverter sqlExceptionConverter;
    private static final String[] TYPES = new String[]{"TABLE"};
    static /* synthetic */ Class class$org$hibernate$tool$hbm2ddl$DatabaseMetadata;

    public DatabaseMetadata(Connection connection, Dialect dialect) throws SQLException {
        this.sqlExceptionConverter = dialect.buildSQLExceptionConverter();
        this.meta = connection.getMetaData();
        this.initSequences(connection, dialect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TableMetadata getTableMetadata(String name, String schema, String catalog) throws HibernateException {
        TableMetadata table = (TableMetadata)this.tables.get(name);
        if (table != null) {
            return table;
        }
        try {
            ResultSet rs = null;
            try {
                rs = this.meta.storesUpperCaseIdentifiers() ? this.meta.getTables(StringHelper.toUpperCase(catalog), StringHelper.toUpperCase(schema), StringHelper.toUpperCase(name), TYPES) : (this.meta.storesLowerCaseIdentifiers() ? this.meta.getTables(StringHelper.toLowerCase(catalog), StringHelper.toLowerCase(schema), StringHelper.toLowerCase(name), TYPES) : this.meta.getTables(catalog, schema, name, TYPES));
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    if (!name.equalsIgnoreCase(tableName)) continue;
                    table = new TableMetadata(rs, this.meta);
                    this.tables.put(name, table);
                    TableMetadata tableMetadata = table;
                    return tableMetadata;
                }
                log.info((Object)("table not found: " + name));
                TableMetadata tableMetadata = null;
                return tableMetadata;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sqle, "could not get table metadata: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSequences(Connection connection, Dialect dialect) throws SQLException {
        String sql = dialect.getQuerySequencesString();
        if (sql != null) {
            Statement statement;
            block7: {
                statement = null;
                ResultSet rs = null;
                try {
                    statement = connection.createStatement();
                    rs = statement.executeQuery(sql);
                    while (rs.next()) {
                        this.sequences.add(rs.getString(1).toLowerCase());
                    }
                    Object var7_6 = null;
                    if (rs == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    throw throwable;
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public boolean isSequence(Object key) {
        return key instanceof String && this.sequences.contains(((String)key).toLowerCase());
    }

    public boolean isTable(Object key) throws HibernateException {
        return key instanceof String && this.getTableMetadata((String)key, null, null) != null;
    }

    public String toString() {
        return "DatabaseMetadata" + this.tables.keySet().toString() + this.sequences.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

