/*
 * Decompiled with CFR 0.152.
 */
package rex.metadata.resultelements;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.utils.DOM;

public class Cell {
    private String value;
    private String fmtValue;
    private String foreColor;
    private String backColor;
    private int cellOrdinal;
    private String defaultCellValue;

    public Cell(Node cellNode) {
        if (cellNode.getAttributes().getNamedItem("CellOrdinal") != null) {
            this.cellOrdinal = Integer.parseInt(cellNode.getAttributes().getNamedItem("CellOrdinal").getNodeValue());
        }
        NodeList nl = cellNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            if (nl.item(i).getNodeName().equals("Value")) {
                this.value = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("FmtValue")) {
                this.fmtValue = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("ForeColor")) {
                this.foreColor = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("BackColor")) {
                this.backColor = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equals("Default")) continue;
            this.defaultCellValue = DOM.getTextFromDOMElement(nl.item(i));
        }
    }

    public Cell(Node cellNode, String _defaultCellValue) {
        this(cellNode);
        this.defaultCellValue = _defaultCellValue;
    }

    public String getDefaultCellValue() {
        return this.defaultCellValue;
    }

    public int getCellOrdinal() {
        return this.cellOrdinal;
    }

    public String getCellValue() {
        return this.value;
    }

    public String toString() {
        if (this.fmtValue != null) {
            return this.fmtValue;
        }
        if (this.value != null) {
            return this.value;
        }
        if (this.defaultCellValue != null) {
            return this.defaultCellValue;
        }
        return null;
    }

    public String getToolTip() {
        return "" + this.fmtValue;
    }
}

