/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.floating.frames;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import org.flexdock.docking.floating.frames.DockingFrame;
import org.flexdock.util.SwingUtility;

public class FrameDragListener
implements MouseListener,
MouseMotionListener {
    private Point dragOffset;
    private DockingFrame frame;
    private boolean enabled;

    public FrameDragListener(DockingFrame frame) {
        this.frame = frame;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.dragOffset = e.getPoint();
        Component c = (Component)e.getSource();
        if (c != this.frame) {
            this.dragOffset = SwingUtilities.convertPoint(c, this.dragOffset, this.frame);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.enabled) {
            Point loc = e.getPoint();
            SwingUtilities.convertPointToScreen(loc, (Component)e.getSource());
            SwingUtility.subtract(loc, this.dragOffset);
            this.frame.setLocation(loc);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

