/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.box;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class LineStyleListCellRenderer
extends JComponent
implements ListCellRenderer {
    private Color selectionBackground = null;
    private Color background = null;
    private Color selectionForeground = null;
    private Color foreground = null;
    private String styleName = "";

    public LineStyleListCellRenderer() {
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.selectionBackground = UIManager.getColor("List.selectionBackground");
        this.background = UIManager.getColor("List.background");
        this.selectionForeground = UIManager.getColor("List.selectionForeground");
        this.foreground = UIManager.getColor("List.foreground");
        this.setMinimumSize(new Dimension(20, 16));
        this.setPreferredSize(new Dimension(20, 16));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setForeground(this.selectionForeground);
            this.setBackground(this.selectionBackground);
        } else {
            this.setForeground(this.foreground);
            this.setBackground(this.background);
        }
        this.styleName = "" + value;
        this.repaint();
        return this;
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.styleName != null) {
            Stroke oldStroke = ((Graphics2D)g).getStroke();
            BasicStroke stroke = null;
            float penWidth = 1.0f;
            if (this.styleName.equals("Solid")) {
                stroke = new BasicStroke(penWidth);
            } else if (this.styleName.equals("Dashed")) {
                stroke = new BasicStroke(penWidth, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
            } else if (this.styleName.equals("Dotted")) {
                stroke = new BasicStroke(penWidth, 0, 2, 0.0f, new float[]{1.0f * penWidth, 1.0f * penWidth}, 0.0f);
            } else if (this.styleName.equals("Double")) {
                stroke = new BasicStroke(penWidth / 3.0f);
            }
            if (stroke != null) {
                ((Graphics2D)g).setStroke(stroke);
                g.setColor(this.getForeground());
                if (!this.styleName.equals("Double")) {
                    ((Graphics2D)g).drawLine(5, this.getHeight() / 2, this.getWidth() - 5, this.getHeight() / 2);
                } else {
                    ((Graphics2D)g).drawLine(5, this.getHeight() / 2 - 1, this.getWidth() - 5, this.getHeight() / 2 - 1);
                    ((Graphics2D)g).drawLine(5, this.getHeight() / 2 + 1, this.getWidth() - 5, this.getHeight() / 2 + 1);
                }
            }
            ((Graphics2D)g).setStroke(oldStroke);
        }
        g.setPaintMode();
        g.setColor(Color.LIGHT_GRAY);
        ((Graphics2D)g).drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }
}

