/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.gui.PropertyHint;
import it.businesslogic.ireport.gui.PropertyHintListCellRenderer;
import it.businesslogic.ireport.util.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class JRPropertyDialog
extends JDialog {
    JRProperty tmpField = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextAreaDescription;
    private JTextField jTextFieldName;
    private int dialogResult;

    public JRPropertyDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRPropertyDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new PropertyHintListCellRenderer());
        this.addHints();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void addHints() {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        dlm.addElement(new PropertyHint("net.sf.jasperreports.text.truncate.at.char", "Applied to text elements.<br>Setting this property to true, the text contents is truncated after the last character that fits the element area.<br>When the text element is rendered on multiple lines, line breaks still occur at word boundaries.<br>It defaults to false."));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.text.truncate.suffix", "Applied to text elements.<br>Use this property to define a suffix to append to the text contents when it is truncated, after the last character that fits the element area.<br>When the text element is rendered on multiple lines, line breaks still occur at word boundaries.\nIt defaults to the empty string."));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.print.keep.full.text", "Applied to text elements.<br>This property is used to preserve the entire content of a text element  so that it's used in data-centric exporters.<br>It defaults to false."));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.text.measurer.factory", "\nApplied to text elements.<br>This property can be set to use custom text measurer implementation for all or specific text elements.<br>It defaults to net.sf.jasperreports.engine.fill.TextMeasurerFactory."));
    }

    public void addExporterHints() {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.character.encoding", "Default: UTF-8"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.graphics2d.min.job.size", "Used by the Graphics2D exporter<br>Default value: true"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.frames.as.nested.tables", "Used by the HTML exporter<br>Default value: true"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.remove.empty.space.between.rows", "Used by the HTML exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.white.page.background", "Used by the HTML exporter<br>Default value: true"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.wrap.break.word", "Used by the HTML exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.size.unit", "Used by the HTML exporter<br>Default value: px"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.using.images.to.align", "Used by the HTML exporter<br>Default value: true"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.force.svg.shapes", "Used by the PDF exporter<br>Default value: true"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.force.linebreak.policy", "Used by the PDF exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", "Used by the PDF exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.compressed", "Used by the PDF exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.encrypted", "Used by the PDF exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.128.bit.key", "Used by the PDF exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.create.custom.palette", "Used by the XLS exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.one.page.per.sheet", "Used by the XLS exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.remove.empty.space.between.rows", "Used by the XLS exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.remove.empty.space.between.columns", "Used by the XLS exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.white.page.background", "Used by the XLS exporter<br>Default value: true"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.detect.cell.type", "Used by the XLS exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.size.fix.enabled", "Used by the XLS exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.ignore.graphics", "Used by the XLS exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.collapse.row.span", "Used by the XLS exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.ignore.cell.border", "Used by the XLS exporter<br>Default value: false"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.max.rows.per.sheet", "Used by the XLS exporter<br>Default value: 0"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xml.validation", "Used by the XML exporter<br>Default value: true"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.csv.field.delimiter", "Used by the CSV exporter<br>Default value: ,"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.csv.record.delimiter", "Used by the CSV exporter<br>Default value: \n (New line)"));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescription = new JTextArea();
        this.jLabel5 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("Add/modify property");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRPropertyDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText("Property name");
        this.jLabel1.setMaximumSize(new Dimension(1000, 100));
        this.jLabel1.setMinimumSize(new Dimension(100, 15));
        this.jLabel1.setPreferredSize(new Dimension(100, 15));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel4.setText("Property value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(200, 40));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 40));
        this.jTextAreaDescription.setMinimumSize(new Dimension(0, 64));
        this.jTextAreaDescription.setPreferredSize(new Dimension(0, 64));
        this.jScrollPane1.setViewportView(this.jTextAreaDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel5.setText("Special meaning properties");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.jScrollPane2.setPreferredSize(new Dimension(200, 200));
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JRPropertyDialog.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(200, 35));
        this.jPanel1.setPreferredSize(new Dimension(250, 35));
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRPropertyDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRPropertyDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 515) / 2, (screenSize.height - 358) / 2, 515, 358);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.jRPropertyDialog.notValidName", "Please insert a valid property name!"), I18n.getString("messages.jRPropertyDialog.notValidNameCaption", "Invalid property!"), 2);
            return;
        }
        this.tmpField = new JRProperty();
        this.tmpField.setName(this.jTextFieldName.getText().trim());
        this.tmpField.setValue(this.jTextAreaDescription.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(evt) && this.jList1.getSelectedValue() != null && this.jList1.getSelectedValue() instanceof PropertyHint) {
            PropertyHint hint = (PropertyHint)this.jList1.getSelectedValue();
            this.jTextFieldName.setText(hint.getPropertyName());
        }
    }

    public static void main(String[] args) {
        new JRPropertyDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public JRProperty getProperty() {
        return this.tmpField;
    }

    public void setProperty(JRProperty tmpField) {
        this.jTextFieldName.setText(new String(tmpField.getName()));
        this.jTextAreaDescription.setText(new String(tmpField.getValue()));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("jRPropertyDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("jRPropertyDialog.buttonOK", "OK"));
        this.jLabel1.setText(I18n.getString("jRPropertyDialog.label1", "Property name"));
        this.jLabel4.setText(I18n.getString("jRPropertyDialog.label4", "Property value"));
        this.setTitle(I18n.getString("jRPropertyDialog.title", "Add/modify property"));
        this.jButtonCancel.setMnemonic(I18n.getString("jRPropertyDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOK.setMnemonic(I18n.getString("jRPropertyDialog.buttonOKMnemonic", "o").charAt(0));
    }
}

