/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.JRCSVDataSourceConnection;
import it.businesslogic.ireport.connection.JRCsvDataSourceInspector;
import it.businesslogic.ireport.gui.FieldPatternDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class CSVDataSourceConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonCSVFilename;
    private JButton jButtonCVSDateFormat;
    private JButton jButtonDeleteParameter;
    private JButton jButtonModifyParameter;
    private JButton jButtonNewParameter;
    private JButton jButtonNewParameter1;
    private JCheckBox jCheckBoxCVSDateFormat;
    private JCheckBox jCheckBoxCVSFirstRowAsHeader;
    private JLabel jLabel15;
    private JList jListCVSColumns;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelCSV;
    private JRadioButton jRadioButtonCVSSeparatorComma;
    private JRadioButton jRadioButtonCVSSeparatorComma1;
    private JRadioButton jRadioButtonCVSSeparatorNewLine;
    private JRadioButton jRadioButtonCVSSeparatorNewLine1;
    private JRadioButton jRadioButtonCVSSeparatorNewLine2;
    private JRadioButton jRadioButtonCVSSeparatorNewLine3;
    private JRadioButton jRadioButtonCVSSeparatorOther;
    private JRadioButton jRadioButtonCVSSeparatorOther1;
    private JRadioButton jRadioButtonCVSSeparatorSemicolon;
    private JRadioButton jRadioButtonCVSSeparatorSemicolon1;
    private JRadioButton jRadioButtonCVSSeparatorSpace;
    private JRadioButton jRadioButtonCVSSeparatorSpace1;
    private JRadioButton jRadioButtonCVSSeparatorTab;
    private JRadioButton jRadioButtonCVSSeparatorTab1;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldCSVFilename;
    private JTextField jTextFieldCVSDateFormat;
    private JTextField jTextFieldCVSSeparatorText;
    private JTextField jTextFieldCVSSeparatorText1;

    public CSVDataSourceConnectionEditor() {
        this.initComponents();
        this.jListCVSColumns.setModel(new DefaultListModel());
        this.jTextFieldCVSDateFormat.setText(new SimpleDateFormat().toPattern());
        this.applyI18n();
        this.jTextFieldCVSSeparatorText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                CSVDataSourceConnectionEditor.this.jRadioButtonCVSSeparatorOther.setSelected(true);
            }

            public void insertUpdate(DocumentEvent e) {
                CSVDataSourceConnectionEditor.this.jRadioButtonCVSSeparatorOther.setSelected(true);
            }

            public void removeUpdate(DocumentEvent e) {
                CSVDataSourceConnectionEditor.this.jRadioButtonCVSSeparatorOther.setSelected(true);
            }
        });
        this.jTextFieldCVSSeparatorText1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                CSVDataSourceConnectionEditor.this.jRadioButtonCVSSeparatorOther1.setSelected(true);
            }

            public void insertUpdate(DocumentEvent e) {
                CSVDataSourceConnectionEditor.this.jRadioButtonCVSSeparatorOther1.setSelected(true);
            }

            public void removeUpdate(DocumentEvent e) {
                CSVDataSourceConnectionEditor.this.jRadioButtonCVSSeparatorOther1.setSelected(true);
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanelCSV = new JPanel();
        this.jLabel15 = new JLabel();
        this.jTextFieldCSVFilename = new JTextField();
        this.jButtonCSVFilename = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel11 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jListCVSColumns = new JList();
        this.jPanel9 = new JPanel();
        this.jButtonNewParameter = new JButton();
        this.jButtonModifyParameter = new JButton();
        this.jButtonDeleteParameter = new JButton();
        this.jPanel10 = new JPanel();
        this.jButtonNewParameter1 = new JButton();
        this.jPanel6 = new JPanel();
        this.jCheckBoxCVSDateFormat = new JCheckBox();
        this.jTextFieldCVSDateFormat = new JTextField();
        this.jButtonCVSDateFormat = new JButton();
        this.jCheckBoxCVSFirstRowAsHeader = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jRadioButtonCVSSeparatorComma = new JRadioButton();
        this.jRadioButtonCVSSeparatorSpace = new JRadioButton();
        this.jRadioButtonCVSSeparatorTab = new JRadioButton();
        this.jRadioButtonCVSSeparatorSemicolon = new JRadioButton();
        this.jRadioButtonCVSSeparatorOther = new JRadioButton();
        this.jTextFieldCVSSeparatorText = new JTextField();
        this.jRadioButtonCVSSeparatorNewLine = new JRadioButton();
        this.jRadioButtonCVSSeparatorNewLine2 = new JRadioButton();
        this.jPanel5 = new JPanel();
        this.jRadioButtonCVSSeparatorComma1 = new JRadioButton();
        this.jRadioButtonCVSSeparatorSpace1 = new JRadioButton();
        this.jRadioButtonCVSSeparatorTab1 = new JRadioButton();
        this.jRadioButtonCVSSeparatorSemicolon1 = new JRadioButton();
        this.jRadioButtonCVSSeparatorNewLine1 = new JRadioButton();
        this.jRadioButtonCVSSeparatorOther1 = new JRadioButton();
        this.jTextFieldCVSSeparatorText1 = new JTextField();
        this.jRadioButtonCVSSeparatorNewLine3 = new JRadioButton();
        this.jPanel12 = new JPanel();
        this.setLayout(new BorderLayout());
        this.jPanelCSV.setPreferredSize(new Dimension(1, 30));
        this.jPanelCSV.setLayout(new GridBagLayout());
        this.jLabel15.setText("CSV file");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanelCSV.add((Component)this.jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanelCSV.add((Component)this.jTextFieldCSVFilename, gridBagConstraints);
        this.jButtonCSVFilename.setText("Browse");
        this.jButtonCSVFilename.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonCSVFilename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CSVDataSourceConnectionEditor.this.jButtonCSVFilenameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 27;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelCSV.add((Component)this.jButtonCSVFilename, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Column names"));
        this.jPanel8.setLayout(new GridBagLayout());
        this.jListCVSColumns.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CSVDataSourceConnectionEditor.this.jListCVSColumnsValueChanged(evt);
            }
        });
        this.jListCVSColumns.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CSVDataSourceConnectionEditor.this.jListCVSColumnsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListCVSColumns);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel9.setPreferredSize(new Dimension(71, 200));
        this.jPanel9.setLayout(new GridBagLayout());
        this.jButtonNewParameter.setText("New");
        this.jButtonNewParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CSVDataSourceConnectionEditor.this.jButtonNewParameterActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel9.add((Component)this.jButtonNewParameter, gridBagConstraints);
        this.jButtonModifyParameter.setText("Modify");
        this.jButtonModifyParameter.setEnabled(false);
        this.jButtonModifyParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CSVDataSourceConnectionEditor.this.jButtonModifyParameterActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel9.add((Component)this.jButtonModifyParameter, gridBagConstraints);
        this.jButtonDeleteParameter.setText("Delete");
        this.jButtonDeleteParameter.setEnabled(false);
        this.jButtonDeleteParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CSVDataSourceConnectionEditor.this.jButtonDeleteParameterActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel9.add((Component)this.jButtonDeleteParameter, gridBagConstraints);
        this.jPanel10.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel9.add((Component)this.jPanel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel8.add((Component)this.jPanel9, gridBagConstraints);
        this.jButtonNewParameter1.setText("Get columns name from the first row of the file");
        this.jButtonNewParameter1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CSVDataSourceConnectionEditor.this.jButtonNewParameterActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel8.add((Component)this.jButtonNewParameter1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel11.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Other"));
        this.jPanel6.setLayout(new GridBagLayout());
        this.jCheckBoxCVSDateFormat.setText("Use custom date format");
        this.jCheckBoxCVSDateFormat.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxCVSDateFormat.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxCVSDateFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CSVDataSourceConnectionEditor.this.jCheckBoxCVSDateFormatActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel6.add((Component)this.jCheckBoxCVSDateFormat, gridBagConstraints);
        this.jTextFieldCVSDateFormat.setEnabled(false);
        this.jTextFieldCVSDateFormat.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel6.add((Component)this.jTextFieldCVSDateFormat, gridBagConstraints);
        this.jButtonCVSDateFormat.setText("Date format");
        this.jButtonCVSDateFormat.setEnabled(false);
        this.jButtonCVSDateFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CSVDataSourceConnectionEditor.this.jButtonCVSDateFormatActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel6.add((Component)this.jButtonCVSDateFormat, gridBagConstraints);
        this.jCheckBoxCVSFirstRowAsHeader.setText("Skip the first line (the column names will be read from the first line)");
        this.jCheckBoxCVSFirstRowAsHeader.setActionCommand("Skip the first line (column names will be read from the first line)");
        this.jCheckBoxCVSFirstRowAsHeader.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxCVSFirstRowAsHeader.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxCVSFirstRowAsHeader.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CSVDataSourceConnectionEditor.this.jCheckBoxCVSDateFormatActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel6.add((Component)this.jCheckBoxCVSFirstRowAsHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel11.add((Component)this.jPanel6, gridBagConstraints);
        this.jTabbedPane1.addTab("Columns", this.jPanel11);
        this.jPanel7.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Field separator (char)"));
        this.jPanel4.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.jRadioButtonCVSSeparatorComma);
        this.jRadioButtonCVSSeparatorComma.setSelected(true);
        this.jRadioButtonCVSSeparatorComma.setText("Comma");
        this.jRadioButtonCVSSeparatorComma.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorComma.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jRadioButtonCVSSeparatorComma, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonCVSSeparatorSpace);
        this.jRadioButtonCVSSeparatorSpace.setText("Space");
        this.jRadioButtonCVSSeparatorSpace.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorSpace.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jRadioButtonCVSSeparatorSpace, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonCVSSeparatorTab);
        this.jRadioButtonCVSSeparatorTab.setText("Tab");
        this.jRadioButtonCVSSeparatorTab.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorTab.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jRadioButtonCVSSeparatorTab, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonCVSSeparatorSemicolon);
        this.jRadioButtonCVSSeparatorSemicolon.setText("Semicolon");
        this.jRadioButtonCVSSeparatorSemicolon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorSemicolon.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jRadioButtonCVSSeparatorSemicolon, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonCVSSeparatorOther);
        this.jRadioButtonCVSSeparatorOther.setText("Other");
        this.jRadioButtonCVSSeparatorOther.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorOther.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jRadioButtonCVSSeparatorOther, gridBagConstraints);
        this.jTextFieldCVSSeparatorText.setPreferredSize(new Dimension(30, 19));
        this.jTextFieldCVSSeparatorText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CSVDataSourceConnectionEditor.this.jTextFieldCVSSeparatorTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel4.add((Component)this.jTextFieldCVSSeparatorText, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonCVSSeparatorNewLine);
        this.jRadioButtonCVSSeparatorNewLine.setText("New line (Unix)");
        this.jRadioButtonCVSSeparatorNewLine.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorNewLine.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jRadioButtonCVSSeparatorNewLine, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonCVSSeparatorNewLine2);
        this.jRadioButtonCVSSeparatorNewLine2.setText("New line (Windows)");
        this.jRadioButtonCVSSeparatorNewLine2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorNewLine2.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jRadioButtonCVSSeparatorNewLine2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel7.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Row separator"));
        this.jPanel5.setLayout(new GridBagLayout());
        this.buttonGroup2.add(this.jRadioButtonCVSSeparatorComma1);
        this.jRadioButtonCVSSeparatorComma1.setText("Comma");
        this.jRadioButtonCVSSeparatorComma1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorComma1.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel5.add((Component)this.jRadioButtonCVSSeparatorComma1, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButtonCVSSeparatorSpace1);
        this.jRadioButtonCVSSeparatorSpace1.setText("Space");
        this.jRadioButtonCVSSeparatorSpace1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorSpace1.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel5.add((Component)this.jRadioButtonCVSSeparatorSpace1, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButtonCVSSeparatorTab1);
        this.jRadioButtonCVSSeparatorTab1.setText("Tab");
        this.jRadioButtonCVSSeparatorTab1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorTab1.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel5.add((Component)this.jRadioButtonCVSSeparatorTab1, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButtonCVSSeparatorSemicolon1);
        this.jRadioButtonCVSSeparatorSemicolon1.setText("Semicolon");
        this.jRadioButtonCVSSeparatorSemicolon1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorSemicolon1.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel5.add((Component)this.jRadioButtonCVSSeparatorSemicolon1, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButtonCVSSeparatorNewLine1);
        this.jRadioButtonCVSSeparatorNewLine1.setSelected(true);
        this.jRadioButtonCVSSeparatorNewLine1.setText("New line");
        this.jRadioButtonCVSSeparatorNewLine1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorNewLine1.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel5.add((Component)this.jRadioButtonCVSSeparatorNewLine1, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButtonCVSSeparatorOther1);
        this.jRadioButtonCVSSeparatorOther1.setText("Other");
        this.jRadioButtonCVSSeparatorOther1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorOther1.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel5.add((Component)this.jRadioButtonCVSSeparatorOther1, gridBagConstraints);
        this.jTextFieldCVSSeparatorText1.setPreferredSize(new Dimension(30, 19));
        this.jTextFieldCVSSeparatorText1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CSVDataSourceConnectionEditor.this.jTextFieldCVSSeparatorText1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel5.add((Component)this.jTextFieldCVSSeparatorText1, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonCVSSeparatorNewLine3);
        this.jRadioButtonCVSSeparatorNewLine3.setText("New line (Windows)");
        this.jRadioButtonCVSSeparatorNewLine3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCVSSeparatorNewLine3.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel5.add((Component)this.jRadioButtonCVSSeparatorNewLine3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel7.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.jPanel12, gridBagConstraints);
        this.jTabbedPane1.addTab("Separators", this.jPanel7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelCSV.add((Component)this.jTabbedPane1, gridBagConstraints);
        this.add((Component)this.jPanelCSV, "Center");
    }

    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        if (this.iReportConnection instanceof JRCSVDataSourceConnection) {
            JRCSVDataSourceConnection con = (JRCSVDataSourceConnection)this.iReportConnection;
            this.jTextFieldCSVFilename.setText(con.getFilename());
            if (con.getCustomDateFormat().length() > 0) {
                this.jCheckBoxCVSDateFormat.setSelected(true);
                this.jTextFieldCVSDateFormat.setText(con.getCustomDateFormat());
                this.jTextFieldCVSDateFormat.setEnabled(true);
                this.jButtonCVSDateFormat.setEnabled(true);
            }
            this.jCheckBoxCVSFirstRowAsHeader.setSelected(con.isUseFirstRowAsHeader());
            String fieldSeparator = con.getFieldDelimiter();
            if (fieldSeparator.equals(",")) {
                this.jRadioButtonCVSSeparatorComma.setSelected(true);
            } else if (fieldSeparator.equals("\t")) {
                this.jRadioButtonCVSSeparatorTab.setSelected(true);
            } else if (fieldSeparator.equals(" ")) {
                this.jRadioButtonCVSSeparatorSpace.setSelected(true);
            } else if (fieldSeparator.equals(";")) {
                this.jRadioButtonCVSSeparatorSemicolon.setSelected(true);
            } else if (fieldSeparator.equals("\n")) {
                this.jRadioButtonCVSSeparatorNewLine.setSelected(true);
            } else if (fieldSeparator.equals("\r\n")) {
                this.jRadioButtonCVSSeparatorNewLine2.setSelected(true);
            } else {
                this.jRadioButtonCVSSeparatorOther.setSelected(true);
                this.jTextFieldCVSSeparatorText.setText(fieldSeparator);
            }
            String rowSeparator = con.getRecordDelimiter();
            if (rowSeparator.equals(",")) {
                this.jRadioButtonCVSSeparatorComma1.setSelected(true);
            } else if (rowSeparator.equals("\t")) {
                this.jRadioButtonCVSSeparatorTab1.setSelected(true);
            } else if (rowSeparator.equals(" ")) {
                this.jRadioButtonCVSSeparatorSpace1.setSelected(true);
            } else if (rowSeparator.equals(";")) {
                this.jRadioButtonCVSSeparatorSemicolon1.setSelected(true);
            } else if (rowSeparator.equals("\n")) {
                this.jRadioButtonCVSSeparatorNewLine1.setSelected(true);
            } else if (fieldSeparator.equals("\r\n")) {
                this.jRadioButtonCVSSeparatorNewLine3.setSelected(true);
            } else {
                this.jRadioButtonCVSSeparatorOther1.setSelected(true);
                this.jTextFieldCVSSeparatorText1.setText(rowSeparator);
            }
            DefaultListModel dlm = (DefaultListModel)this.jListCVSColumns.getModel();
            for (int i = 0; i < con.getColumnNames().size(); ++i) {
                dlm.addElement(con.getColumnNames().elementAt(i) + "");
            }
            if (dlm.size() > 0) {
                this.jListCVSColumns.setSelectedIndex(0);
            }
        }
    }

    public IReportConnection getIReportConnection() {
        JRCSVDataSourceConnection irConn = new JRCSVDataSourceConnection();
        irConn.setFilename(this.jTextFieldCSVFilename.getText().trim());
        if (this.jRadioButtonCVSSeparatorComma.isSelected()) {
            irConn.setFieldDelimiter(",");
        }
        if (this.jRadioButtonCVSSeparatorTab.isSelected()) {
            irConn.setFieldDelimiter("\t");
        }
        if (this.jRadioButtonCVSSeparatorSpace.isSelected()) {
            irConn.setFieldDelimiter(" ");
        }
        if (this.jRadioButtonCVSSeparatorSemicolon.isSelected()) {
            irConn.setFieldDelimiter(";");
        }
        if (this.jRadioButtonCVSSeparatorNewLine.isSelected()) {
            irConn.setFieldDelimiter("\n");
        }
        if (this.jRadioButtonCVSSeparatorNewLine2.isSelected()) {
            irConn.setFieldDelimiter("\r\n");
        }
        if (this.jRadioButtonCVSSeparatorOther.isSelected()) {
            irConn.setFieldDelimiter(this.jTextFieldCVSSeparatorText.getText());
        }
        if (this.jRadioButtonCVSSeparatorComma1.isSelected()) {
            irConn.setRecordDelimiter(",");
        }
        if (this.jRadioButtonCVSSeparatorTab1.isSelected()) {
            irConn.setRecordDelimiter("\t");
        }
        if (this.jRadioButtonCVSSeparatorSpace1.isSelected()) {
            irConn.setRecordDelimiter(" ");
        }
        if (this.jRadioButtonCVSSeparatorSemicolon1.isSelected()) {
            irConn.setRecordDelimiter(";");
        }
        if (this.jRadioButtonCVSSeparatorNewLine1.isSelected()) {
            irConn.setRecordDelimiter("\n");
        }
        if (this.jRadioButtonCVSSeparatorNewLine3.isSelected()) {
            irConn.setRecordDelimiter("\r\n");
        }
        if (this.jRadioButtonCVSSeparatorOther1.isSelected()) {
            irConn.setRecordDelimiter(this.jTextFieldCVSSeparatorText1.getText());
        }
        irConn.setCustomDateFormat(this.jCheckBoxCVSDateFormat.isSelected() ? this.jTextFieldCVSDateFormat.getText() : "");
        irConn.setUseFirstRowAsHeader(this.jCheckBoxCVSFirstRowAsHeader.isSelected());
        DefaultListModel dlm = (DefaultListModel)this.jListCVSColumns.getModel();
        Vector<String> columnsNames = new Vector<String>();
        for (int k = 0; k < dlm.size(); ++k) {
            columnsNames.add(dlm.elementAt(k) + "");
        }
        irConn.setColumnNames(columnsNames);
        if (columnsNames.size() == 0 && JOptionPane.showConfirmDialog(this, I18n.getString("messages.connectionDialog.notAllColumnsDefined", "You have not defined any column for your CSV file. Continue anyway?"), "", 1) != 0) {
            return null;
        }
        if (irConn.getFieldDelimiter().equals(irConn.getRecordDelimiter()) && JOptionPane.showConfirmDialog(this, I18n.getString("messages.connectionDialog.duplicatedDelimiter", "Field delimiter char is the same as the record delimiter. Continue anyway?"), "", 1) != 0) {
            return null;
        }
        this.iReportConnection = irConn;
        return this.iReportConnection;
    }

    public void applyI18n() {
        this.jCheckBoxCVSDateFormat.setText(I18n.getString("connectionDialog.checkBoxCVSDateFormat", "Use custom date format"));
        this.jCheckBoxCVSFirstRowAsHeader.setText(I18n.getString("connectionDialog.checkBoxCVSFirstRowAsHeader", "Skip the first line (the column names will be read from the first line)"));
        this.jRadioButtonCVSSeparatorComma.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorComma", "Comma"));
        this.jRadioButtonCVSSeparatorComma1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorComma1", "Comma"));
        this.jRadioButtonCVSSeparatorNewLine.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorNewLine", "New line"));
        this.jRadioButtonCVSSeparatorNewLine1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorNewLine1", "New line"));
        this.jRadioButtonCVSSeparatorOther.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorOther", "Other"));
        this.jRadioButtonCVSSeparatorOther1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorOther1", "Other"));
        this.jRadioButtonCVSSeparatorSemicolon.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorSemicolon", "Semicolon"));
        this.jRadioButtonCVSSeparatorSemicolon1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorSemicolon1", "Semicolon"));
        this.jRadioButtonCVSSeparatorSpace.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorSpace", "Space"));
        this.jRadioButtonCVSSeparatorSpace1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorSpace1", "Space"));
        this.jRadioButtonCVSSeparatorTab.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorTab", "Tab"));
        this.jRadioButtonCVSSeparatorTab1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorTab1", "Tab"));
        this.jButtonCSVFilename.setText(I18n.getString("connectionDialog.buttonCSVFilename", "Browse"));
        this.jButtonCVSDateFormat.setText(I18n.getString("connectionDialog.buttonCVSDateFormat", "Date format"));
        this.jButtonDeleteParameter.setText(I18n.getString("connectionDialog.buttonDeleteParameter", "Delete"));
        this.jButtonModifyParameter.setText(I18n.getString("connectionDialog.buttonModifyParameter", "Modify"));
        this.jButtonNewParameter.setText(I18n.getString("connectionDialog.buttonNewParameter", "New"));
        this.jButtonNewParameter1.setText(I18n.getString("connectionDialog.buttonNewParameter1", "Get columns name from the first row of the file"));
        this.jTabbedPane1.setTitleAt(0, I18n.getString("connectionDialog.tab.Columns", "Columns"));
        this.jTabbedPane1.setTitleAt(0, I18n.getString("connectionDialog.tab.Separators", "Separators"));
        ((TitledBorder)this.jPanel8.getBorder()).setTitle(I18n.getString("connectionDialog.panelBorder.ColumnNames", "Column names"));
        ((TitledBorder)this.jPanel6.getBorder()).setTitle(I18n.getString("connectionDialog.panelBorder.Other", "Other"));
        ((TitledBorder)this.jPanel4.getBorder()).setTitle(I18n.getString("connectionDialog.panelBorder.FieldSeparatorChat", "Field separator (char)"));
        ((TitledBorder)this.jPanel5.getBorder()).setTitle(I18n.getString("connectionDialog.panelBorder.RowSeparator", "Row separator"));
    }

    private void jButtonCSVFilenameActionPerformed(ActionEvent evt) {
        String fileName = "";
        JFileChooser jfc = new JFileChooser(MainFrame.getMainInstance().getCurrentDirectory());
        jfc.setDialogTitle("Select CSV file....");
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".csv") || file.isDirectory();
            }

            public String getDescription() {
                return "CSV *.csv";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File file = jfc.getSelectedFile();
            try {
                this.jTextFieldCSVFilename.setText(file.getAbsolutePath());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void jListCVSColumnsValueChanged(ListSelectionEvent evt) {
        if (this.jListCVSColumns.getSelectedIndex() >= 0) {
            this.jButtonModifyParameter.setEnabled(true);
            this.jButtonDeleteParameter.setEnabled(true);
        } else {
            this.jButtonModifyParameter.setEnabled(false);
            this.jButtonDeleteParameter.setEnabled(false);
        }
    }

    private void jListCVSColumnsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonModifyParameterActionPerformed1(null);
            }
        }
    }

    private void jCheckBoxCVSDateFormatActionPerformed1(ActionEvent evt) {
    }

    private void jButtonNewParameterActionPerformed11(ActionEvent evt) {
        try {
            JRCsvDataSourceInspector ds = new JRCsvDataSourceInspector(new File(this.jTextFieldCSVFilename.getText()));
            if (this.jRadioButtonCVSSeparatorComma.isSelected()) {
                ds.setFieldDelimiter(',');
            }
            if (this.jRadioButtonCVSSeparatorTab.isSelected()) {
                ds.setFieldDelimiter('\t');
            }
            if (this.jRadioButtonCVSSeparatorSpace.isSelected()) {
                ds.setFieldDelimiter(' ');
            }
            if (this.jRadioButtonCVSSeparatorSemicolon.isSelected()) {
                ds.setFieldDelimiter(';');
            }
            if (this.jRadioButtonCVSSeparatorNewLine.isSelected()) {
                ds.setFieldDelimiter('\n');
            }
            if (this.jRadioButtonCVSSeparatorOther.isSelected()) {
                ds.setFieldDelimiter((this.jTextFieldCVSSeparatorText.getText() + " ").charAt(0));
            }
            if (this.jRadioButtonCVSSeparatorComma1.isSelected()) {
                ds.setRecordDelimiter(",");
            }
            if (this.jRadioButtonCVSSeparatorTab1.isSelected()) {
                ds.setRecordDelimiter("\t");
            }
            if (this.jRadioButtonCVSSeparatorSpace1.isSelected()) {
                ds.setRecordDelimiter(" ");
            }
            if (this.jRadioButtonCVSSeparatorSemicolon1.isSelected()) {
                ds.setRecordDelimiter(";");
            }
            if (this.jRadioButtonCVSSeparatorNewLine1.isSelected()) {
                ds.setRecordDelimiter("\n");
            }
            if (this.jRadioButtonCVSSeparatorOther1.isSelected()) {
                ds.setRecordDelimiter(this.jTextFieldCVSSeparatorText1.getText());
            }
            DefaultListModel dlm = (DefaultListModel)this.jListCVSColumns.getModel();
            dlm.removeAllElements();
            Vector names = ds.getColumnNames();
            for (int i = 0; i < names.size(); ++i) {
                String fname = (names.elementAt(i) + "").trim();
                if (fname.length() <= 0) continue;
                dlm.addElement(fname);
            }
            if (names.size() > 0) {
                this.jListCVSColumns.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), I18n.getString("message.title.exception", "Exception"), 0);
        }
    }

    private void jButtonDeleteParameterActionPerformed1(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jListCVSColumns.getModel();
        Object[] values = this.jListCVSColumns.getSelectedValues();
        for (int i = 0; i < values.length; ++i) {
            dlm.removeElement(values[i]);
        }
    }

    private void jButtonModifyParameterActionPerformed1(ActionEvent evt) {
        int index = this.jListCVSColumns.getSelectedIndex();
        if (index < 0) {
            return;
        }
        DefaultListModel dlm = (DefaultListModel)this.jListCVSColumns.getModel();
        String oldName = (String)dlm.getElementAt(index);
        String name = JOptionPane.showInputDialog(this, I18n.getString("connectionDialog.input.columnName", "Column name"), oldName);
        if (name != null) {
            dlm.setElementAt(name, index);
        }
    }

    private void jButtonNewParameterActionPerformed1(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jListCVSColumns.getModel();
        String name = JOptionPane.showInputDialog(this, I18n.getString("connectionDialog.input.columnName", "Column name"), "COLUMN_" + dlm.getSize());
        if (name != null) {
            dlm.addElement(name);
        }
        if (dlm.size() == 1) {
            this.jListCVSColumns.setSelectedIndex(0);
        }
    }

    private void jTextFieldCVSSeparatorText1ActionPerformed(ActionEvent evt) {
        if (this.jTextFieldCVSSeparatorText1.getText().length() > 0) {
            this.jRadioButtonCVSSeparatorOther1.setSelected(true);
        }
    }

    private void jTextFieldCVSSeparatorTextActionPerformed(ActionEvent evt) {
        if (this.jTextFieldCVSSeparatorText.getText().length() > 0) {
            this.jRadioButtonCVSSeparatorOther.setSelected(true);
        }
    }

    private void jButtonCVSDateFormatActionPerformed(ActionEvent evt) {
        FieldPatternDialog fpd = new FieldPatternDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        fpd.setOnlyDate(true);
        fpd.setVisible(true);
        if (fpd.getDialogResult() == 0) {
            this.jTextFieldCVSDateFormat.setText(fpd.getPattern());
        }
    }

    private void jCheckBoxCVSDateFormatActionPerformed(ActionEvent evt) {
        this.jTextFieldCVSDateFormat.setEnabled(this.jCheckBoxCVSDateFormat.isSelected());
        this.jButtonCVSDateFormat.setEnabled(this.jCheckBoxCVSDateFormat.isSelected());
        if (!this.jCheckBoxCVSDateFormat.isSelected()) {
            this.jTextFieldCVSDateFormat.setText(new SimpleDateFormat().toPattern());
        }
    }
}

