/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListColumnPredicate
extends AbstractColumnPredicate {
    private final List<StarColumnPredicate> children;

    public ListColumnPredicate(RolapStar.Column column, List<StarColumnPredicate> list) {
        super(column);
        this.children = list;
    }

    public List<StarColumnPredicate> getPredicates() {
        return this.children;
    }

    public int hashCode() {
        return ((Object)this.children).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ListColumnPredicate) {
            ListColumnPredicate that = (ListColumnPredicate)obj;
            return ((Object)this.children).equals(that.children);
        }
        return false;
    }

    @Override
    public void values(Collection collection) {
        for (StarColumnPredicate child : this.children) {
            child.values(collection);
        }
    }

    @Override
    public boolean evaluate(Object value) {
        for (StarColumnPredicate childPredicate : this.children) {
            if (!childPredicate.evaluate(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void describe(StringBuilder buf) {
        buf.append("={");
        for (int j = 0; j < this.children.size(); ++j) {
            if (j > 0) {
                buf.append(", ");
            }
            buf.append(this.children.get(j));
        }
        buf.append('}');
    }

    @Override
    public StarColumnPredicate.Overlap intersect(StarColumnPredicate predicate) {
        int matchCount = 0;
        for (StarColumnPredicate flushPredicate : this.children) {
            StarColumnPredicate.Overlap r2 = flushPredicate.intersect(predicate);
            if (!r2.matched) continue;
            if (r2.remaining == null) {
                return r2;
            }
            predicate = r2.remaining;
            ++matchCount;
        }
        if (matchCount == 0) {
            return new StarColumnPredicate.Overlap(false, null, 0.0f);
        }
        float selectivity = (float)matchCount / (float)this.children.size();
        return new StarColumnPredicate.Overlap(true, predicate, selectivity);
    }

    @Override
    public boolean mightIntersect(StarPredicate other) {
        if (other instanceof LiteralStarPredicate) {
            return ((LiteralStarPredicate)other).getValue();
        }
        if (other instanceof ValueColumnPredicate) {
            ValueColumnPredicate valueColumnPredicate = (ValueColumnPredicate)other;
            return this.evaluate(valueColumnPredicate.getValue());
        }
        if (other instanceof ListColumnPredicate) {
            ArrayList thatSet = new ArrayList();
            ((ListColumnPredicate)other).values(thatSet);
            for (Object o : thatSet) {
                if (!this.evaluate(o)) continue;
                return true;
            }
            return false;
        }
        throw Util.newInternal("unknown constraint type " + other);
    }

    @Override
    public StarColumnPredicate minus(StarPredicate predicate) {
        assert (predicate != null);
        if (predicate instanceof LiteralStarPredicate) {
            LiteralStarPredicate literalStarPredicate = (LiteralStarPredicate)predicate;
            if (literalStarPredicate.getValue()) {
                return LiteralStarPredicate.FALSE;
            }
            return this;
        }
        StarColumnPredicate columnPredicate = (StarColumnPredicate)predicate;
        ArrayList<StarColumnPredicate> newChildren = new ArrayList<StarColumnPredicate>(this.children);
        int changeCount = 0;
        Iterator iterator = newChildren.iterator();
        while (iterator.hasNext()) {
            ValueColumnPredicate child = (ValueColumnPredicate)iterator.next();
            if (!columnPredicate.evaluate(child.getValue())) continue;
            ++changeCount;
            iterator.remove();
        }
        if (changeCount > 0) {
            return new ListColumnPredicate(this.getConstrainedColumn(), newChildren);
        }
        return this;
    }
}

