/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.export.flex.JRMxmlExporter;
import net.sf.jasperreports.export.flex.JRMxmlExporterParameter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRMxmlSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_MXML = ".mxml";

    public JRMxmlSaveContributor(Locale locale, ResourceBundle resBundle) {
        super(locale, resBundle);
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName().toLowerCase();
        return name.endsWith(EXTENSION_MXML);
    }

    public String getDescription() {
        return this.getBundleString("file.desc.mxml");
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().toLowerCase().endsWith(EXTENSION_MXML)) {
            file = new File(file.getAbsolutePath() + EXTENSION_MXML);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(this.getBundleString("file.exists"), file.getName()), this.getBundleString("save"), 2)) {
            JRMxmlExporter exporter = new JRMxmlExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
            exporter.setParameter((JRExporterParameter)JRMxmlExporterParameter.IS_EMBEDDING_IMAGES, Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRMxmlExporterParameter.IS_EMBEDDING_FONTS, Boolean.TRUE);
            exporter.exportReport();
        }
    }
}

