/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.TemplateStyle;
import it.businesslogic.ireport.gui.sheet.ColorSelectorPanel;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JasperTemplate {
    private String filename = null;
    private JasperTemplate parent = null;
    private ArrayList<TemplateStyle> styles = new ArrayList();
    private ArrayList<JasperTemplate> templates = new ArrayList();
    private String expression = "";

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public JasperTemplate getParent() {
        return this.parent;
    }

    public void setParent(JasperTemplate parent) {
        this.parent = parent;
    }

    public JasperTemplate() {
        this.reloadTemplate();
    }

    public JasperTemplate(String expression) {
        this.setExpression(expression);
    }

    public void reloadTemplate() {
        if (this.filename == null) {
            return;
        }
        try {
            this.readTemplateFile(this.filename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void readTemplateFile(String xmlFile) throws Exception {
        this.getStyles().clear();
        this.getTemplates().clear();
        File ffile = new File(xmlFile);
        FileInputStream input_source = null;
        if (ffile.exists()) {
            input_source = new FileInputStream(ffile);
            try {
                NodeList children;
                DOMParser parser = new DOMParser();
                parser.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        InputSource inputSource = null;
                        if (systemId != null) {
                            InputStream is;
                            String dtd = null;
                            if (systemId.equals("http://jasperreports.sourceforge.net/dtds/jaspertemplate.dtd") || systemId.equals("http://www.jasperreports.com/dtds/jaspertemplate.dtd")) {
                                dtd = "net/sf/jasperreports/engine/dtds/jaspertemplate.dtd";
                            }
                            ClassLoader classLoader = this.getClass().getClassLoader();
                            URL url = null;
                            if (classLoader != null && (url = classLoader.getResource(dtd)) == null) {
                                classLoader = this.getClass().getClassLoader();
                            }
                            if ((is = classLoader.getResourceAsStream(dtd)) != null) {
                                InputStreamReader isr = new InputStreamReader(is);
                                inputSource = new InputSource(isr);
                            } else {
                                throw new IOException("iReport Internal error in JasperTemplate.java: Could not find: " + dtd + "\n");
                            }
                        }
                        return inputSource;
                    }
                });
                InputSource input_sss = new InputSource(input_source);
                input_sss.setSystemId("file:///" + xmlFile);
                parser.parse(input_sss);
                Document document = parser.getDocument();
                Element node = document.getDocumentElement();
                if (node.getNodeType() == 1 && node.getNodeName().equals("jasperTemplate") && (children = node.getChildNodes()) != null) {
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node child = children.item(i);
                        if (child.getNodeType() == 1 && child.getNodeName().equals("style")) {
                            this.getStyles().add(this.readStyle(child));
                            continue;
                        }
                        if (child.getNodeType() != 1 || !child.getNodeName().equals("template")) continue;
                        String newTemplate = Report.readPCDATA(child);
                        JasperTemplate jt = new JasperTemplate(newTemplate);
                        this.getTemplates().add(jt);
                        jt.setParent(this);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private TemplateStyle readStyle(Node styleNode) {
        TemplateStyle style = new TemplateStyle();
        style.setJasperTemplate(this);
        NamedNodeMap nnm = styleNode.getAttributes();
        for (int i = 0; i < Style.JRXMLStyleAttributes.length; ++i) {
            if (nnm.getNamedItem(Style.JRXMLStyleAttributes[i]) == null) continue;
            style.getAttributes().put(Style.JRXMLStyleAttributes[i], nnm.getNamedItem(Style.JRXMLStyleAttributes[i]).getNodeValue());
        }
        return style;
    }

    public boolean canWrite() {
        try {
            if (this.filename == null) {
                return false;
            }
            File f = new File(this.filename);
            return f.canWrite();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void saveTemplateFile() throws Exception {
        if (this.filename == null) {
            throw new Exception("Unable to save this template!");
        }
        this.saveTemplateFile(this.filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTemplateFile(String xmlFile) throws Exception {
        PrintWriter pw = new PrintWriter(xmlFile);
        this.filename = xmlFile;
        try {
            pw.println("<?xml version=\"1.0\"?>");
            pw.println("<!DOCTYPE jasperTemplate PUBLIC \"-//JasperReports//DTD Template//EN\" \"http://jasperreports.sourceforge.net/dtds/jaspertemplate.dtd\">");
            pw.println("<!-- Created by iReport -->");
            pw.println("<jasperTemplate>");
            for (JasperTemplate jt : this.getTemplates()) {
                pw.println("\t<template><![CDATA[" + jt.getExpression() + "]]></template>");
            }
            for (TemplateStyle style : this.getStyles()) {
                String tabs = "\t";
                pw.println(tabs + "<style ");
                for (int i = 0; i < Style.JRXMLStyleAttributes.length; ++i) {
                    if (!style.getAttributes().containsKey(Style.JRXMLStyleAttributes[i]) || style.getAttributes().get(Style.JRXMLStyleAttributes[i]) == null) continue;
                    Object obj = style.getAttributes().get(Style.JRXMLStyleAttributes[i]);
                    String value = "" + obj;
                    if (obj instanceof Color) {
                        value = Report.writeEncodedColor((Color)obj);
                    }
                    if (Style.JRXMLStyleAttributes[i].toLowerCase().endsWith("color") && value.startsWith("[")) {
                        try {
                            value = Report.writeEncodedColor(ColorSelectorPanel.parseColorString(value));
                        }
                        catch (Exception ex) {
                            value = "black";
                        }
                    }
                    if (Style.JRXMLStyleAttributes[i].equals("style") && (value == null || value.trim().length() == 0)) continue;
                    pw.println(tabs + "\t" + Style.JRXMLStyleAttributes[i] + "=\"" + value + "\"");
                }
                pw.println(tabs + "/>");
            }
            pw.println("</jasperTemplate>");
        }
        finally {
            pw.close();
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ArrayList<JasperTemplate> getTemplates() {
        return this.templates;
    }

    public void setTemplates(ArrayList<JasperTemplate> templates) {
        this.templates = templates;
    }

    public ArrayList<TemplateStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(ArrayList<TemplateStyle> styles) {
        this.styles = styles;
    }

    public String toString() {
        if (this.getFilename() != null && this.getFilename().length() > 0) {
            File f = new File(this.getFilename());
            return f.getName();
        }
        return this.getExpression();
    }
}

