/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.transform.impl.InterceptFieldCallback;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.PropertyAccessException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.proxy.CGLIBProxyFactory;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.AbstractTuplizer;
import org.hibernate.tuple.EntityMetamodel;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.PojoInstantiator;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.util.ReflectHelper;

public class PojoTuplizer
extends AbstractTuplizer {
    static final Log log = LogFactory.getLog((Class)(class$org$hibernate$tuple$PojoTuplizer == null ? (class$org$hibernate$tuple$PojoTuplizer = PojoTuplizer.class$("org.hibernate.tuple.PojoTuplizer")) : class$org$hibernate$tuple$PojoTuplizer));
    private final Class mappedClass;
    private final Class proxyInterface;
    private final boolean lifecycleImplementor;
    private final boolean validatableImplementor;
    private final Set lazyPropertyNames = new HashSet();
    private BulkBean optimizer;
    private FastClass fastClass;
    static /* synthetic */ Class class$org$hibernate$tuple$PojoTuplizer;
    static /* synthetic */ Class class$org$hibernate$classic$Lifecycle;
    static /* synthetic */ Class class$org$hibernate$classic$Validatable;
    static /* synthetic */ Class class$org$hibernate$proxy$HibernateProxy;
    static /* synthetic */ Class class$net$sf$cglib$transform$impl$InterceptFieldEnabled;

    public PojoTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        super(entityMetamodel, mappedEntity);
        this.mappedClass = mappedEntity.getMappedClass();
        this.proxyInterface = mappedEntity.getProxyInterface();
        this.lifecycleImplementor = (class$org$hibernate$classic$Lifecycle == null ? (class$org$hibernate$classic$Lifecycle = PojoTuplizer.class$("org.hibernate.classic.Lifecycle")) : class$org$hibernate$classic$Lifecycle).isAssignableFrom(this.mappedClass);
        this.validatableImplementor = (class$org$hibernate$classic$Validatable == null ? (class$org$hibernate$classic$Validatable = PojoTuplizer.class$("org.hibernate.classic.Validatable")) : class$org$hibernate$classic$Validatable).isAssignableFrom(this.mappedClass);
        Iterator iter = mappedEntity.getPropertyClosureIterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (!property.isLazy()) continue;
            this.lazyPropertyNames.add(property.getName());
        }
        String[] getterNames = new String[this.propertySpan];
        String[] setterNames = new String[this.propertySpan];
        Class[] propTypes = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            getterNames[i] = this.getters[i].getMethodName();
            setterNames[i] = this.setters[i].getMethodName();
            propTypes[i] = this.getters[i].getReturnType();
        }
        if (this.hasCustomAccessors || !Environment.useReflectionOptimizer()) {
            this.fastClass = null;
            this.optimizer = null;
        } else {
            this.fastClass = ReflectHelper.getFastClass(this.mappedClass);
            this.optimizer = ReflectHelper.getBulkBean(this.mappedClass, getterNames, setterNames, propTypes, this.fastClass);
            if (this.optimizer == null) {
                this.fastClass = null;
            }
        }
    }

    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    protected ProxyFactory buildProxyFactory(PersistentClass persistentClass, Getter idGetter, Setter idSetter) {
        HashSet<Class> proxyInterfaces = new HashSet<Class>();
        proxyInterfaces.add(class$org$hibernate$proxy$HibernateProxy == null ? (class$org$hibernate$proxy$HibernateProxy = PojoTuplizer.class$("org.hibernate.proxy.HibernateProxy")) : class$org$hibernate$proxy$HibernateProxy);
        Class mappedClass = persistentClass.getMappedClass();
        Class proxyInterface = persistentClass.getProxyInterface();
        if (proxyInterface != null && !mappedClass.equals(proxyInterface)) {
            if (!proxyInterface.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + this.getEntityName());
            }
            proxyInterfaces.add(proxyInterface);
        }
        if (mappedClass.isInterface()) {
            proxyInterfaces.add(mappedClass);
        }
        Iterator iter = persistentClass.getSubclassIterator();
        while (iter.hasNext()) {
            Subclass subclass = (Subclass)iter.next();
            Class subclassProxy = subclass.getProxyInterface();
            Class subclassClass = subclass.getMappedClass();
            if (subclassProxy == null || subclassClass.equals(subclassProxy)) continue;
            if (!proxyInterface.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + subclass.getEntityName());
            }
            proxyInterfaces.add(subclassProxy);
        }
        Method idGetterMethod = idGetter == null ? null : idGetter.getMethod();
        Method idSetterMethod = idSetter == null ? null : idSetter.getMethod();
        Method proxyGetIdentifierMethod = idGetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idGetterMethod);
        Method proxySetIdentifierMethod = idSetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idSetterMethod);
        CGLIBProxyFactory pf = new CGLIBProxyFactory();
        try {
            pf.postInstantiate(this.getEntityName(), mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod, persistentClass.hasEmbeddedIdentifier() ? (AbstractComponentType)persistentClass.getIdentifier().getType() : null);
        }
        catch (HibernateException he) {
            log.warn((Object)("could not create proxy factory for:" + this.getEntityName()), (Throwable)he);
            pf = null;
        }
        return pf;
    }

    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        return new PojoInstantiator(persistentClass.getMappedClass(), persistentClass.getProxyInterface(), this.fastClass, persistentClass.hasEmbeddedIdentifier());
    }

    public void setPropertyValues(Object entity, Object[] values) throws HibernateException {
        if (!this.getEntityMetamodel().hasLazyProperties() && this.optimizer != null) {
            this.setPropertyValuesWithOptimizer(entity, values);
        } else {
            super.setPropertyValues(entity, values);
        }
    }

    public Object[] getPropertyValues(Object entity) throws HibernateException {
        if (this.shouldGetAllProperties(entity) && this.optimizer != null) {
            return this.getPropertyValuesWithOptimizer(entity);
        }
        return super.getPropertyValues(entity);
    }

    public Object[] getPropertyValuesToInsert(Object entity, SessionImplementor session) throws HibernateException {
        if (this.shouldGetAllProperties(entity) && this.optimizer != null) {
            return this.getPropertyValuesWithOptimizer(entity);
        }
        return super.getPropertyValuesToInsert(entity, session);
    }

    protected void setPropertyValuesWithOptimizer(Object object, Object[] values) {
        try {
            this.optimizer.setPropertyValues(object, values);
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, "exception setting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", true, this.mappedClass, ReflectHelper.getPropertyName(t, this.optimizer));
        }
    }

    protected Object[] getPropertyValuesWithOptimizer(Object object) {
        try {
            return this.optimizer.getPropertyValues(object);
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, "exception getting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", false, this.mappedClass, ReflectHelper.getPropertyName(t, this.optimizer));
        }
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public boolean isLifecycleImplementor() {
        return this.lifecycleImplementor;
    }

    public boolean isValidatableImplementor() {
        return this.validatableImplementor;
    }

    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        return mappedProperty.getGetter(mappedEntity.getMappedClass());
    }

    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        return mappedProperty.getSetter(mappedEntity.getMappedClass());
    }

    public Class getConcreteProxyClass() {
        return this.proxyInterface;
    }

    public void afterInitialize(Object entity, boolean lazyPropertiesAreUnfetched, SessionImplementor session) {
        if (lazyPropertiesAreUnfetched && this.getEntityMetamodel().hasLazyProperties()) {
            ((InterceptFieldEnabled)entity).setInterceptFieldCallback((InterceptFieldCallback)new FieldInterceptor(session, this.getEntityName(), this.lazyPropertyNames));
        }
    }

    public boolean hasUninitializedLazyProperties(Object entity) {
        if (this.getEntityMetamodel().hasLazyProperties()) {
            InterceptFieldCallback callback = ((InterceptFieldEnabled)entity).getInterceptFieldCallback();
            return callback != null && !((FieldInterceptor)callback).isInitialized();
        }
        return false;
    }

    public boolean isLazyPropertyLoadingAvailable() {
        return (class$net$sf$cglib$transform$impl$InterceptFieldEnabled == null ? (class$net$sf$cglib$transform$impl$InterceptFieldEnabled = PojoTuplizer.class$("net.sf.cglib.transform.impl.InterceptFieldEnabled")) : class$net$sf$cglib$transform$impl$InterceptFieldEnabled).isAssignableFrom(this.getMappedClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

