/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.MemberValueCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.fun.TupleFunDef;
import mondrian.olap.type.TupleType;

public class TupleValueCalc
extends GenericCalc {
    private final TupleCalc tupleCalc;
    private final Member[] savedMembers;

    public TupleValueCalc(Exp exp, TupleCalc tupleCalc) {
        super(exp);
        this.tupleCalc = tupleCalc;
        TupleType tupleType = (TupleType)this.tupleCalc.getType();
        this.savedMembers = new Member[tupleType.elementTypes.length];
    }

    public Object evaluate(Evaluator evaluator) {
        Member[] members = this.tupleCalc.evaluateTuple(evaluator);
        if (members == null) {
            return null;
        }
        for (int i = 0; i < members.length; ++i) {
            this.savedMembers[i] = evaluator.setContext(members[i]);
        }
        Object o = evaluator.evaluateCurrent();
        evaluator.setContext(this.savedMembers);
        return o;
    }

    public Calc[] getCalcs() {
        return new Calc[]{this.tupleCalc};
    }

    public Calc optimize() {
        if (this.tupleCalc instanceof TupleFunDef.CalcImpl) {
            TupleFunDef.CalcImpl calc = (TupleFunDef.CalcImpl)this.tupleCalc;
            return new MemberValueCalc(new DummyExp(this.type), calc.getMemberCalcs());
        }
        return this;
    }
}

