/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class GraphicStyle
extends Style {
    private String backcolor = null;
    private String forecolor = null;
    private String style = null;
    private String width = null;

    public GraphicStyle(Writer styleWriter, JRPrintGraphicElement element) {
        super(styleWriter);
        if (element.getMode() == 1) {
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        }
        this.forecolor = JRColorUtil.getColorHexa(element.getLinePen().getLineColor());
        double doubleWidth = element.getLinePen().getLineWidth().doubleValue();
        if (doubleWidth < 0.0) {
            this.style = "none";
        } else {
            switch (element.getLinePen().getLineStyle()) {
                case 1: 
                case 2: {
                    this.style = "dash";
                    break;
                }
                default: {
                    this.style = "solid";
                }
            }
        }
        this.width = String.valueOf(Utility.translatePixelsToInchesWithNoRoundOff(doubleWidth));
    }

    public String getId() {
        StringBuffer id = new StringBuffer();
        id.append(this.backcolor);
        id.append("|");
        id.append(this.forecolor);
        id.append("|");
        id.append(this.style);
        id.append("|");
        id.append(this.width);
        return id.toString();
    }

    public void write(String lineStyleName) throws IOException {
        this.styleWriter.write(" <style:style style:name=\"" + lineStyleName + "\"");
        this.styleWriter.write(" style:family=\"graphic\">\n");
        this.styleWriter.write("   <style:graphic-properties");
        this.styleWriter.write(" draw:fill-color=\"#" + this.backcolor + "\"");
        this.styleWriter.write(" svg:stroke-color=\"#" + this.forecolor + "\"");
        this.styleWriter.write(" draw:stroke=\"" + this.style + "\"");
        this.styleWriter.write(" draw:stroke-dash=\"Dashed\"");
        this.styleWriter.write(" svg:stroke-width=\"" + this.width + "in\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

