/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.rolap.RolapSchema;

class MondrianServerImpl
extends MondrianServer {
    private static MondrianServer.MondrianVersion version = null;

    MondrianServerImpl() {
    }

    public void flushSchemaCache() {
        RolapSchema.clearCache();
    }

    public void flushDataCache() {
    }

    public MondrianServer.MondrianVersion getVersion() {
        return MondrianServerImpl.getVersionStatic();
    }

    private static synchronized MondrianServer.MondrianVersion getVersionStatic() {
        if (version == null) {
            final String versionString = MondrianServerImpl.loadVersionFile();
            version = new MondrianServer.MondrianVersion(){

                public String getVersionString() {
                    return versionString;
                }
            };
        }
        return version;
    }

    private static String loadVersionFile() {
        Package pakkage = MondrianServerImpl.class.getPackage();
        String implementationVersion = pakkage.getImplementationVersion();
        if (implementationVersion != null) {
            return implementationVersion;
        }
        URL resource = MondrianServerImpl.class.getClassLoader().getResource("DefaultRules.xml");
        if (resource != null) {
            try {
                String path = resource.getPath();
                String path2 = Util.replace(path, "classes/DefaultRules.xml", "VERSION.txt");
                URL resource2 = new URL(resource.getProtocol(), resource.getHost(), path2);
                String versionString = Util.readURL(resource2);
                Pattern pattern = Pattern.compile("(?s)Title: (.*)\nVersion: (.*)\nVendor: (.*)\n.*");
                Matcher matcher = pattern.matcher(versionString);
                if (matcher.matches()) {
                    int groupCount = matcher.groupCount();
                    String title = matcher.group(1);
                    String version = matcher.group(2);
                    String vendor = matcher.group(3);
                    return version;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "Unknown version";
    }
}

