/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.prompt;

import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.prompt.PromptDialog;
import java.awt.Frame;
import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Prompter {
    public static HashMap promptForParameters(Report report) {
        HashMap<String, Serializable> hm = new HashMap<String, Serializable>();
        for (int i = 0; i < report.getParameters().size(); ++i) {
            Date time;
            Date d;
            JRParameter param = (JRParameter)report.getParameters().elementAt(i);
            if (!param.isIsForPrompting() || param.getClassType() == null || param.isBuiltin()) continue;
            PromptDialog pd = new PromptDialog((Frame)MainFrame.getMainInstance(), true);
            pd.setParameter(param);
            pd.setVisible(true);
            boolean isCollection = false;
            if (pd.getDialogResult() != 0) continue;
            ArrayList value = pd.getValue();
            if (param.getClassType().equals("java.lang.String")) {
                hm.put(param.getName(), value);
            } else if (param.getClassType().equals("java.lang.Integer")) {
                try {
                    hm.put(param.getName(), new Integer("" + value));
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.lang.Long")) {
                try {
                    hm.put(param.getName(), new Long("" + value));
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.lang.Double")) {
                try {
                    hm.put(param.getName(), new Double("" + value));
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.lang.Float")) {
                try {
                    hm.put(param.getName(), new Float("" + value));
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.lang.Boolean")) {
                try {
                    hm.put(param.getName(), new Boolean("" + value));
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.util.Date")) {
                try {
                    if (value != null) {
                        hm.put(param.getName(), value);
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.sql.Time")) {
                try {
                    d = (Date)((Object)value);
                    time = new Time(d.getTime());
                    hm.put(param.getName(), time);
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.sql.Timestamp")) {
                try {
                    d = (Date)((Object)value);
                    time = new Timestamp(d.getTime());
                    hm.put(param.getName(), time);
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else {
                try {
                    Class<?> clazz = Class.forName(param.getClassType());
                    if (Collection.class.isAssignableFrom(clazz)) {
                        isCollection = true;
                        ArrayList collection = null;
                        collection = new ArrayList();
                        if (value != null) {
                            Prompter.fillCollection(collection, "" + value);
                            param.setLastDefaultValue("" + value);
                            value = collection;
                            try {
                                hm.put(param.getName(), collection);
                            }
                            catch (Exception ex) {
                                System.out.println(ex.getMessage());
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (value == null || isCollection) continue;
            param.setLastDefaultValue(value);
        }
        return hm;
    }

    public static void fillCollection(Collection collection, String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(str, ",", false);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            s = s.trim();
            collection.add(s);
        }
    }
}

