/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * MeterIntervalsSheetPropertyComponent.java
 * 
 * Created on 15 agosto 2005, 13.32
 *
 */

package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.chart.MeterInterval;
import it.businesslogic.ireport.chart.SeriesColor;
import it.businesslogic.ireport.gui.FieldPatternDialog;
import it.businesslogic.ireport.gui.MainFrame;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import it.businesslogic.ireport.util.I18n;

/**
 *
 * @author  Administrator
 */
public class MeterIntervalsSheetPropertyComponent extends javax.swing.JPanel {
    
    private java.util.List listOfMeterIntervals = new java.util.ArrayList();
    
    private boolean init = false;
     
    /** Creates new form ExpressionSheetPanel */
    public MeterIntervalsSheetPropertyComponent() {
        initComponents();       
        
        //javax.swing.BoxLayout bl = new javax.swing.BoxLayout(jPanelColors,javax.swing.BoxLayout.X_AXIS);
        //jPanelColors.setLayout(bl);
        applyI18n();
        setListOfMeterIntervals(listOfMeterIntervals);
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelColors = new javax.swing.JPanel();
        jPanelSample = new javax.swing.JPanel();
        jPanelSpacer = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setBackground(new java.awt.Color(255, 255, 255));
        jPanelColors.setLayout(new javax.swing.BoxLayout(jPanelColors, javax.swing.BoxLayout.X_AXIS));

        jPanelColors.setBackground(new java.awt.Color(255, 255, 255));
        jPanelSample.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0), 1, true));
        jPanelSample.setMaximumSize(new java.awt.Dimension(12, 12));
        jPanelColors.add(jPanelSample);

        jPanelSpacer.setBackground(new java.awt.Color(255, 255, 255));
        jPanelColors.add(jPanelSpacer);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 4);
        add(jPanelColors, gridBagConstraints);

        jButton1.setText("...");
        jButton1.setMaximumSize(new java.awt.Dimension(19, 10));
        jButton1.setMinimumSize(new java.awt.Dimension(19, 10));
        jButton1.setPreferredSize(new java.awt.Dimension(19, 10));
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(jButton1, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed

        MeterIntervalsDialog dialog = null;
        Window topLevel = SwingUtilities.getWindowAncestor(this);
 
        if (topLevel == null)
        {
            dialog = new MeterIntervalsDialog((Frame)null,true);
        }
        else if (topLevel instanceof Frame) {
            dialog = new MeterIntervalsDialog((Frame)topLevel, true);
        }
        else if (topLevel instanceof Dialog) {
            dialog = new MeterIntervalsDialog((Dialog)topLevel, true);
        }
        
        dialog.setMeterIntervals(listOfMeterIntervals );
        if (meterIntervalsHilightExpression != null)
        {
            dialog.setFocusedExpression( meterIntervalsHilightExpression );
        }
        dialog.setVisible(true);
        
        if (dialog.getDialogResult() == JOptionPane.OK_OPTION)
        {
            this.setListOfMeterIntervals( dialog.getMeterIntervals());
            fireActionListenerActionPerformed( new ActionEvent(this,0,"") );
        }
        
    }//GEN-LAST:event_jButton1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanelColors;
    private javax.swing.JPanel jPanelSample;
    private javax.swing.JPanel jPanelSpacer;
    // End of variables declaration//GEN-END:variables

    /**
     * Utility field used by event firing mechanism.
     */
    private javax.swing.event.EventListenerList listenerList =  null;

    /**
     * Registers ActionListener to receive events.
     * @param listener The listener to register.
     */
    public synchronized void addActionListener(java.awt.event.ActionListener listener) {

        if (listenerList == null ) {
            listenerList = new javax.swing.event.EventListenerList();
        }
        listenerList.add (java.awt.event.ActionListener.class, listener);
    }

    /**
     * Removes ActionListener from the list of listeners.
     * @param listener The listener to remove.
     */
    public synchronized void removeActionListener(java.awt.event.ActionListener listener) {

        listenerList.remove (java.awt.event.ActionListener.class, listener);
    }

    /**
     * Notifies all registered listeners about the event.
     * 
     * @param event The event to be fired
     */
    private void fireActionListenerActionPerformed(java.awt.event.ActionEvent event) {

        if (listenerList == null) return;
        Object[] listeners = listenerList.getListenerList ();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i]==java.awt.event.ActionListener.class) {
                ((java.awt.event.ActionListener)listeners[i+1]).actionPerformed (event);
            }
        }
    }

    public boolean isInit() {
        return init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }  

    public java.util.List getListOfMeterIntervals() {
        return listOfMeterIntervals;
    }

    public void setListOfMeterIntervals(java.util.List listOfMeterIntervals) {
        
        if (listOfMeterIntervals == null || !(listOfMeterIntervals instanceof List)) return;
        
        this.listOfMeterIntervals = listOfMeterIntervals;
        
        // Remove all panels...
        jPanelColors.removeAll();
        // Add all panels from the list..
        //jPanelColors.setLayout(new javax.swing.BoxLayout(jPanelColors, javax.swing.BoxLayout.X_AXIS));
        
        //java.awt.GridBagConstraints gridBagConstraints = null;
        for (int i=0; i<listOfMeterIntervals.size(); ++i)
        {
            MeterInterval mi = (MeterInterval)listOfMeterIntervals.get(i);
            javax.swing.JPanel panel = new javax.swing.JPanel();
            panel.setMinimumSize(new java.awt.Dimension(4,12));
            panel.setPreferredSize(new java.awt.Dimension(12,12));
            panel.setMaximumSize(new java.awt.Dimension(12,12));
            
            Color c = mi.getColor()==null ? Color.gray : Color.black;
            
            panel.setBorder(new javax.swing.border.LineBorder(c, 1, true));
            panel.setBackground( mi.getColor() );
            
            //gridBagConstraints = new java.awt.GridBagConstraints();
            //gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 1);
            jPanelColors.add(panel); //, gridBagConstraints);
            jPanelColors.add(javax.swing.Box.createRigidArea(new java.awt.Dimension(1,0)));
        }
        
        
        //gridBagConstraints = new java.awt.GridBagConstraints();
        //gridBagConstraints.weightx = 1.0;
        //jPanelColors.add(jPanelSpacer, gridBagConstraints);
        jPanelColors.updateUI();
        // Add the spacer..
    }
    
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jButton1.setText(I18n.getString("meterIntervalsSheetPropertyComponent.button1","..."));
                // End autogenerated code ----------------------
    }
    
    
    private Object[] meterIntervalsHilightExpression = null; 
    /**
     * This method set the focus on a specific component.
     * 
     * expressionInfo[0] can be something like:
     * COMPONENT_DATASET_SPECIFIC_EXPRESSION, ...
     *
     * If it is COMPONENT_DATASET_SPECIFIC_EXPRESSION, other parameters are expected in the array...
     */
    public void setFocusedExpression(Object[] expressionInfo)
    {
        meterIntervalsHilightExpression = expressionInfo;
        jButton1ActionPerformed(null);
    }
}
