/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.util.Map;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.convert.TextElementConverter;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;

public class StaticTextConverter
extends TextElementConverter {
    private static final StaticTextConverter INSTANCE = new StaticTextConverter();
    private final JRStyledTextParser styledTextParser = new JRStyledTextParser();

    private StaticTextConverter() {
    }

    public static StaticTextConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintText printText = new JRBasePrintText(reportConverter.getDefaultStyleProvider());
        JRStaticText staticText = (JRStaticText)element;
        this.copyTextElement(reportConverter, staticText, printText);
        printText.setText(staticText.getText());
        this.measureTextElement(printText);
        return printText;
    }

    protected JRStyledText getStyledText(JRPrintText printText) {
        String text = printText.getText();
        if (text == null) {
            text = "";
        }
        Map attributes = JRStyledTextAttributeSelector.NO_BACKCOLOR.getStyledTextAttributes(printText);
        return this.styledTextParser.getStyledText(attributes, text, printText.isStyledText());
    }
}

