/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class GraphicStyle
extends Style {
    private String backcolor = null;
    private String forecolor = null;
    private String style = null;
    private String width = null;

    public GraphicStyle(Writer styleWriter, JRPrintGraphicElement element) {
        super(styleWriter);
        if (element.getMode() == 1) {
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        }
        this.forecolor = JRColorUtil.getColorHexa(element.getForecolor());
        double doubleWidth = 0.0;
        switch (element.getPen()) {
            case 4: {
                this.style = "dash";
                doubleWidth = 1.0;
                break;
            }
            case 3: {
                this.style = "solid";
                doubleWidth = 4.0;
                break;
            }
            case 2: {
                this.style = "solid";
                doubleWidth = 2.0;
                break;
            }
            case 5: {
                this.style = "solid";
                doubleWidth = 0.5;
                break;
            }
            case 0: {
                this.style = "none";
                break;
            }
            default: {
                this.style = "solid";
                doubleWidth = 1.0;
            }
        }
        this.width = String.valueOf(Utility.translatePixelsToInchesWithNoRoundOff(doubleWidth));
    }

    public String getId() {
        StringBuffer id = new StringBuffer();
        id.append(this.backcolor);
        id.append("|");
        id.append(this.forecolor);
        id.append("|");
        id.append(this.style);
        id.append("|");
        id.append(this.width);
        return id.toString();
    }

    public void write(String lineStyleName) throws IOException {
        this.styleWriter.write(" <style:style style:name=\"" + lineStyleName + "\"");
        this.styleWriter.write(" style:family=\"graphic\">\n");
        this.styleWriter.write("   <style:graphic-properties");
        this.styleWriter.write(" draw:fill-color=\"#" + this.backcolor + "\"");
        this.styleWriter.write(" svg:stroke-color=\"#" + this.forecolor + "\"");
        this.styleWriter.write(" draw:stroke=\"" + this.style + "\"");
        this.styleWriter.write(" draw:stroke-dash=\"Dashed\"");
        this.styleWriter.write(" svg:stroke-width=\"" + this.width + "in\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

