/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.oasis.BorderStyle;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class CellStyle
extends BorderStyle {
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_MIDDLE = "middle";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    private String backcolor = null;
    private String verticalAlignment = null;

    public CellStyle(Writer styleWriter, JRPrintElement element) {
        super(styleWriter, element);
        if (element.getMode() == 1) {
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        }
        if (element instanceof JRAlignment) {
            switch (((JRAlignment)((Object)element)).getVerticalAlignment()) {
                case 3: {
                    this.verticalAlignment = VERTICAL_ALIGN_BOTTOM;
                    break;
                }
                case 2: {
                    this.verticalAlignment = VERTICAL_ALIGN_MIDDLE;
                    break;
                }
                default: {
                    this.verticalAlignment = VERTICAL_ALIGN_TOP;
                }
            }
        }
    }

    public String getId() {
        return this.backcolor + super.getId() + (this.verticalAlignment != null ? "" : "|" + this.verticalAlignment);
    }

    public void write(String cellStyleName) throws IOException {
        this.styleWriter.write("<style:style style:name=\"");
        this.styleWriter.write(cellStyleName);
        this.styleWriter.write("\"");
        this.styleWriter.write(" style:family=\"table-cell\">\n");
        this.styleWriter.write(" <style:table-cell-properties");
        this.styleWriter.write(" fo:wrap-option=\"wrap\"");
        this.styleWriter.write(" style:shrink-to-fit=\"false\"");
        if (this.backcolor != null) {
            this.styleWriter.write(" fo:background-color=\"#");
            this.styleWriter.write(this.backcolor);
            this.styleWriter.write("\"");
        }
        this.writeBorder(0);
        this.writeBorder(1);
        this.writeBorder(2);
        this.writeBorder(3);
        if (this.verticalAlignment != null) {
            this.styleWriter.write(" style:vertical-align=\"");
            this.styleWriter.write(this.verticalAlignment);
            this.styleWriter.write("\"");
        }
        this.styleWriter.write("/>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

