/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import mondrian.olap.MondrianException;

public class XmlaException
extends MondrianException {
    private final String faultCode;
    private final String code;
    private final String faultString;

    public static String formatFaultCode(XmlaException xex) {
        return XmlaException.formatFaultCode(xex.getFaultCode(), xex.getCode());
    }

    public static String formatFaultCode(String faultCode, String code) {
        return XmlaException.formatFaultCode("SOAP-ENV", faultCode, code);
    }

    public static String formatFaultCode(String nsPrefix, String faultCode, String code) {
        return nsPrefix + ':' + faultCode + '.' + code;
    }

    public static String formatDetail(String msg) {
        return "The Mondrian XML: " + msg;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable t = throwable;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public XmlaException(String faultCode, String code, String faultString, Throwable cause) {
        super(faultString, cause);
        this.faultCode = faultCode;
        this.code = code;
        this.faultString = faultString;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getCode() {
        return this.code;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getDetail() {
        Throwable t = this.getCause();
        String detail = (t = XmlaException.getRootCause(t)).getMessage();
        return detail != null ? detail : t.getClass().getName();
    }
}

