/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Aggregator;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Property;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class AggregateFunDef
extends AbstractAggregateFunDef {
    static final ReflectiveMultiResolver resolver = new ReflectiveMultiResolver("Aggregate", "Aggregate(<Set>[, <Numeric Expression>])", "Returns a calculated value using the appropriate aggregate function, based on the context of the query.", new String[]{"fnx", "fnxn"}, AggregateFunDef.class);

    public AggregateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        return new AbstractCalc(call){

            public Object evaluate(Evaluator evaluator) {
                Aggregator aggregator = (Aggregator)evaluator.getProperty(Property.AGGREGATION_TYPE.name, null);
                if (aggregator == null) {
                    throw FunUtil.newEvalException(null, "Could not find an aggregator in the current evaluation context");
                }
                Aggregator rollup = aggregator.getRollup();
                if (rollup == null) {
                    throw FunUtil.newEvalException(null, "Don't know how to rollup aggregator '" + aggregator + "'");
                }
                List list = AggregateFunDef.this.evaluateCurrentList(listCalc, evaluator);
                return rollup.aggregate(evaluator.push(), list, calc);
            }

            public Calc[] getCalcs() {
                return new Calc[]{listCalc, calc};
            }

            public boolean dependsOn(Dimension dimension) {
                return 1.anyDependsButFirst(this.getCalcs(), dimension);
            }
        };
    }
}

