/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap;

import javax.olap.OLAPException;
import javax.olap.query.dimensionfilters.DimensionFilter;
import javax.olap.query.dimensionfilters.DimensionInsertOffset;
import javax.olap.query.enumerations.DimensionInsertOffsetType;
import javax.olap.query.enumerations.DimensionInsertOffsetTypeEnum;
import javax.olap.query.enumerations.SetActionType;
import javax.olap.query.enumerations.SetActionTypeEnum;
import javax.olap.query.querycoremodel.CompoundDimensionStep;
import javax.olap.query.querycoremodel.DimensionStepManager;
import mondrian.jolap.MondrianDimensionStep;
import mondrian.jolap.MondrianDimensionStepManager;
import mondrian.jolap.MondrianInsertOffset;
import mondrian.jolap.MondrianIntegerInsertOffset;
import mondrian.jolap.MondrianMemberInsertOffset;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.Util;

abstract class MondrianDimensionFilter
extends MondrianDimensionStep
implements DimensionFilter {
    private SetActionType setAction;
    private MondrianInsertOffset dimensionInsertOffset;

    MondrianDimensionFilter(MondrianDimensionStepManager manager) {
        super(manager);
    }

    protected Exp combine(Exp previousExp, Exp exp) {
        if (this.setAction == SetActionTypeEnum.APPEND) {
            return new UnresolvedFunCall("Union", new Exp[]{previousExp, exp});
        }
        if (this.setAction == SetActionTypeEnum.DIFFERENCE) {
            return new UnresolvedFunCall("Minus", new Exp[]{previousExp, exp});
        }
        if (this.setAction == SetActionTypeEnum.INITIAL) {
            return exp;
        }
        if (this.setAction == SetActionTypeEnum.INSERT) {
            return new UnresolvedFunCall("Insert", new Exp[]{previousExp, exp, this.dimensionInsertOffset.convert()});
        }
        if (this.setAction == SetActionTypeEnum.INTERSECTION) {
            return new UnresolvedFunCall("Intersect", new Exp[]{previousExp, exp});
        }
        if (this.setAction == SetActionTypeEnum.PREPEND) {
            return new UnresolvedFunCall("Union", new Exp[]{exp, previousExp});
        }
        throw Util.newInternal("Unknown SetAction " + this.setAction);
    }

    public SetActionType getSetAction() throws OLAPException {
        return this.setAction;
    }

    public void setSetAction(SetActionType input) throws OLAPException {
        this.setAction = input;
    }

    public void setDimensionInsertOffset(DimensionInsertOffset input) throws OLAPException {
        this.dimensionInsertOffset = (MondrianInsertOffset)((Object)input);
    }

    public DimensionInsertOffset getDimensionInsertOffset() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public DimensionInsertOffset createDimensionInsertOffset(DimensionInsertOffsetType type) throws OLAPException {
        if (type == DimensionInsertOffsetTypeEnum.INTEGER_INSERT_OFFSET) {
            return new MondrianIntegerInsertOffset(this);
        }
        if (type == DimensionInsertOffsetTypeEnum.MEMBER_INSERT_OFFSET) {
            return new MondrianMemberInsertOffset(this);
        }
        throw Util.newInternal("Unknown DimensionInsertOffsetType " + type);
    }

    public void setDimensionStepManager(DimensionStepManager value) throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public void setCompoundDimensionStep(CompoundDimensionStep value) throws OLAPException {
        throw new UnsupportedOperationException();
    }
}

