/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JLabel;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.renderer.PainterAware;

public class JRendererLabel
extends JLabel
implements PainterAware {
    protected Painter painter;

    public JRendererLabel() {
        this.setOpaque(true);
    }

    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
    }

    protected void paintComponent(Graphics g) {
        if (this.painter != null) {
            if (this.isOpaque()) {
                this.paintComponentWithPainter((Graphics2D)g);
            } else {
                this.paintPainter(g);
                super.paintComponent(g);
            }
        } else {
            super.paintComponent(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintPainter(Graphics g) {
        Graphics2D scratch = (Graphics2D)g.create();
        try {
            this.painter.paint(scratch, this, this.getWidth(), this.getHeight());
        }
        finally {
            scratch.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponentWithPainter(Graphics2D g) {
        if (this.ui != null) {
            Graphics2D scratchGraphics = (Graphics2D)g.create();
            try {
                scratchGraphics.setColor(this.getBackground());
                scratchGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintPainter(g);
                this.ui.paint(scratchGraphics, this);
            }
            finally {
                scratchGraphics.dispose();
            }
        }
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    public void repaint() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("text".equals(propertyName)) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

