/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.CachedRow;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class DiskNode
extends Node {
    private int iLeft = -1;
    private int iRight = -1;
    private int iParent = -1;
    private int iId;
    private int iData = -1;
    private Table tTable;

    DiskNode(CachedRow cachedRow, DatabaseRowInputInterface databaseRowInputInterface, int n) throws IOException, SQLException {
        this.iId = n;
        this.tTable = cachedRow.getTable();
        this.rData = cachedRow;
        this.iData = cachedRow.iPos;
        this.iBalance = databaseRowInputInterface.readIntData();
        this.iLeft = databaseRowInputInterface.readIntData();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        this.iRight = databaseRowInputInterface.readIntData();
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        this.iParent = databaseRowInputInterface.readIntData();
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    DiskNode(CachedRow cachedRow, int n) {
        this.iId = n;
        this.tTable = cachedRow.getTable();
        if (cachedRow.iPos == -1) {
            this.rData = cachedRow;
        } else {
            this.iData = cachedRow.iPos;
        }
    }

    void delete() {
        this.iBalance = -2;
        this.iParent = 0;
        this.iRight = 0;
        this.iLeft = 0;
        this.tTable = null;
    }

    int getKey() {
        if (this.rData != null) {
            return ((CachedRow)this.rData).iPos;
        }
        return this.iData;
    }

    void setKey(int n) {
        this.iData = n;
        this.rData = null;
    }

    Row getRow() throws SQLException {
        if (this.rData != null) {
            return this.rData;
        }
        if (this.iData == -1) {
            return null;
        }
        return this.tTable.getRow(this.iData);
    }

    private Node findNode(int n, int n2) throws SQLException {
        Node node = null;
        Row row = this.tTable.getRow(n);
        if (row != null) {
            node = row.getNode(n2);
        }
        return node;
    }

    Node getLeft() throws SQLException {
        if (this.iLeft == -1) {
            return null;
        }
        return this.findNode(this.iLeft, this.iId);
    }

    void setLeft(Node node) throws SQLException {
        ((CachedRow)this.getRow()).changed();
        this.iLeft = -1;
        if (node != null) {
            this.iLeft = node.getKey();
        }
    }

    Node getRight() throws SQLException {
        if (this.iRight == -1) {
            return null;
        }
        return this.findNode(this.iRight, this.iId);
    }

    Node getRightPointer() throws SQLException {
        throw Trace.error(40, "wrong method access");
    }

    void setRight(Node node) throws SQLException {
        ((CachedRow)this.getRow()).changed();
        this.iRight = -1;
        if (node != null) {
            this.iRight = node.getKey();
        }
    }

    Node getParent() throws SQLException {
        if (this.iParent == -1) {
            return null;
        }
        return this.findNode(this.iParent, this.iId);
    }

    boolean isRoot() {
        return this.iParent == -1;
    }

    void setParent(Node node) throws SQLException {
        ((CachedRow)this.getRow()).changed();
        this.iParent = -1;
        if (node != null) {
            this.iParent = node.getKey();
        }
    }

    void setBalance(int n) throws SQLException {
        if (this.iBalance != n) {
            ((CachedRow)this.getRow()).changed();
            this.iBalance = n;
        }
    }

    boolean from() throws SQLException {
        if (this.isRoot()) {
            return true;
        }
        DiskNode diskNode = (DiskNode)this.getParent();
        if (diskNode.iLeft != -1) {
            return this.getKey() == diskNode.iLeft;
        }
        return this.equals(diskNode.getLeft());
    }

    Object[] getData() throws SQLException {
        return this.getRow().getData();
    }

    boolean equals(Node node) throws SQLException {
        return node == this;
    }

    void write(DatabaseRowOutputInterface databaseRowOutputInterface) throws IOException, SQLException {
        databaseRowOutputInterface.writeIntData(this.iBalance);
        databaseRowOutputInterface.writeIntData(this.iLeft == -1 ? 0 : this.iLeft);
        databaseRowOutputInterface.writeIntData(this.iRight == -1 ? 0 : this.iRight);
        databaseRowOutputInterface.writeIntData(this.iParent == -1 ? 0 : this.iParent);
    }
}

