/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.undo.PositionedElement;
import java.util.Enumeration;
import java.util.Vector;

public class DeleteElementsOperation
implements UndoOperation {
    private Vector elements = null;
    private JReportFrame jrf = null;
    private CrosstabReportElement crosstabReportElement = null;

    public DeleteElementsOperation(JReportFrame jrf) {
        this.elements = new Vector();
        this.jrf = jrf;
    }

    public DeleteElementsOperation(JReportFrame jrf, CrosstabReportElement crosstabReportElement) {
        this.crosstabReportElement = crosstabReportElement;
        this.elements = new Vector();
        this.jrf = jrf;
    }

    public void redo() {
        if (this.jrf == null && this.crosstabReportElement == null) {
            return;
        }
        Enumeration e = this.getElements().elements();
        Vector<ReportElement> changed_elements = new Vector<ReportElement>();
        while (e.hasMoreElements()) {
            PositionedElement pe = (PositionedElement)e.nextElement();
            ReportElement element = pe.getElement();
            if (this.crosstabReportElement != null) {
                this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().getSelectedElements().remove(element);
                this.crosstabReportElement.getElements().remove(element);
                this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().repaint();
            } else {
                this.jrf.getSelectedElements().remove(element);
                this.jrf.getReport().getElements().remove(element);
                if (element instanceof CrosstabReportElement) {
                    this.jrf.removeCrosstabEditor((CrosstabReportElement)element);
                }
                this.jrf.getReportPanel().repaint();
            }
            changed_elements.add(element);
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.crosstabReportElement, changed_elements, 1));
    }

    public void undo() {
        if (this.jrf == null && this.crosstabReportElement == null) {
            return;
        }
        Vector<ReportElement> changed_elements = new Vector<ReportElement>();
        for (int i = this.getElements().size() - 1; i >= 0; --i) {
            PositionedElement pe = (PositionedElement)this.getElements().get(i);
            ReportElement element = pe.getElement();
            if (this.crosstabReportElement != null) {
                this.crosstabReportElement.getElements().insertElementAt(element, pe.getOldPosition());
            } else {
                this.jrf.getReport().getElements().insertElementAt(element, pe.getOldPosition());
                if (element instanceof CrosstabReportElement) {
                    this.jrf.addCrosstabEditor((CrosstabReportElement)element);
                }
            }
            changed_elements.add(element);
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.crosstabReportElement, changed_elements, 2));
        if (this.crosstabReportElement != null) {
            this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().setSelectedElements(changed_elements);
            this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().repaint();
        } else {
            this.jrf.setSelectedElements(changed_elements);
            this.jrf.getReportPanel().repaint();
        }
    }

    public String toString() {
        return "delete element(s)";
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector elements) {
        this.elements = elements;
    }

    public void addElement(ReportElement element, int position) {
        PositionedElement pe = new PositionedElement(element, position, position);
        this.getElements().add(pe);
    }
}

