/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.expbuilder;

import it.businesslogic.ireport.gui.expbuilder.ExpObject;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ExpObjectCellRenderer
extends JTextPane
implements ListCellRenderer {
    private Color selectionBackground;
    private Color background;
    Style typeStyle = null;
    Style classTypeStyle = null;
    Style parameterStyle = null;
    Style variableStyle = null;
    Style fieldStyle = null;
    Style whiteStyle = null;

    public ExpObjectCellRenderer(JList list) {
        this.selectionBackground = list.getSelectionBackground();
        this.background = list.getBackground();
        DefaultStyledDocument doc = new DefaultStyledDocument();
        this.setDocument(doc);
        this.typeStyle = doc.addStyle("typeStyle", null);
        StyleConstants.setItalic(this.typeStyle, true);
        StyleConstants.setForeground(this.typeStyle, Color.gray);
        this.classTypeStyle = doc.addStyle("classTypeStyle", null);
        StyleConstants.setForeground(this.classTypeStyle, Color.gray);
        this.parameterStyle = doc.addStyle("parameterStyle", null);
        StyleConstants.setForeground(this.parameterStyle, Color.red.darker());
        this.variableStyle = doc.addStyle("variableStyle", null);
        StyleConstants.setForeground(this.variableStyle, Color.blue);
        this.fieldStyle = doc.addStyle("fieldStyle", null);
        StyleConstants.setForeground(this.fieldStyle, Color.green.darker().darker());
        this.whiteStyle = doc.addStyle("whiteStyle", null);
        StyleConstants.setForeground(this.whiteStyle, Color.white);
    }

    public Component getListCellRendererComponent(JList list, Object object, int index, boolean isSelected, boolean cellHasFocus) {
        this.setText("");
        StyledDocument doc = (StyledDocument)this.getDocument();
        if (object instanceof ExpObject) {
            ExpObject eo = (ExpObject)object;
            try {
                doc.insertString(doc.getLength(), eo.getName() + "   ", isSelected ? this.whiteStyle : null);
                Style s = this.parameterStyle;
                String type = "Parameter";
                if (eo.getType() == 0) {
                    s = this.fieldStyle;
                    type = "Field";
                } else if (eo.getType() == 1) {
                    s = this.variableStyle;
                    type = "Variable";
                }
                if (isSelected) {
                    s = this.whiteStyle;
                }
                doc.insertString(doc.getLength(), type + " ", s);
                String tp = eo.getClassType() + "";
                if (tp.lastIndexOf(".") > 0) {
                    tp = tp.substring(tp.lastIndexOf(".") + 1);
                }
                doc.insertString(doc.getLength(), tp, this.classTypeStyle);
            }
            catch (Exception ex) {}
        } else {
            try {
                doc.insertString(doc.getLength(), "" + object, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.setBackground(isSelected ? this.selectionBackground : this.background);
        return this;
    }
}

