/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.NumberDocument;
import it.businesslogic.ireport.gui.event.ValueChangedEvent;
import it.businesslogic.ireport.gui.event.ValueChangedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyVetoException;
import java.text.NumberFormat;
import javax.swing.FocusManager;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;

public class JNumberField
extends JTextField
implements FocusListener,
ValueChangedListener,
KeyListener {
    private int decimals = 2;
    private boolean integer = false;
    private double value = 0.0;
    private double oldValue = 0.0;
    private NumberFormat numberFormat = null;
    private boolean grouping = true;
    private EventListenerList listenerList = null;
    private boolean init = false;
    private NumberDocument nd = new NumberDocument();

    public JNumberField() {
        this.addFocusListener(this);
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setGroupingUsed(true);
        this.setText(this.numberFormat.format(0L));
        this.nd.addValueChangedListener(this);
        this.addKeyListener(this);
        this.setDocument(this.nd);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            FocusManager.getCurrentManager().clearGlobalFocusOwner();
            e.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            FocusManager.getCurrentManager().clearGlobalFocusOwner();
            e.consume();
        }
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            FocusManager.getCurrentManager().clearGlobalFocusOwner();
            e.consume();
        }
    }

    public void valueChanged(ValueChangedEvent evt) {
        if (this.isInit()) {
            return;
        }
        this.value = evt.getNewValue();
    }

    public void textChanged(DocumentEvent evt) {
    }

    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    public int getDecimals() {
        return this.decimals;
    }

    public void setDecimals(int decimals) throws PropertyVetoException {
        this.decimals = decimals;
        if (!this.isInteger()) {
            this.numberFormat.setMaximumFractionDigits(decimals);
            this.numberFormat.setMinimumFractionDigits(decimals);
        }
        this.setText(this.numberFormat.format(this.getValue()));
    }

    public boolean isInteger() {
        return this.integer;
    }

    public void setInteger(boolean integer) throws PropertyVetoException {
        if (integer) {
            this.numberFormat.setMaximumFractionDigits(0);
            this.numberFormat.setMinimumFractionDigits(0);
        } else if (this.getDecimals() == -1) {
            this.numberFormat.setMinimumFractionDigits(1);
            this.numberFormat.setMaximumFractionDigits(100);
        } else {
            this.numberFormat.setMinimumFractionDigits(this.getDecimals());
            this.numberFormat.setMaximumFractionDigits(this.getDecimals());
        }
        this.integer = integer;
        this.setText(this.numberFormat.format(this.getValue()));
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) throws PropertyVetoException {
        this.setInit(true);
        this.value = value;
        this.oldValue = value;
        this.nd.setValue(value);
        this.setText(this.numberFormat.format(this.getValue()));
        this.setInit(false);
    }

    public void setValue(int value) throws PropertyVetoException {
        this.setValue((double)value);
    }

    public void setText(String text) {
        this.setInit(true);
        super.setText(text);
        this.setInit(false);
    }

    public void focusGained(FocusEvent e) {
        if (this.getText().length() == 0) {
            return;
        }
        this.oldValue = this.value;
        this.numberFormat.setGroupingUsed(false);
        this.setText(this.numberFormat.format(this.value));
        this.numberFormat.setGroupingUsed(this.isGrouping());
        this.selectAll();
    }

    public void focusLost(FocusEvent e) {
        if (this.getText().length() == 0) {
            return;
        }
        this.setText(this.numberFormat.format(this.value));
        if (this.oldValue != this.value) {
            this.fireActionListenerActionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public boolean isGrouping() {
        return this.grouping;
    }

    public void setGrouping(boolean grouping) throws PropertyVetoException {
        this.grouping = grouping;
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }
}

