/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.DTListener;
import it.businesslogic.ireport.gui.JMDIFrame;
import it.businesslogic.ireport.gui.event.InternalFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.InternalFrameActivatedListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.EventListenerList;

public class JMDIDesktopPane
extends JDesktopPane
implements Serializable {
    private DropTarget dropTarget;
    private DropTargetListener dtListener;
    private int acceptableActions = 3;
    private static final String PROP_SAMPLE_PROPERTY = "SampleProperty";
    private String sampleProperty;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private EventListenerList listenerList = null;

    public JMDIDesktopPane() {
        this.dtListener = new DTListener();
        this.dropTarget = new DropTarget(this, this.acceptableActions, this.dtListener, true);
    }

    public void internalFrameActivated(JMDIFrame jMDIFrame) {
        this.fireInternalFrameActivatedListenerInternalFrameActivated(new InternalFrameActivatedEvent(jMDIFrame));
    }

    public void internalFrameClosed(JMDIFrame jMDIFrame) {
        if (this.getAllFrames().length == 1) {
            this.fireInternalFrameActivatedListenerInternalFrameActivated(new InternalFrameActivatedEvent(null));
        }
        this.fireInternalFrameActivatedListenerInternalFrameActivated(new InternalFrameActivatedEvent(jMDIFrame, -1));
    }

    public String getSampleProperty() {
        return this.sampleProperty;
    }

    public void setSampleProperty(String value) {
        String oldValue = this.sampleProperty;
        this.sampleProperty = value;
        this.propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, this.sampleProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.propertySupport == null) {
            return;
        }
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public synchronized void addInternalFrameActivatedListener(InternalFrameActivatedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(InternalFrameActivatedListener.class, listener);
    }

    public synchronized void removeInternalFrameActivatedListener(InternalFrameActivatedListener listener) {
        this.listenerList.remove(InternalFrameActivatedListener.class, listener);
    }

    private void fireInternalFrameActivatedListenerInternalFrameActivated(InternalFrameActivatedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != InternalFrameActivatedListener.class) continue;
            ((InternalFrameActivatedListener)listeners[i + 1]).internalFrameActivated(event);
        }
    }

    public void cascade() {
        JInternalFrame[] frames = this.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        JInternalFrame activeframe = this.getSelectedFrame();
        int position = 0;
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setMaximum(false);
                frames[i].setIcon(false);
                frames[i].moveToFront();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (frames[i] == activeframe) continue;
            frames[i].setLocation(position, position);
            position += 24;
        }
        if (activeframe != null) {
            activeframe.moveToFront();
            activeframe.setLocation(position, position);
        }
    }

    public void tileVertically() {
        JInternalFrame[] frames_tmp = this.getAllFrames();
        if (frames_tmp.length == 0) {
            return;
        }
        JInternalFrame[] frames = new JInternalFrame[frames_tmp.length];
        if (this.getSelectedFrame() == null && frames_tmp[0].isIcon()) {
            try {
                frames_tmp[0].setIcon(false);
                frames_tmp[0].setSelected(true);
            }
            catch (Exception ex) {
                return;
            }
        }
        frames[0] = this.getSelectedFrame();
        int k = 1;
        for (int i = 0; i < frames_tmp.length; ++i) {
            if (frames_tmp[i] == frames[0]) continue;
            frames[k] = frames_tmp[i];
            ++k;
        }
        int w = this.getWidth() / frames.length;
        int lastWidth = 0;
        lastWidth = frames.length > 1 ? this.getWidth() - w * (frames.length - 1) : w;
        int h = this.getHeight();
        int posX = 0;
        boolean countVisible = false;
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setMaximum(false);
                frames[i].setIcon(false);
                frames[i].moveToFront();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (i < frames.length) {
                frames[i].setLocation(posX, 0);
                frames[i].setSize(w, h);
                posX += w;
                continue;
            }
            frames[i].setLocation(posX, 0);
            frames[i].setSize(lastWidth, h);
        }
    }

    public void tileHorizontally() {
        JInternalFrame[] frames_tmp = this.getAllFrames();
        if (frames_tmp.length == 0) {
            return;
        }
        JInternalFrame[] frames = new JInternalFrame[frames_tmp.length];
        if (this.getSelectedFrame() == null && frames_tmp[0].isIcon()) {
            try {
                frames_tmp[0].setIcon(false);
                frames_tmp[0].setSelected(true);
            }
            catch (Exception ex) {
                return;
            }
        }
        frames[0] = this.getSelectedFrame();
        int k = 1;
        for (int i = 0; i < frames_tmp.length; ++i) {
            if (frames_tmp[i] == frames[0]) continue;
            frames[k] = frames_tmp[i];
            ++k;
        }
        int w = this.getWidth();
        int h = this.getHeight() / frames.length;
        int lastHeight = 0;
        lastHeight = frames.length > 1 ? this.getHeight() - h * (frames.length - 1) : h;
        int posY = 0;
        boolean countVisible = false;
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setMaximum(false);
                frames[i].setIcon(false);
                frames[i].moveToFront();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (i < frames.length) {
                frames[i].setLocation(0, posY);
                frames[i].setSize(w, h);
                posY += h;
                continue;
            }
            frames[i].setLocation(0, posY);
            frames[i].setSize(w, lastHeight);
        }
    }

    public void tileAnodine() {
        int numCurCol;
        JInternalFrame[] frames_tmp = this.getAllFrames();
        if (frames_tmp.length == 0) {
            return;
        }
        JInternalFrame[] frames = new JInternalFrame[frames_tmp.length];
        if (this.getSelectedFrame() == null && frames_tmp[0].isIcon()) {
            try {
                frames_tmp[0].setIcon(false);
                frames_tmp[0].setSelected(true);
            }
            catch (Exception ex) {
                return;
            }
        }
        frames[0] = this.getSelectedFrame();
        int k = 1;
        for (int i = 0; i < frames_tmp.length; ++i) {
            if (frames_tmp[i] == frames[0]) continue;
            frames[k] = frames_tmp[i];
            ++k;
        }
        int numVisible = frames.length;
        if (numVisible < 1) {
            return;
        }
        int numCols = (int)Math.sqrt(numVisible);
        int[] numRows = new int[numCols];
        for (numCurCol = 0; numCurCol < numCols; ++numCurCol) {
            numRows[numCurCol] = numCols;
        }
        int numCurDiffCol = numCols;
        for (int numDiff = numVisible - numCols * numCols; numDiff > 0; --numDiff) {
            int n = --numCurDiffCol;
            numRows[n] = numRows[n] + 1;
            if (numCurDiffCol >= 1) continue;
            numCurDiffCol = numCols;
        }
        numCurCol = 0;
        int numCurRow = 0;
        int curX = 0;
        int curY = 0;
        int xQuantum = this.getWidth() / numCols;
        int yQuantum = this.getHeight() / numRows[numCurCol];
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setMaximum(false);
                frames[i].setIcon(false);
                frames[i].moveToFront();
            }
            catch (Exception ex) {
                // empty catch block
            }
            frames[i].setLocation(curX, curY);
            frames[i].setSize(xQuantum, yQuantum);
            curY += yQuantum;
            if (++numCurRow != numRows[numCurCol]) continue;
            numCurRow = 0;
            curY = 0;
            curX += xQuantum;
            if (++numCurCol == numCols) continue;
            yQuantum = this.getHeight() / numRows[numCurCol];
        }
    }
}

